/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class Attachment {
    /**
     * The URL of the attachment.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("url")
    private JsonNullable<String> url;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("content_type")
    private JsonNullable<? extends AttachmentContentType> contentType;

    @JsonCreator
    public Attachment(
            @JsonProperty("url") JsonNullable<String> url,
            @JsonProperty("content_type") JsonNullable<? extends AttachmentContentType> contentType) {
        Utils.checkNotNull(url, "url");
        Utils.checkNotNull(contentType, "contentType");
        this.url = url;
        this.contentType = contentType;
    }
    
    public Attachment() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The URL of the attachment.
     */
    @JsonIgnore
    public JsonNullable<String> url() {
        return url;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<AttachmentContentType> contentType() {
        return (JsonNullable<AttachmentContentType>) contentType;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The URL of the attachment.
     */
    public Attachment withUrl(String url) {
        Utils.checkNotNull(url, "url");
        this.url = JsonNullable.of(url);
        return this;
    }

    /**
     * The URL of the attachment.
     */
    public Attachment withUrl(JsonNullable<String> url) {
        Utils.checkNotNull(url, "url");
        this.url = url;
        return this;
    }

    public Attachment withContentType(AttachmentContentType contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = JsonNullable.of(contentType);
        return this;
    }

    public Attachment withContentType(JsonNullable<? extends AttachmentContentType> contentType) {
        Utils.checkNotNull(contentType, "contentType");
        this.contentType = contentType;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Attachment other = (Attachment) o;
        return 
            Utils.enhancedDeepEquals(this.url, other.url) &&
            Utils.enhancedDeepEquals(this.contentType, other.contentType);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            url, contentType);
    }
    
    @Override
    public String toString() {
        return Utils.toString(Attachment.class,
                "url", url,
                "contentType", contentType);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<String> url = JsonNullable.undefined();

        private JsonNullable<? extends AttachmentContentType> contentType = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The URL of the attachment.
         */
        public Builder url(String url) {
            Utils.checkNotNull(url, "url");
            this.url = JsonNullable.of(url);
            return this;
        }

        /**
         * The URL of the attachment.
         */
        public Builder url(JsonNullable<String> url) {
            Utils.checkNotNull(url, "url");
            this.url = url;
            return this;
        }


        public Builder contentType(AttachmentContentType contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = JsonNullable.of(contentType);
            return this;
        }

        public Builder contentType(JsonNullable<? extends AttachmentContentType> contentType) {
            Utils.checkNotNull(contentType, "contentType");
            this.contentType = contentType;
            return this;
        }

        public Attachment build() {

            return new Attachment(
                url, contentType);
        }

    }
}
