/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;


public class BackgroundCheckResultResult {
    /**
     * The result of the test.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends BackgroundCheckResultValue> value;

    /**
     * The source value of the test result.
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends BackgroundCheckResultSourceValue> sourceValue;

    @JsonCreator
    public BackgroundCheckResultResult(
            @JsonProperty("value") JsonNullable<? extends BackgroundCheckResultValue> value,
            @JsonProperty("source_value") JsonNullable<? extends BackgroundCheckResultSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public BackgroundCheckResultResult() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The result of the test.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<BackgroundCheckResultValue> value() {
        return (JsonNullable<BackgroundCheckResultValue>) value;
    }

    /**
     * The source value of the test result.
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<BackgroundCheckResultSourceValue> sourceValue() {
        return (JsonNullable<BackgroundCheckResultSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The result of the test.
     */
    public BackgroundCheckResultResult withValue(BackgroundCheckResultValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The result of the test.
     */
    public BackgroundCheckResultResult withValue(JsonNullable<? extends BackgroundCheckResultValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    /**
     * The source value of the test result.
     */
    public BackgroundCheckResultResult withSourceValue(BackgroundCheckResultSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    /**
     * The source value of the test result.
     */
    public BackgroundCheckResultResult withSourceValue(JsonNullable<? extends BackgroundCheckResultSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BackgroundCheckResultResult other = (BackgroundCheckResultResult) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BackgroundCheckResultResult.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends BackgroundCheckResultValue> value = JsonNullable.undefined();

        private JsonNullable<? extends BackgroundCheckResultSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The result of the test.
         */
        public Builder value(BackgroundCheckResultValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The result of the test.
         */
        public Builder value(JsonNullable<? extends BackgroundCheckResultValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        /**
         * The source value of the test result.
         */
        public Builder sourceValue(BackgroundCheckResultSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        /**
         * The source value of the test result.
         */
        public Builder sourceValue(JsonNullable<? extends BackgroundCheckResultSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public BackgroundCheckResultResult build() {

            return new BackgroundCheckResultResult(
                value, sourceValue);
        }

    }
}
