/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * BalanceUnit
 * 
 * <p>The duration unit of the current balance
 */
public class BalanceUnit {
    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("value")
    private JsonNullable<? extends TimeOffBalancesValue> value;


    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("source_value")
    private JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue;

    @JsonCreator
    public BalanceUnit(
            @JsonProperty("value") JsonNullable<? extends TimeOffBalancesValue> value,
            @JsonProperty("source_value") JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue) {
        Utils.checkNotNull(value, "value");
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.value = value;
        this.sourceValue = sourceValue;
    }
    
    public BalanceUnit() {
        this(JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffBalancesValue> value() {
        return (JsonNullable<TimeOffBalancesValue>) value;
    }

    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<TimeOffBalancesSourceValue> sourceValue() {
        return (JsonNullable<TimeOffBalancesSourceValue>) sourceValue;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    public BalanceUnit withValue(TimeOffBalancesValue value) {
        Utils.checkNotNull(value, "value");
        this.value = JsonNullable.of(value);
        return this;
    }

    /**
     * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
     */
    public BalanceUnit withValue(JsonNullable<? extends TimeOffBalancesValue> value) {
        Utils.checkNotNull(value, "value");
        this.value = value;
        return this;
    }

    public BalanceUnit withSourceValue(TimeOffBalancesSourceValue sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = JsonNullable.of(sourceValue);
        return this;
    }

    public BalanceUnit withSourceValue(JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue) {
        Utils.checkNotNull(sourceValue, "sourceValue");
        this.sourceValue = sourceValue;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BalanceUnit other = (BalanceUnit) o;
        return 
            Utils.enhancedDeepEquals(this.value, other.value) &&
            Utils.enhancedDeepEquals(this.sourceValue, other.sourceValue);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            value, sourceValue);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BalanceUnit.class,
                "value", value,
                "sourceValue", sourceValue);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private JsonNullable<? extends TimeOffBalancesValue> value = JsonNullable.undefined();

        private JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
         */
        public Builder value(TimeOffBalancesValue value) {
            Utils.checkNotNull(value, "value");
            this.value = JsonNullable.of(value);
            return this;
        }

        /**
         * The unified value for the duration unit. If the provider does not specify this unit, the value will be set to unknown
         */
        public Builder value(JsonNullable<? extends TimeOffBalancesValue> value) {
            Utils.checkNotNull(value, "value");
            this.value = value;
            return this;
        }


        public Builder sourceValue(TimeOffBalancesSourceValue sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = JsonNullable.of(sourceValue);
            return this;
        }

        public Builder sourceValue(JsonNullable<? extends TimeOffBalancesSourceValue> sourceValue) {
            Utils.checkNotNull(sourceValue, "sourceValue");
            this.sourceValue = sourceValue;
            return this;
        }

        public BalanceUnit build() {

            return new BalanceUnit(
                value, sourceValue);
        }

    }
}
