/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.components;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

/**
 * <p>Wrapper class for an "open" enum. "Open" enums are those that are expected
 * to evolve (particularly with the addition of enum members over time). If an
 * open enum is used then the appearance of unexpected enum values (say in a 
 * response from an updated an API) will not bring about a runtime error thus 
 * ensuring that non-updated client versions can continue to work without error.
 *
 * <p>Note that instances are immutable and are singletons (an internal thread-safe
 * cache is maintained to ensure that). As a consequence instances created with the 
 * same value will satisfy reference equality (via {@code ==}).
 * 
 * <p>This class is intended to emulate an enum (in terms of common usage and with 
 * reference equality) but with the ability to carry unknown values. Unfortunately
 * Java does not permit the use of an instance in a switch expression but you can 
 * use the {@code asEnum()} method (after dealing with the `Optional` appropriately).
 *
 */
@JsonDeserialize(using = IamRoleValue._Deserializer.class)
@JsonSerialize(using = IamRoleValue._Serializer.class)
public class IamRoleValue {

    public static final IamRoleValue ADMIN = new IamRoleValue("admin");
    public static final IamRoleValue VIEWER = new IamRoleValue("viewer");
    public static final IamRoleValue EDITOR = new IamRoleValue("editor");
    public static final IamRoleValue BASIC = new IamRoleValue("basic");
    public static final IamRoleValue GUEST = new IamRoleValue("guest");
    public static final IamRoleValue UNASSIGNED = new IamRoleValue("unassigned");
    public static final IamRoleValue RESTRICTED = new IamRoleValue("restricted");
    public static final IamRoleValue UNMAPPED_VALUE = new IamRoleValue("unmapped_value");

    // This map will grow whenever a Color gets created with a new
    // unrecognized value (a potential memory leak if the user is not
    // careful). Keep this field lower case to avoid clashing with
    // generated member names which will always be upper cased (Java
    // convention)
    private static final Map<String, IamRoleValue> values = createValuesMap();
    private static final Map<String, IamRoleValueEnum> enums = createEnumsMap();

    private final String value;

    private IamRoleValue(String value) {
        this.value = value;
    }

    /**
     * Returns a IamRoleValue with the given value. For a specific value the 
     * returned object will always be a singleton so reference equality 
     * is satisfied when the values are the same.
     * 
     * @param value value to be wrapped as IamRoleValue
     */ 
    public static IamRoleValue of(String value) {
        synchronized (IamRoleValue.class) {
            return values.computeIfAbsent(value, v -> new IamRoleValue(v));
        }
    }

    public String value() {
        return value;
    }

    public Optional<IamRoleValueEnum> asEnum() {
        return Optional.ofNullable(enums.getOrDefault(value, null));
    }

    public boolean isKnown() {
        return asEnum().isPresent();
    }

    @Override
    public int hashCode() {
        return Objects.hash(value);
    }

    @Override
    public boolean equals(java.lang.Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        IamRoleValue other = (IamRoleValue) obj;
        return Objects.equals(value, other.value);
    }

    @Override
    public String toString() {
        return "IamRoleValue [value=" + value + "]";
    }

    // return an array just like an enum
    public static IamRoleValue[] values() {
        synchronized (IamRoleValue.class) {
            return values.values().toArray(new IamRoleValue[] {});
        }
    }

    private static final Map<String, IamRoleValue> createValuesMap() {
        Map<String, IamRoleValue> map = new LinkedHashMap<>();
        map.put("admin", ADMIN);
        map.put("viewer", VIEWER);
        map.put("editor", EDITOR);
        map.put("basic", BASIC);
        map.put("guest", GUEST);
        map.put("unassigned", UNASSIGNED);
        map.put("restricted", RESTRICTED);
        map.put("unmapped_value", UNMAPPED_VALUE);
        return map;
    }

    private static final Map<String, IamRoleValueEnum> createEnumsMap() {
        Map<String, IamRoleValueEnum> map = new HashMap<>();
        map.put("admin", IamRoleValueEnum.ADMIN);
        map.put("viewer", IamRoleValueEnum.VIEWER);
        map.put("editor", IamRoleValueEnum.EDITOR);
        map.put("basic", IamRoleValueEnum.BASIC);
        map.put("guest", IamRoleValueEnum.GUEST);
        map.put("unassigned", IamRoleValueEnum.UNASSIGNED);
        map.put("restricted", IamRoleValueEnum.RESTRICTED);
        map.put("unmapped_value", IamRoleValueEnum.UNMAPPED_VALUE);
        return map;
    }
    
    @SuppressWarnings("serial")
    public static final class _Serializer extends StdSerializer<IamRoleValue> {

        protected _Serializer() {
            super(IamRoleValue.class);
        }

        @Override
        public void serialize(IamRoleValue value, JsonGenerator g, SerializerProvider provider)
                throws IOException, JsonProcessingException {
            g.writeObject(value.value);
        }
    }

    @SuppressWarnings("serial")
    public static final class _Deserializer extends StdDeserializer<IamRoleValue> {

        protected _Deserializer() {
            super(IamRoleValue.class);
        }

        @Override
        public IamRoleValue deserialize(JsonParser p, DeserializationContext ctxt)
                throws IOException, JacksonException {
            String v = p.readValueAs(new TypeReference<String>() {});
            // use the factory method to ensure we get singletons
            return IamRoleValue.of(v);
        }
    }
    
    public enum IamRoleValueEnum {

        ADMIN("admin"),
        VIEWER("viewer"),
        EDITOR("editor"),
        BASIC("basic"),
        GUEST("guest"),
        UNASSIGNED("unassigned"),
        RESTRICTED("restricted"),
        UNMAPPED_VALUE("unmapped_value"),;

        private final String value;

        private IamRoleValueEnum(String value) {
            this.value = value;
        }

        public String value() {
            return value;
        }
    }
}

