/* 
 * Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT.
 */
package com.stackone.stackone_client_java.models.errors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stackone.stackone_client_java.models.components.ProviderError;
import com.stackone.stackone_client_java.utils.Utils;
import java.lang.Double;
import java.lang.Override;
import java.lang.RuntimeException;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.time.OffsetDateTime;
import java.util.List;
import org.openapitools.jackson.nullable.JsonNullable;


@SuppressWarnings("serial")
public class BadRequestResponse extends RuntimeException {
    /**
     * HTTP status code
     */
    @JsonProperty("statusCode")
    private double statusCode;

    /**
     * Error message
     */
    @JsonProperty("message")
    private String message;

    /**
     * Timestamp when the error occurred
     */
    @JsonProperty("timestamp")
    private OffsetDateTime timestamp;

    /**
     * Error details
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("data")
    private JsonNullable<? extends Data> data;

    /**
     * List of provider-specific errors
     */
    @JsonInclude(Include.NON_ABSENT)
    @JsonProperty("provider_errors")
    private JsonNullable<? extends List<ProviderError>> providerErrors;

    @JsonCreator
    public BadRequestResponse(
            @JsonProperty("statusCode") double statusCode,
            @JsonProperty("message") String message,
            @JsonProperty("timestamp") OffsetDateTime timestamp,
            @JsonProperty("data") JsonNullable<? extends Data> data,
            @JsonProperty("provider_errors") JsonNullable<? extends List<ProviderError>> providerErrors) {
        super("API error occurred");
        Utils.checkNotNull(statusCode, "statusCode");
        Utils.checkNotNull(message, "message");
        Utils.checkNotNull(timestamp, "timestamp");
        Utils.checkNotNull(data, "data");
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.statusCode = statusCode;
        this.message = message;
        this.timestamp = timestamp;
        this.data = data;
        this.providerErrors = providerErrors;
    }
    
    public BadRequestResponse(
            double statusCode,
            String message,
            OffsetDateTime timestamp) {
        this(statusCode, message, timestamp,
            JsonNullable.undefined(), JsonNullable.undefined());
    }

    /**
     * HTTP status code
     */
    @JsonIgnore
    public double statusCode() {
        return statusCode;
    }

    /**
     * Error message
     */
    @JsonIgnore
    public String message() {
        return message;
    }

    @JsonIgnore
    @Override
    public String getMessage() {
        return Utils.valueOrNull(message);
    }

    /**
     * Timestamp when the error occurred
     */
    @JsonIgnore
    public OffsetDateTime timestamp() {
        return timestamp;
    }

    /**
     * Error details
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<Data> data() {
        return (JsonNullable<Data>) data;
    }

    /**
     * List of provider-specific errors
     */
    @SuppressWarnings("unchecked")
    @JsonIgnore
    public JsonNullable<List<ProviderError>> providerErrors() {
        return (JsonNullable<List<ProviderError>>) providerErrors;
    }

    public static Builder builder() {
        return new Builder();
    }


    /**
     * HTTP status code
     */
    public BadRequestResponse withStatusCode(double statusCode) {
        Utils.checkNotNull(statusCode, "statusCode");
        this.statusCode = statusCode;
        return this;
    }

    /**
     * Error message
     */
    public BadRequestResponse withMessage(String message) {
        Utils.checkNotNull(message, "message");
        this.message = message;
        return this;
    }

    /**
     * Timestamp when the error occurred
     */
    public BadRequestResponse withTimestamp(OffsetDateTime timestamp) {
        Utils.checkNotNull(timestamp, "timestamp");
        this.timestamp = timestamp;
        return this;
    }

    /**
     * Error details
     */
    public BadRequestResponse withData(Data data) {
        Utils.checkNotNull(data, "data");
        this.data = JsonNullable.of(data);
        return this;
    }

    /**
     * Error details
     */
    public BadRequestResponse withData(JsonNullable<? extends Data> data) {
        Utils.checkNotNull(data, "data");
        this.data = data;
        return this;
    }

    /**
     * List of provider-specific errors
     */
    public BadRequestResponse withProviderErrors(List<ProviderError> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = JsonNullable.of(providerErrors);
        return this;
    }

    /**
     * List of provider-specific errors
     */
    public BadRequestResponse withProviderErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
        Utils.checkNotNull(providerErrors, "providerErrors");
        this.providerErrors = providerErrors;
        return this;
    }

    @Override
    public boolean equals(java.lang.Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        BadRequestResponse other = (BadRequestResponse) o;
        return 
            Utils.enhancedDeepEquals(this.statusCode, other.statusCode) &&
            Utils.enhancedDeepEquals(this.message, other.message) &&
            Utils.enhancedDeepEquals(this.timestamp, other.timestamp) &&
            Utils.enhancedDeepEquals(this.data, other.data) &&
            Utils.enhancedDeepEquals(this.providerErrors, other.providerErrors);
    }
    
    @Override
    public int hashCode() {
        return Utils.enhancedHash(
            statusCode, message, timestamp,
            data, providerErrors);
    }
    
    @Override
    public String toString() {
        return Utils.toString(BadRequestResponse.class,
                "statusCode", statusCode,
                "message", message,
                "timestamp", timestamp,
                "data", data,
                "providerErrors", providerErrors);
    }

    @SuppressWarnings("UnusedReturnValue")
    public final static class Builder {

        private Double statusCode;

        private String message;

        private OffsetDateTime timestamp;

        private JsonNullable<? extends Data> data = JsonNullable.undefined();

        private JsonNullable<? extends List<ProviderError>> providerErrors = JsonNullable.undefined();

        private Builder() {
          // force use of static builder() method
        }


        /**
         * HTTP status code
         */
        public Builder statusCode(double statusCode) {
            Utils.checkNotNull(statusCode, "statusCode");
            this.statusCode = statusCode;
            return this;
        }


        /**
         * Error message
         */
        public Builder message(String message) {
            Utils.checkNotNull(message, "message");
            this.message = message;
            return this;
        }


        /**
         * Timestamp when the error occurred
         */
        public Builder timestamp(OffsetDateTime timestamp) {
            Utils.checkNotNull(timestamp, "timestamp");
            this.timestamp = timestamp;
            return this;
        }


        /**
         * Error details
         */
        public Builder data(Data data) {
            Utils.checkNotNull(data, "data");
            this.data = JsonNullable.of(data);
            return this;
        }

        /**
         * Error details
         */
        public Builder data(JsonNullable<? extends Data> data) {
            Utils.checkNotNull(data, "data");
            this.data = data;
            return this;
        }


        /**
         * List of provider-specific errors
         */
        public Builder providerErrors(List<ProviderError> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = JsonNullable.of(providerErrors);
            return this;
        }

        /**
         * List of provider-specific errors
         */
        public Builder providerErrors(JsonNullable<? extends List<ProviderError>> providerErrors) {
            Utils.checkNotNull(providerErrors, "providerErrors");
            this.providerErrors = providerErrors;
            return this;
        }

        public BadRequestResponse build() {

            return new BadRequestResponse(
                statusCode, message, timestamp,
                data, providerErrors);
        }

    }
}

