/*
 * Decompiled with CFR 0.152.
 */
package com.stackone.stackone_client_java.models.operations;

import com.stackone.stackone_client_java.SDKConfiguration;
import com.stackone.stackone_client_java.models.components.AtsUpdateJobRequestDto;
import com.stackone.stackone_client_java.models.operations.AtsUpdateJobRequest;
import com.stackone.stackone_client_java.models.operations.AtsUpdateJobResponse;
import com.stackone.stackone_client_java.operations.AtsUpdateJob;
import com.stackone.stackone_client_java.utils.Options;
import com.stackone.stackone_client_java.utils.RetryConfig;
import com.stackone.stackone_client_java.utils.Utils;
import java.util.Optional;

public class AtsUpdateJobRequestBuilder {
    private String xAccountId;
    private String id;
    private AtsUpdateJobRequestDto atsUpdateJobRequestDto;
    private Optional<RetryConfig> retryConfig = Optional.empty();
    private final SDKConfiguration sdkConfiguration;

    public AtsUpdateJobRequestBuilder(SDKConfiguration sdkConfiguration) {
        this.sdkConfiguration = sdkConfiguration;
    }

    public AtsUpdateJobRequestBuilder xAccountId(String xAccountId) {
        Utils.checkNotNull(xAccountId, "xAccountId");
        this.xAccountId = xAccountId;
        return this;
    }

    public AtsUpdateJobRequestBuilder id(String id) {
        Utils.checkNotNull(id, "id");
        this.id = id;
        return this;
    }

    public AtsUpdateJobRequestBuilder atsUpdateJobRequestDto(AtsUpdateJobRequestDto atsUpdateJobRequestDto) {
        Utils.checkNotNull(atsUpdateJobRequestDto, "atsUpdateJobRequestDto");
        this.atsUpdateJobRequestDto = atsUpdateJobRequestDto;
        return this;
    }

    public AtsUpdateJobRequestBuilder retryConfig(RetryConfig retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = Optional.of(retryConfig);
        return this;
    }

    public AtsUpdateJobRequestBuilder retryConfig(Optional<RetryConfig> retryConfig) {
        Utils.checkNotNull(retryConfig, "retryConfig");
        this.retryConfig = retryConfig;
        return this;
    }

    private AtsUpdateJobRequest buildRequest() {
        AtsUpdateJobRequest request = new AtsUpdateJobRequest(this.xAccountId, this.id, this.atsUpdateJobRequestDto);
        return request;
    }

    public AtsUpdateJobResponse call() throws Exception {
        Optional<Options> options = Optional.of(Options.builder().retryConfig(this.retryConfig).build());
        AtsUpdateJob.Sync operation = new AtsUpdateJob.Sync(this.sdkConfiguration, options);
        AtsUpdateJobRequest request = this.buildRequest();
        return (AtsUpdateJobResponse)operation.handleResponse(operation.doRequest(request));
    }
}

