/*
 * Decompiled with CFR 0.152.
 */
package com.turtlequeue;

import com.google.common.base.MoreObjects;
import com.turtlequeue.Client;
import com.turtlequeue.ClientImpl;
import com.turtlequeue.Consumer;
import com.turtlequeue.ConsumerImpl;
import com.turtlequeue.Message;
import com.turtlequeue.MessageId;
import com.turtlequeue.MessageIdImpl;
import com.turtlequeue.Producer;
import com.turtlequeue.ProducerImpl;
import com.turtlequeue.Topic;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public class MessageImpl<T>
implements Message<T> {
    ClientImpl c = null;
    ConsumerImpl<T> consumer = null;
    MessageId messageId = null;
    T data = null;
    String producerName = null;
    Long eventTime = null;
    Long publishTime = null;
    Topic topic = null;
    String key = null;
    Map<String, String> properties = null;
    ProducerImpl<T> producer = null;
    Boolean isReplicated = null;
    String replicatedFrom = null;
    Long delay = null;
    TimeUnit delayTimeUnit = null;
    Integer redeliveryCount = null;

    public MessageImpl(ClientImpl c, ConsumerImpl<T> consumer, MessageIdImpl messageId, T payload, String producerName, Long eventTime, Long publishTime, Topic topic, String key, Map<String, String> properties, ProducerImpl<T> producer, Boolean isReplicated, String replicatedFrom, Long delay, TimeUnit delayTimeUnit, Integer redeliveryCount) {
        this.c = c;
        this.consumer = consumer;
        this.messageId = messageId;
        this.data = payload;
        this.producerName = producerName;
        this.eventTime = eventTime;
        this.publishTime = publishTime;
        this.topic = topic;
        this.key = key;
        this.properties = properties;
        this.producer = producer;
        this.isReplicated = isReplicated;
        this.replicatedFrom = replicatedFrom;
        this.delay = delay;
        this.delayTimeUnit = delayTimeUnit;
        this.redeliveryCount = redeliveryCount;
    }

    @Override
    public MessageId getMessageId() {
        return this.messageId;
    }

    @Override
    public T getData() {
        return this.data;
    }

    @Override
    public Consumer<T> getConsumer() {
        return this.consumer;
    }

    @Override
    public Client getClient() {
        return this.c;
    }

    @Override
    public String getProducerName() {
        return this.producerName;
    }

    @Override
    public Long getEventTime() {
        return this.eventTime;
    }

    @Override
    public Long getPublishTime() {
        return this.publishTime;
    }

    @Override
    public boolean isReplicated() {
        if (this.isReplicated != null) {
            return this.isReplicated;
        }
        return true;
    }

    @Override
    public String getReplicatedFrom() {
        return this.replicatedFrom;
    }

    @Override
    public Integer getRedeliveryCount() {
        return this.redeliveryCount;
    }

    @Override
    public Topic getTopic() {
        if (this.topic != null && this.topic.getTopic() != null) {
            return this.topic;
        }
        if (this.consumer != null) {
            return this.consumer.getTopic();
        }
        return null;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public CompletableFuture<Void> acknowledge() {
        return this.consumer.acknowledge(this);
    }

    @Override
    public Long getDelayValue() {
        return this.delay;
    }

    @Override
    public TimeUnit getDelayTimeUnit() {
        return this.delayTimeUnit;
    }

    @Override
    public Producer<T> getProducer() {
        return this.producer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message t = (Message)o;
        return Objects.equals(this.getTopic(), t.getTopic()) && Objects.equals(this.getMessageId(), t.getMessageId()) && Objects.equals(this.getProducerName(), t.getProducerName()) && Objects.equals(this.getEventTime(), t.getEventTime()) && Objects.equals(this.getPublishTime(), t.getPublishTime()) && Objects.equals(this.getTopic(), t.getTopic()) && Objects.equals(this.getKey(), t.getKey()) && Objects.equals(this.getProperties(), t.getProperties()) && Objects.equals(this.getProducer(), t.getProducer());
    }

    public int hashCode() {
        return Objects.hash(this.getTopic(), this.getProducerName(), this.getMessageId(), this.getEventTime(), this.getKey(), this.getPublishTime(), this.getProducer());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("topic", (Object)this.topic).add("producerName", (Object)this.producerName).add("eventTime", (Object)this.eventTime).add("publishTime", (Object)this.publishTime).add("key", (Object)this.key).toString();
    }
}

