/*
 * Decompiled with CFR 0.152.
 */
package com.xwl41.common.basic.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public abstract class CoreUtil {
    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !CoreUtil.isEmpty(str);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CoreUtil.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CoreUtil.isEmpty(map);
    }

    public static class FILE {
        /*
         * Enabled aggressive exception aggregation
         */
        public static String getTextFromResource(String path) {
            block13: {
                try (InputStream in = FILE.class.getResourceAsStream(path);){
                    String string;
                    if (in == null) break block13;
                    try (BufferedInputStream bis = new BufferedInputStream(in);){
                        string = new String(FILE.toByteArray(bis));
                    }
                    return string;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            return null;
        }

        public static String getTextFromFile(String path) {
            String string;
            File f = new File(path);
            if (!f.exists()) {
                return null;
            }
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(f));
            try {
                string = new String(FILE.toByteArray(bis));
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    return null;
                }
            }
            bis.close();
            return string;
        }

        private static byte[] toByteArray(InputStream in) throws IOException {
            int n;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
            }
            return out.toByteArray();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void saveToFile(InputStream inputStream, String fileName) {
            OutputStream os = null;
            try {
                byte[] bs = new byte[1024];
                File tempFile = new File(fileName);
                if (tempFile.exists() || tempFile.createNewFile()) {
                    int len;
                    os = new FileOutputStream(tempFile);
                    while ((len = inputStream.read(bs)) != -1) {
                        os.write(bs, 0, len);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static class NUMERIC {
        public static final int DEFAULT_SCALE = 4;
        public static final int DEFAULT_SCALE_SHORT = 2;

        public static BigDecimal toDecimal(double value) {
            return new BigDecimal(String.valueOf(value));
        }

        public static BigDecimal toDecimal(float value) {
            return new BigDecimal(String.valueOf(value));
        }

        public static BigDecimal nullToZero(BigDecimal value) {
            return value == null ? new BigDecimal("0") : value;
        }

        public static BigDecimal divide(BigDecimal bd1, BigDecimal bd2) {
            return bd1.divide(bd2, 4, RoundingMode.HALF_UP);
        }

        public static BigDecimal divide(BigDecimal bd1, BigDecimal bd2, int scale) {
            return bd1.divide(bd2, scale, RoundingMode.HALF_UP);
        }

        public static BigDecimal divide(BigDecimal bd1, BigDecimal bd2, RoundingMode roundingMode) {
            return bd1.divide(bd2, 4, roundingMode);
        }
    }

    public static class DATETIME {
        public static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
        public static final String DEFAULT_DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
        public static final String DEFAULT_DATE_FORMAT_COMPACT = "yyyyMMdd";
        public static final String DEFAULT_DATETIME_FORMAT_COMPACT = "yyyyMMddHHmmss";
        public static final DateTimeFormatter DEFAULT_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        public static final DateTimeFormatter DEFAULT_DATETIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        public static final ZoneOffset ZONE_OFFSET_8 = ZoneOffset.ofHours(8);

        public static String toString(Date date) {
            return new SimpleDateFormat(DEFAULT_DATETIME_FORMAT).format(date);
        }

        public static String toString(Date date, String datetimeFmt) {
            return new SimpleDateFormat(datetimeFmt).format(date);
        }

        public static String toString(LocalDateTime localDateTime) {
            return localDateTime.format(DEFAULT_DATETIME_FORMATTER);
        }

        public static String toString(LocalDateTime localDateTime, String datetimeFmt) {
            return localDateTime.format(DateTimeFormatter.ofPattern(datetimeFmt));
        }

        public static String toCompactDateStr(LocalDateTime localDateTime) {
            return DATETIME.toString(localDateTime, DEFAULT_DATE_FORMAT_COMPACT);
        }

        public static String toCompactDateTimeStr(LocalDateTime localDateTime) {
            return DATETIME.toString(localDateTime, DEFAULT_DATETIME_FORMAT_COMPACT);
        }

        public static Date toDate(LocalDateTime localDateTime) {
            return new Date(localDateTime.toInstant(ZoneOffset.UTC).toEpochMilli());
        }

        public static LocalDate toLocalDate(String dateStr) {
            return LocalDate.parse(dateStr, DEFAULT_DATE_FORMATTER);
        }

        public static LocalDateTime toLocalDateTime(String dateTimeStr) {
            return LocalDateTime.parse(dateTimeStr, DEFAULT_DATETIME_FORMATTER);
        }

        public static LocalDateTime dateStrToLocalDateTime(String dateStr) {
            return LocalDateTime.of(DATETIME.toLocalDate(dateStr), LocalTime.MIN);
        }

        public static LocalDateTime utcNow() {
            return LocalDateTime.now(ZoneOffset.UTC);
        }

        public static LocalDateTime utcToCn(LocalDateTime utcDateTime) {
            return LocalDateTime.ofInstant(utcDateTime.toInstant(ZoneOffset.UTC), ZONE_OFFSET_8);
        }

        public static LocalDateTime cnToUtc(LocalDateTime cnDateTime) {
            return LocalDateTime.ofInstant(cnDateTime.toInstant(ZONE_OFFSET_8), ZoneOffset.UTC);
        }
    }
}

