/*
 * Decompiled with CFR 0.152.
 */
package com.xwl41.common.basic.util;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ReflectUtil {
    public static List<String> getDeclaredFields(Object obj) {
        return ReflectUtil.getDeclaredFields(obj, null);
    }

    public static List<String> getDeclaredFields(Object obj, List<String> excludeFields) {
        LinkedList<String> fieldList = new LinkedList<String>();
        if (obj == null) {
            return fieldList;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                if (excludeFields != null && excludeFields.contains(field.getName())) continue;
                fieldList.add(field.getName());
            }
        }
        return fieldList;
    }

    public static Map<String, Object> getDeclaredFieldsWithValue(Object obj, List<String> excludeFields) throws IllegalAccessException {
        List<Object> excludes;
        LinkedHashMap<String, Object> fieldValueMap = new LinkedHashMap<String, Object>();
        List<Object> list = excludes = excludeFields == null || excludeFields.isEmpty() ? new ArrayList() : excludeFields;
        if (obj == null) {
            return fieldValueMap;
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        if (fields.length > 0) {
            for (Field field : fields) {
                if (excludes.contains(field.getName())) continue;
                field.setAccessible(true);
                fieldValueMap.put(field.getName(), field.get(obj));
            }
        }
        return fieldValueMap;
    }

    public static Object getDeclaredFieldValue(Object obj, String fieldName) {
        if (obj == null) {
            return null;
        }
        Object value = null;
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            value = field.get(obj);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
        }
        return value;
    }
}

