/*
 * Decompiled with CFR 0.152.
 */
package MarcSync;

import MarcSync.Entry;
import MarcSync.classes.CollectionUpdatePayload;
import MarcSync.classes.EntryData;
import MarcSync.classes.EntryDataPayload;
import MarcSync.classes.EntryFilterPayload;
import MarcSync.classes.EntryResponse;
import MarcSync.classes.EntryUpdatePayload;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;

public class Collection {
    private final String _accessToken;
    private final String _collectionName;
    private final ObjectMapper _mapper;

    public Collection(String accessToken, String collectionName) {
        this._accessToken = accessToken;
        this._collectionName = collectionName;
        this._mapper = new ObjectMapper();
        this._mapper.enable(SerializationFeature.INDENT_OUTPUT);
        this._mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public void drop() throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v0/collection/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to drop collection: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    public String setName(String name) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v0/collection/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(new Gson().toJson((Object)new CollectionUpdatePayload(name)).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to rename collection: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return name;
    }

    public String getName() {
        return this._collectionName;
    }

    public boolean exists() {
        try {
            URL url = new URI("https://api.marcsync.dev/v0/collection/" + this._collectionName).toURL();
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("accept", "application/json");
            connection.setRequestProperty("authorization", this._accessToken);
            return connection.getResponseCode() == 200;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Entry createEntry(EntryData entryData) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v0/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("POST");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(this._mapper.writeValueAsString((Object)new EntryDataPayload(entryData)).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to create entry: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
        return new Entry(this._accessToken, this._collectionName, entryData);
    }

    public Entry getEntryById(final String id) throws URISyntaxException, IOException, InterruptedException {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().method("GET", HttpRequest.BodyPublishers.ofString(this._mapper.writeValueAsString((Object)new EntryFilterPayload(new EntryData(){
            {
                this.put("_id", id);
            }
        })))).uri(new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName)).header("accept", "application/json").header("authorization", this._accessToken).header("content-type", "application/json").build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Failed to get entry: " + response.statusCode() + " " + response.body());
        }
        return new Entry(this._accessToken, this._collectionName, ((EntryResponse)new Gson().fromJson((String)response.body(), EntryResponse.class)).entries[0]);
    }

    public Entry[] getEntries(EntryData filters) throws IOException, InterruptedException, URISyntaxException {
        HttpRequest request;
        HttpClient client = HttpClient.newHttpClient();
        HttpResponse<String> response = client.send(request = HttpRequest.newBuilder().method("GET", HttpRequest.BodyPublishers.ofString(this._mapper.writeValueAsString((Object)new EntryFilterPayload(filters)))).uri(new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName)).header("accept", "application/json").header("authorization", this._accessToken).header("content-type", "application/json").build(), HttpResponse.BodyHandlers.ofString());
        if (response.statusCode() != 200) {
            throw new IOException("Failed to get entries: " + response.statusCode() + " " + response.body());
        }
        return (Entry[])Arrays.stream(((EntryResponse)new Gson().fromJson((String)response.body(), EntryResponse.class)).entries).map(entryData -> new Entry(this._accessToken, this._collectionName, (EntryData)entryData)).toArray(Entry[]::new);
    }

    public void deleteEntryById(final String id) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(new Gson().toJson((Object)new EntryFilterPayload(new EntryData(){
                {
                    this.put("_id", id);
                }
            })).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to delete entry: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    public void deleteEntries(EntryData filters) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("DELETE");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(this._mapper.writeValueAsString((Object)new EntryFilterPayload(filters)).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to delete entries: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    public void updateEntryById(final String id, EntryData entryData) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(this._mapper.writeValueAsString((Object)new EntryUpdatePayload(new EntryData(){
                {
                    this.put("_id", id);
                }
            }, entryData)).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to update entry: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    public void updateEntries(EntryData filters, EntryData entryData) throws URISyntaxException, IOException {
        URL url = new URI("https://api.marcsync.dev/v1/entries/" + this._collectionName).toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("PUT");
        connection.setRequestProperty("accept", "application/json");
        connection.setRequestProperty("authorization", this._accessToken);
        connection.setRequestProperty("content-type", "application/json");
        connection.setDoOutput(true);
        try (OutputStream outputStream = connection.getOutputStream();){
            outputStream.write(this._mapper.writeValueAsString((Object)new EntryUpdatePayload(filters, entryData)).getBytes(StandardCharsets.UTF_8));
        }
        if (connection.getResponseCode() != 200) {
            throw new IOException("Failed to update entries: " + connection.getResponseCode() + " " + connection.getResponseMessage());
        }
    }

    private static String readResponse(InputStream inputStream) throws IOException {
        StringBuilder response = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        return response.toString();
    }
}

