/*
 * Decompiled with CFR 0.152.
 */
package dev.voidframework.cache.module;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.typesafe.config.Config;
import dev.voidframework.cache.engine.BlackHoleCacheEngine;
import dev.voidframework.cache.engine.CacheEngine;
import dev.voidframework.core.utils.ClassResolverUtils;

@Singleton
public final class CacheEngineProvider
implements Provider<CacheEngine> {
    private final Config configuration;
    private final Injector injector;
    private CacheEngine cacheEngine;

    @Inject
    public CacheEngineProvider(Config configuration, Injector injector) {
        this.configuration = configuration;
        this.injector = injector;
    }

    public CacheEngine get() {
        if (this.cacheEngine == null) {
            String cacheEngineClassName;
            Class clazz;
            if (this.configuration.hasPath("voidframework.cache.engine") && (clazz = ClassResolverUtils.forName((String)(cacheEngineClassName = this.configuration.getString("voidframework.cache.engine")))) != null) {
                Injector childInjector = this.injector.createChildInjector(new Module[]{new AbstractModule(){

                    protected void configure() {
                        this.bind(clazz);
                    }
                }});
                this.cacheEngine = (CacheEngine)childInjector.getInstance(clazz);
            }
            if (this.cacheEngine == null) {
                this.cacheEngine = new BlackHoleCacheEngine();
            }
        }
        return this.cacheEngine;
    }
}

