/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class NetworkManager {
    public static void installNetworkManager(VpnType ... vpnTypes) {
        try (Step step = Step.start("NetworkManager: install");){
            ArrayList<String> packages = new ArrayList<String>();
            packages.add("network-manager");
            block13: for (VpnType vpnType : vpnTypes) {
                switch (vpnType.ordinal()) {
                    case 0: {
                        packages.add("network-manager-openvpn-gnome");
                        continue block13;
                    }
                    case 1: {
                        packages.add("wireguard");
                        continue block13;
                    }
                    case 2: {
                        packages.add("network-manager-pptp-gnome");
                        continue block13;
                    }
                    case 3: {
                        packages.add("network-manager-l2tp-gnome");
                        continue block13;
                    }
                    case 4: {
                        packages.add("network-manager-sstp-gnome");
                        continue block13;
                    }
                    case 5: {
                        packages.add("network-manager-openconnect-gnome");
                    }
                }
            }
            Apt.install(packages);
        }
    }

    public static void addOpenConnectConnection(String connectionName, String gateway, Map<String, Object> vpnDataOverrides) {
        try (Step step = Step.start("NetworkManager: create OpenConnect VPN connection: " + connectionName);){
            if (NetworkManager.hasConnection(connectionName)) {
                step.skip("already exists");
                return;
            }
            ArrayList<String> command = new ArrayList<String>();
            command.add("nmcli");
            command.add("connection");
            command.add("add");
            command.add("type");
            command.add("vpn");
            command.add("con-name");
            command.add(connectionName);
            command.add("vpn-type");
            command.add("openconnect");
            LinkedHashMap<String, Object> vpnProperties = new LinkedHashMap<String, Object>();
            vpnProperties.put("authtype", "password");
            vpnProperties.put("autoconnect-flags", "0");
            vpnProperties.put("certsigs-flags", "0");
            vpnProperties.put("cookie-flags", "2");
            vpnProperties.put("disable_udp", "no");
            vpnProperties.put("enable_csd_trojan", "no");
            vpnProperties.put("gateway", gateway);
            vpnProperties.put("gateway-flags", "2");
            vpnProperties.put("gwcert-flags", "2");
            vpnProperties.put("lasthost-flags", "0");
            vpnProperties.put("pem_passphrase_fsid", "no");
            vpnProperties.put("prevent_invalid_cert", "no");
            vpnProperties.put("protocol", "anyconnect");
            vpnProperties.put("resolve-flags", "2");
            vpnProperties.put("stoken_source", "totp");
            vpnProperties.put("useragent", "AnyConnect");
            vpnProperties.put("xmlconfig-flags", "0");
            vpnProperties.putAll(vpnDataOverrides);
            String vpnData = vpnProperties.entrySet().stream().map(e -> "%s = %s".formatted(e.getKey(), e.getValue())).collect(Collectors.joining(", "));
            command.add("vpn.data");
            command.add(vpnData);
            Shell.user(command);
        }
    }

    public static void addOpenConnectConnection(String connectionName, String gateway) {
        NetworkManager.addOpenConnectConnection(connectionName, gateway, Map.of());
    }

    private static boolean hasConnection(String name) {
        return Arrays.stream(Shell.user("nmcli", "-t", "connection").split("\n")).filter(r -> r.endsWith(":vpn:")).anyMatch(r -> r.startsWith(name + ":"));
    }

    public static enum VpnType {
        OPENVPN,
        WIREGUARD,
        PPTP,
        L2TP,
        SSTP,
        OPENCONNECT;

    }
}

