/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.app;

import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt;
import java.net.URI;

public class Docker {
    private static final Apt.Source APT_SOURCE = Apt.Source.builder("docker", URI.create("https://download.docker.com/linux/debian"), "stable").setSignedBy("docker.gpg", URI.create("https://download.docker.com/linux/debian/gpg")).build();

    public static void install() {
        try (Step step = Step.start("Docker: install");){
            Apt.addSource(APT_SOURCE);
            Apt.purge("docker.io", "docker-doc", "docker-compose", "podman-docker", "containerd", "runc");
            Apt.update();
            Apt.install("docker-ce", "docker-ce-cli", "containerd.io", "docker-buildx-plugin", "docker-compose-plugin");
        }
    }

    public static void addCurrentUserToDockerGroup() {
        Docker.addUserToDockerGroup(Shell.USER);
    }

    public static void addUserToDockerGroup(String user) {
        try (Step step = Step.start("Docker: add %s to docker group".formatted(user));){
            Shell.sudo("usermod", "-aG", "docker", user);
        }
    }
}

