/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javaconsolegraph;

import io.fi0x.javaconsolegraph.ConsoleGraph;
import io.fi0x.javaconsolegraph.ConsoleTable;
import java.util.ArrayList;

public class Transformer {
    private final ConsoleTable tableInstance = new ConsoleTable();
    private final ConsoleGraph graphInstance = new ConsoleGraph();
    private static Transformer instance;

    private Transformer() {
    }

    public static Transformer getInstance() {
        if (instance == null) {
            instance = new Transformer();
        }
        return instance;
    }

    public String getTable(String[] columnHeaders, String[][] columns) {
        this.tableInstance.setColumnSizes(columnHeaders, columns);
        ArrayList<String> lines = new ArrayList<String>(this.tableInstance.getLineString(columnHeaders, true));
        for (String[] line : ConsoleTable.transformColumnsToRows(columns)) {
            lines.addAll(this.tableInstance.getLineString(line, false));
        }
        StringBuilder result = new StringBuilder(lines.get(0));
        for (int i = 1; i < lines.size(); ++i) {
            result.append("\n").append(lines.get(i));
        }
        return result.toString();
    }

    public String getTable(String[][] columns) {
        String[] headers = new String[columns.length];
        String[][] content = new String[columns.length][columns[0].length - 1];
        for (int column = 0; column < columns.length; ++column) {
            headers[column] = columns[column][0];
            if (columns[0].length - 1 < 0) continue;
            System.arraycopy(columns[column], 1, content[column], 0, columns[0].length - 1);
        }
        return this.getTable(headers, content);
    }

    public String getTable(ArrayList<String[]> rows) {
        String[] headers = rows.get(0);
        String[][] content = new String[rows.size() - 1][rows.get(0).length];
        for (int column = 0; column < rows.get(0).length; ++column) {
            for (int row = 1; row < rows.size(); ++row) {
                content[row][column] = rows.get(row)[column];
            }
        }
        return this.getTable(headers, content);
    }

    public void setTableSettings(boolean centeredEntries, boolean useSeparators, int entryPadding) {
        this.tableInstance.centered = centeredEntries;
        this.tableInstance.separators = useSeparators;
        this.tableInstance.padding = entryPadding;
    }

    public String[][] getGraphString(double[] values) {
        String[][] layout = this.graphInstance.getBlankGraph();
        this.graphInstance.updateOutline(layout);
        this.graphInstance.fillInValues(layout, values);
        return layout;
    }

    public void setGraphSettings(String xAxis, String yAxis, double xMin, double yMin, double scaleX, double scaleY, int xValues, int yValues) {
        this.graphInstance.xAxisName = xAxis;
        this.graphInstance.yAxisName = yAxis;
        this.graphInstance.xMin = xMin;
        this.graphInstance.yMin = yMin;
        this.graphInstance.scaleX = scaleX;
        this.graphInstance.scaleY = scaleY;
        this.graphInstance.xSize = xValues;
        this.graphInstance.ySize = yValues;
    }
}

