/*
 * Decompiled with CFR 0.152.
 */
package io.fi0x.javadatastructures;

import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Random;
import java.util.TreeMap;

public class WeightedList<Type> {
    private final NavigableMap<Double, Type> ITEMS = new TreeMap<Double, Type>();
    private final Random RANDOM;
    private double total = 0.0;

    public WeightedList(Random random) {
        this.RANDOM = Objects.requireNonNullElseGet(random, Random::new);
    }

    public void add(float weight, Type item) {
        if (weight <= 0.0f) {
            throw new IllegalArgumentException("Weight of a WeightedList item must be greater than 0");
        }
        this.total += (double)weight;
        this.ITEMS.put(this.total, item);
    }

    public Type get(double weightIndex) {
        if (weightIndex < 0.0) {
            throw new IllegalArgumentException("WeightIndex must not be lower than 0");
        }
        Map.Entry<Double, Type> e = this.ITEMS.higherEntry(weightIndex);
        if (e == null) {
            return null;
        }
        return e.getValue();
    }

    public Type random() {
        double value = this.RANDOM.nextDouble() * this.total;
        return this.get(value);
    }

    public Type randomRemove() {
        if (this.ITEMS.size() == 0) {
            return null;
        }
        double value = this.RANDOM.nextDouble() * this.total;
        Map.Entry<Double, Type> entry = this.ITEMS.higherEntry(value);
        value = entry.getKey();
        Type element = entry.getValue();
        if (value == this.total && this.ITEMS.size() > 1) {
            this.total = this.ITEMS.lowerKey(value);
        } else if (this.ITEMS.size() == 1) {
            this.total = 0.0;
        }
        this.ITEMS.remove(value);
        return element;
    }

    public int size() {
        return this.ITEMS.size();
    }
}

