/*
 * Decompiled with CFR 0.152.
 */
package org.brijframework.util.runtime;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import org.brijframework.util.casting.DateUtil;

public class LogUtil {
    public static void printStackTrace(String message) {
        message = message != null ? message : "";
        try {
            throw new RuntimeException(message);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return;
        }
    }

    public static StackTraceElement[] getStackTrace(String message) {
        message = message != null ? message : "";
        StackTraceElement[] stackTrace = null;
        try {
            throw new RuntimeException(message);
        }
        catch (RuntimeException e) {
            stackTrace = e.getStackTrace();
            return stackTrace;
        }
    }

    public static void printException(String errorMessage) {
        LogUtil.printException(errorMessage, null, false);
    }

    public static void printException(String errorMessage, Throwable e) {
        LogUtil.printException(errorMessage, e, true);
    }

    public static void printException(Throwable e) {
        LogUtil.printException(null, e, true);
    }

    public static void printException(String errorMessage, Throwable e, boolean verbose) {
        LogUtil.printException(errorMessage, e, verbose, null);
    }

    public static synchronized void printException(String errorMessage, Throwable e, boolean verbose, String logDir) {
        PrintWriter pw = LogUtil.getLogFile(logDir);
        if (errorMessage != null && !errorMessage.equals("")) {
            pw.println(errorMessage);
        }
        if (e != null) {
            if (verbose) {
                e.printStackTrace(pw);
            } else {
                pw.println(e.getMessage());
            }
        }
        pw.println("\r\n");
        pw.close();
    }

    public static void printError(String fileName, Throwable e) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        if (e.getMessage() != null) {
            hash.put("message", e.getMessage());
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        hash.put("stackTrace", sw.getBuffer().toString());
        try {
            FileOutputStream file = new FileOutputStream("../error/" + fileName + ".ser");
            ObjectOutputStream out = new ObjectOutputStream(file);
            out.writeObject(hash);
            out.flush();
            file.close();
        }
        catch (IOException exp) {
            exp.printStackTrace();
        }
    }

    private static PrintWriter getLogFile(String logDir) {
        try {
            String fileName = "";
            String fullcomputername = null;
            try {
                InetAddress[] hostname = InetAddress.getAllByName(InetAddress.getLocalHost().getHostAddress());
                fullcomputername = hostname[0].getHostName() + "-";
            }
            catch (Exception e) {
                fullcomputername = "";
            }
            if (logDir == null) {
                File logDirCheck = new File("log");
                if (!logDirCheck.exists()) {
                    logDirCheck.mkdirs();
                }
                fileName = "log/exception-log-of-" + fullcomputername + DateUtil.getyyyyMMMddDateString() + ".txt";
            } else {
                fileName = logDir + "/exception-log-of-" + fullcomputername + DateUtil.getyyyyMMMddDateString() + ".txt";
            }
            PrintWriter pw = new PrintWriter(new FileOutputStream(fileName, true));
            GregorianCalendar gc = new GregorianCalendar();
            SimpleDateFormat dateFormat2 = new SimpleDateFormat("EEE, MMM d, yyyy 'at' hh:mm:ss a");
            pw.println("An Exception occurred on " + dateFormat2.format(gc.getTime()));
            return pw;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static int getCharCount(String str, char c) {
        char[] charArray = str.toCharArray();
        int count = 0;
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] != c) continue;
            ++count;
        }
        return count;
    }
}

