/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.connection;

import graphql.annotations.connection.ConnectionFetcher;
import graphql.annotations.connection.PaginatedData;
import graphql.relay.Connection;
import graphql.relay.ConnectionCursor;
import graphql.relay.DefaultConnection;
import graphql.relay.DefaultConnectionCursor;
import graphql.relay.DefaultEdge;
import graphql.relay.DefaultPageInfo;
import graphql.relay.Edge;
import graphql.relay.PageInfo;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PaginatedDataConnectionFetcher<T>
implements ConnectionFetcher<T> {
    private DataFetcher<PaginatedData<T>> paginationDataFetcher;

    public PaginatedDataConnectionFetcher(DataFetcher<PaginatedData<T>> paginationDataFetcher) {
        this.paginationDataFetcher = paginationDataFetcher;
    }

    public Connection<T> get(DataFetchingEnvironment environment) {
        PaginatedData paginatedData = (PaginatedData)this.paginationDataFetcher.get(environment);
        if (paginatedData == null) {
            return new DefaultConnection(Collections.emptyList(), (PageInfo)new DefaultPageInfo(null, null, false, false));
        }
        List<Edge<T>> edges = this.buildEdges(paginatedData);
        PageInfo pageInfo = this.getPageInfo(edges, paginatedData);
        return new DefaultConnection(edges, pageInfo);
    }

    private PageInfo getPageInfo(List<Edge<T>> edges, PaginatedData<T> paginatedData) {
        ConnectionCursor firstCursor = edges.get(0).getCursor();
        ConnectionCursor lastCursor = edges.get(edges.size() - 1).getCursor();
        return new DefaultPageInfo(firstCursor, lastCursor, paginatedData.hasPreviousPage(), paginatedData.hasNextPage());
    }

    private List<Edge<T>> buildEdges(PaginatedData<T> paginatedData) {
        Iterator data = paginatedData.iterator();
        ArrayList<Edge<T>> edges = new ArrayList<Edge<T>>();
        while (data.hasNext()) {
            Object entity = data.next();
            edges.add((Edge<T>)new DefaultEdge(entity, (ConnectionCursor)new DefaultConnectionCursor(paginatedData.getCursor(entity))));
        }
        return edges;
    }
}

