/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers.fieldBuilders.method;

import graphql.annotations.annotationTypes.GraphQLBatched;
import graphql.annotations.annotationTypes.GraphQLDataFetcher;
import graphql.annotations.annotationTypes.GraphQLRelayMutation;
import graphql.annotations.connection.GraphQLConnection;
import graphql.annotations.dataFetchers.BatchedMethodDataFetcher;
import graphql.annotations.dataFetchers.MethodDataFetcher;
import graphql.annotations.dataFetchers.RelayMutationMethodDataFetcher;
import graphql.annotations.dataFetchers.connection.ConnectionDataFetcher;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.retrievers.fieldBuilders.Builder;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.DataFetcherConstructor;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLOutputType;
import java.lang.reflect.Method;
import java.util.List;

public class MethodDataFetcherBuilder
implements Builder<DataFetcher> {
    private Method method;
    private GraphQLOutputType outputType;
    private TypeFunction typeFunction;
    private ProcessingElementsContainer container;
    private GraphQLFieldDefinition relayFieldDefinition;
    private List<GraphQLArgument> args;
    private DataFetcherConstructor dataFetcherConstructor;
    private boolean isConnection;

    public MethodDataFetcherBuilder(Method method, GraphQLOutputType outputType, TypeFunction typeFunction, ProcessingElementsContainer container, GraphQLFieldDefinition relayFieldDefinition, List<GraphQLArgument> args, DataFetcherConstructor dataFetcherConstructor, boolean isConnection) {
        this.method = method;
        this.outputType = outputType;
        this.typeFunction = typeFunction;
        this.container = container;
        this.relayFieldDefinition = relayFieldDefinition;
        this.args = args;
        this.dataFetcherConstructor = dataFetcherConstructor;
        this.isConnection = isConnection;
    }

    @Override
    public DataFetcher build() {
        GraphQLDataFetcher dataFetcher = this.method.getAnnotation(GraphQLDataFetcher.class);
        Object actualDataFetcher = dataFetcher == null && this.method.getAnnotation(GraphQLBatched.class) != null ? new BatchedMethodDataFetcher(this.method, this.typeFunction, this.container) : (dataFetcher == null ? new MethodDataFetcher(this.method, this.typeFunction, this.container) : this.dataFetcherConstructor.constructDataFetcher(this.method.getName(), dataFetcher));
        if (this.method.isAnnotationPresent(GraphQLRelayMutation.class) && this.relayFieldDefinition != null) {
            actualDataFetcher = new RelayMutationMethodDataFetcher(this.method, this.args, this.relayFieldDefinition.getArgument("input").getType(), this.relayFieldDefinition.getType());
        }
        if (this.isConnection) {
            actualDataFetcher = new ConnectionDataFetcher(this.method.getAnnotation(GraphQLConnection.class).connection(), (DataFetcher<?>)actualDataFetcher);
        }
        return actualDataFetcher;
    }
}

