/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.typeBuilders;

import graphql.annotations.annotationTypes.GraphQLDescription;
import graphql.annotations.annotationTypes.GraphQLUnion;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLObjectInfoRetriever;
import graphql.annotations.processor.typeFunctions.TypeFunction;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.annotations.typeResolvers.UnionTypeResolver;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLUnionType;
import graphql.schema.TypeResolver;
import java.util.Arrays;
import java.util.function.Function;

public class UnionBuilder {
    private GraphQLObjectInfoRetriever graphQLObjectInfoRetriever;

    public UnionBuilder(GraphQLObjectInfoRetriever graphQLObjectInfoRetriever) {
        this.graphQLObjectInfoRetriever = graphQLObjectInfoRetriever;
    }

    public GraphQLUnionType.Builder getUnionBuilder(Class<?> iface, final ProcessingElementsContainer container) throws GraphQLAnnotationsException, IllegalArgumentException {
        if (!iface.isInterface()) {
            throw new IllegalArgumentException(iface + " is not an interface");
        }
        GraphQLUnionType.Builder builder = GraphQLUnionType.newUnionType();
        GraphQLUnion unionAnnotation = iface.getAnnotation(GraphQLUnion.class);
        builder.name(this.graphQLObjectInfoRetriever.getTypeName(iface));
        GraphQLDescription description = iface.getAnnotation(GraphQLDescription.class);
        if (description != null) {
            builder.description(description.value());
        }
        graphql.annotations.annotationTypes.GraphQLType typeAnnotation = iface.getAnnotation(graphql.annotations.annotationTypes.GraphQLType.class);
        TypeFunction typeFunction = container.getDefaultTypeFunction();
        if (typeAnnotation != null) {
            typeFunction = ReflectionKit.newInstance(typeAnnotation.value());
        }
        final TypeFunction finalTypeFunction = typeFunction;
        Arrays.asList(unionAnnotation.possibleTypes()).stream().map(new Function<Class<?>, GraphQLType>(){

            @Override
            public GraphQLType apply(Class<?> aClass) {
                return finalTypeFunction.buildType(aClass, null, container);
            }
        }).map(v -> (GraphQLObjectType)v).forEach(arg_0 -> ((GraphQLUnionType.Builder)builder).possibleType(arg_0));
        builder.typeResolver((TypeResolver)new UnionTypeResolver(unionAnnotation.possibleTypes(), container));
        return builder;
    }
}

