/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers;

import graphql.annotations.annotationTypes.GraphQLField;
import graphql.annotations.annotationTypes.GraphQLName;
import graphql.annotations.processor.util.NamingKit;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.osgi.service.component.annotations.Component;

@Component(service={GraphQLObjectInfoRetriever.class}, immediate=true)
public class GraphQLObjectInfoRetriever {
    public String getTypeName(Class<?> objectClass) {
        GraphQLName name = objectClass.getAnnotation(GraphQLName.class);
        return NamingKit.toGraphqlName(name == null ? objectClass.getSimpleName() : name.value());
    }

    public List<Method> getOrderedMethods(Class c) {
        return Arrays.stream(c.getMethods()).sorted(Comparator.comparing(Method::getName)).collect(Collectors.toList());
    }

    public static Boolean isGraphQLField(AnnotatedElement element) {
        GraphQLField annotation = element.getAnnotation(GraphQLField.class);
        if (annotation == null) {
            return null;
        }
        return annotation.value();
    }
}

