/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.directives;

import graphql.annotations.annotationTypes.directives.definition.DirectiveLocations;
import graphql.annotations.annotationTypes.directives.definition.GraphQLDirectiveDefinition;
import graphql.annotations.directives.AnnotationsDirectiveWiring;
import graphql.annotations.processor.DirectiveAndWiring;
import graphql.annotations.processor.directives.CommonPropertiesCreator;
import graphql.annotations.processor.directives.DirectiveArgumentCreator;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLDirective;
import java.lang.annotation.Retention;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;

public class DirectiveCreator {
    public static final String NO_VALID_LOCATIONS_DEFINED_ON_DIRECTIVE = "No valid locations defined on directive";
    private DirectiveArgumentCreator directiveArgumentCreator;
    private CommonPropertiesCreator commonPropertiesCreator;

    public DirectiveCreator(DirectiveArgumentCreator directiveArgumentCreator, CommonPropertiesCreator commonPropertiesCreator) {
        this.directiveArgumentCreator = directiveArgumentCreator;
        this.commonPropertiesCreator = commonPropertiesCreator;
    }

    public GraphQLDirective getDirective(Class<?> annotatedClass) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(this.commonPropertiesCreator.getName(annotatedClass)).description(this.commonPropertiesCreator.getDescription(annotatedClass));
        Introspection.DirectiveLocation[] validLocations = this.getValidLocations(annotatedClass);
        if (validLocations == null || validLocations.length == 0) {
            throw new GraphQLAnnotationsException(NO_VALID_LOCATIONS_DEFINED_ON_DIRECTIVE, null);
        }
        builder.validLocations(validLocations);
        this.buildArguments(builder, annotatedClass);
        return builder.build();
    }

    public DirectiveAndWiring getDirectiveAndWiring(Method directiveMethod) {
        GraphQLDirective.Builder builder = GraphQLDirective.newDirective().name(this.commonPropertiesCreator.getName(directiveMethod)).description(this.commonPropertiesCreator.getDescription(directiveMethod));
        Introspection.DirectiveLocation[] validLocations = this.getValidLocations(directiveMethod);
        if (validLocations == null || validLocations.length == 0) {
            throw new GraphQLAnnotationsException(NO_VALID_LOCATIONS_DEFINED_ON_DIRECTIVE, null);
        }
        builder.validLocations(validLocations);
        this.buildArguments(builder, directiveMethod);
        GraphQLDirective builtDirective = builder.build();
        Class<? extends AnnotationsDirectiveWiring> wiringClass = directiveMethod.getAnnotation(GraphQLDirectiveDefinition.class).wiring();
        return new DirectiveAndWiring(builtDirective, wiringClass);
    }

    private void buildArguments(GraphQLDirective.Builder builder, Class<?> annotatedClass) {
        if (annotatedClass.isAnnotationPresent(Retention.class)) {
            Arrays.stream(annotatedClass.getDeclaredMethods()).filter(method -> !method.isSynthetic()).forEach(method -> builder.argument(this.directiveArgumentCreator.getArgument((Method)method)));
        } else {
            Arrays.stream(annotatedClass.getDeclaredFields()).filter(field -> !field.isSynthetic()).forEach(field -> builder.argument(this.directiveArgumentCreator.getArgument((Field)field, annotatedClass)));
        }
    }

    private void buildArguments(GraphQLDirective.Builder builder, Method directiveMethod) {
        Arrays.stream(directiveMethod.getParameters()).filter(parameter -> !parameter.isSynthetic()).forEach(parameter -> builder.argument(this.directiveArgumentCreator.getArgument((Parameter)parameter)));
    }

    private Introspection.DirectiveLocation[] getValidLocations(AnnotatedElement annotatedElement) {
        DirectiveLocations directiveLocationsAnnotation = annotatedElement.getAnnotation(DirectiveLocations.class);
        if (directiveLocationsAnnotation != null) {
            return directiveLocationsAnnotation.value();
        }
        return null;
    }
}

