/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.util;

import graphql.annotations.connection.ConnectionValidator;
import graphql.annotations.connection.FakeRelay;
import graphql.annotations.connection.GraphQLConnection;
import graphql.annotations.dataFetchers.connection.AsyncConnectionDataFetcher;
import graphql.annotations.dataFetchers.connection.ConnectionDataFetcher;
import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.util.ReflectionKit;
import graphql.relay.Relay;
import graphql.schema.DataFetcher;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLUnionType;
import java.lang.reflect.AccessibleObject;
import java.util.Arrays;
import java.util.List;

public class ConnectionUtil {
    private static final List<Class> TYPES_FOR_CONNECTION = Arrays.asList(GraphQLObjectType.class, GraphQLInterfaceType.class, GraphQLUnionType.class, GraphQLTypeReference.class);

    public static boolean isConnection(AccessibleObject obj, GraphQLType type) {
        if (!obj.isAnnotationPresent(GraphQLConnection.class)) {
            return false;
        }
        if (type instanceof GraphQLNonNull) {
            type = ((GraphQLNonNull)type).getWrappedType();
        }
        if (!(type instanceof GraphQLList)) {
            return false;
        }
        if ((type = ((GraphQLList)type).getWrappedType()) instanceof GraphQLNonNull) {
            type = ((GraphQLNonNull)type).getWrappedType();
        }
        GraphQLType elementType = type;
        boolean isValidGraphQLTypeForConnection = TYPES_FOR_CONNECTION.stream().anyMatch(aClass -> aClass.isInstance(elementType));
        if (isValidGraphQLTypeForConnection) {
            ConnectionValidator validator = ReflectionKit.newInstance(obj.getAnnotation(GraphQLConnection.class).validator());
            validator.validate(obj);
            return true;
        }
        return false;
    }

    public static Relay getRelay(AccessibleObject obj, ProcessingElementsContainer container) {
        Class<? extends Relay> aClass;
        if (obj.isAnnotationPresent(GraphQLConnection.class) && !FakeRelay.class.isAssignableFrom(aClass = obj.getAnnotation(GraphQLConnection.class).connectionType())) {
            return ReflectionKit.newInstance(aClass);
        }
        return container.getRelay();
    }

    public static DataFetcher getConnectionDataFetcher(GraphQLConnection connectionAnnotation, DataFetcher actualDataFetcher) {
        actualDataFetcher = new ConnectionDataFetcher(connectionAnnotation.connectionFetcher(), (DataFetcher<?>)actualDataFetcher);
        if (connectionAnnotation.async()) {
            actualDataFetcher = new AsyncConnectionDataFetcher((ConnectionDataFetcher)actualDataFetcher);
        }
        return actualDataFetcher;
    }
}

