/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.builtin.BooleanConverter;
import name.martingeisse.grumpyjson.builtin.IntegerConverter;
import name.martingeisse.grumpyjson.builtin.JsonElementConverter;
import name.martingeisse.grumpyjson.builtin.ListConverter;
import name.martingeisse.grumpyjson.builtin.MapConverter;
import name.martingeisse.grumpyjson.builtin.StringConverter;
import name.martingeisse.grumpyjson.builtin.helper_types.FieldMustBeNullConverter;
import name.martingeisse.grumpyjson.builtin.helper_types.NullableFieldConverter;
import name.martingeisse.grumpyjson.builtin.helper_types.OptionalFieldConverter;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializerRegistry;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializerRegistry;

public final class JsonEngine {
    private final Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
    private final JsonRegistries registries = JsonRegistries.createDefault();
    private static final Pattern GSON_SYNTAX_ERROR_LOCATION_PATTERN = Pattern.compile("at line (\\d+) column (\\d+) ");

    public JsonEngine() {
        this.registerDualConverter(new BooleanConverter());
        this.registerDualConverter(new IntegerConverter());
        this.registerDualConverter(new StringConverter());
        this.registerDualConverter(new ListConverter(this.registries));
        this.registerDualConverter(new MapConverter(this.registries));
        this.registerDualConverter(new FieldMustBeNullConverter());
        this.registerDualConverter(new NullableFieldConverter(this.registries));
        this.registerDualConverter(new OptionalFieldConverter(this.registries));
        this.registerDualConverter(new JsonElementConverter());
    }

    public void registerSerializer(JsonSerializer<?> serializer) {
        this.registries.registerSerializer(serializer);
    }

    public void registerDeserializer(JsonDeserializer deserializer) {
        this.registries.registerDeserializer(deserializer);
    }

    public <T extends JsonSerializer<?> & JsonDeserializer> void registerDualConverter(T converter) {
        this.registries.registerDualConverter(converter);
    }

    public JsonRegistries getRegistries() {
        return this.registries;
    }

    public JsonSerializerRegistry getSerializerRegistry() {
        return this.registries.serializerRegistry();
    }

    public JsonDeserializerRegistry getDeserializerRegistry() {
        return this.registries.deserializerRegistry();
    }

    public void seal() {
        this.registries.seal();
    }

    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.registries.supportsClassForSerialization(clazz);
    }

    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return this.registries.supportsTypeForDeserialization(type);
    }

    public <T> T deserialize(String source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return this.deserialize(JsonEngine.wrapSource(source), clazz);
    }

    public <T> T deserialize(String source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return this.deserialize(JsonEngine.wrapSource(source), typeToken);
    }

    public Object deserialize(String source, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        return this.deserialize(JsonEngine.wrapSource(source), type);
    }

    public <T> T deserialize(InputStream source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return this.deserialize(JsonEngine.wrapSource(source), clazz);
    }

    public <T> T deserialize(InputStream source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return this.deserialize(JsonEngine.wrapSource(source), typeToken);
    }

    public Object deserialize(InputStream source, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        return this.deserialize(JsonEngine.wrapSource(source), type);
    }

    public <T> T deserialize(Reader source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return clazz.cast(this.deserialize(source, (Type)clazz));
    }

    public <T> T deserialize(Reader source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return (T)this.deserialize(source, typeToken.getType());
    }

    public Object deserialize(Reader source, Type type) throws JsonDeserializationException {
        JsonElement json;
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        try {
            json = (JsonElement)this.gson.fromJson(source, JsonElement.class);
        }
        catch (JsonSyntaxException e) {
            throw new JsonDeserializationException(JsonEngine.mapGsonErrorMessage(e.getMessage()));
        }
        catch (JsonIOException e) {
            throw new JsonDeserializationException("I/O error while reading JSON");
        }
        if (json == null) {
            throw new JsonDeserializationException("no JSON to deserialize");
        }
        return this.registries.deserialize(json, type);
    }

    private static String mapGsonErrorMessage(String message) {
        Objects.requireNonNull(message, "message");
        Matcher matcher = GSON_SYNTAX_ERROR_LOCATION_PATTERN.matcher(message);
        if (matcher.find()) {
            return "syntax error in JSON at line " + matcher.group(1) + ", column " + matcher.group(2);
        }
        return "syntax error in JSON";
    }

    public <T> T deserialize(JsonElement source, Class<T> clazz) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(clazz, "clazz");
        return clazz.cast(this.deserialize(source, (Type)clazz));
    }

    public <T> T deserialize(JsonElement source, TypeToken<T> typeToken) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(typeToken, "typeToken");
        return (T)this.deserialize(source, typeToken.getType());
    }

    public Object deserialize(JsonElement source, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(source, "source");
        Objects.requireNonNull(type, "type");
        return this.registries.deserialize(source, type);
    }

    public String serializeToString(Object value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        StringWriter writer = new StringWriter();
        this.writeTo(value, writer);
        return writer.toString();
    }

    public void writeTo(Object value, OutputStream destination) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(destination, "destination");
        OutputStreamWriter writer = new OutputStreamWriter(destination, StandardCharsets.UTF_8);
        this.writeTo(value, writer);
        try {
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeTo(Object value, Writer destination) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        Objects.requireNonNull(destination, "destination");
        this.gson.toJson(this.registries.serialize(value), (Appendable)destination);
    }

    public JsonElement toJsonElement(Object value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return this.registries.serialize(value);
    }

    private static Reader wrapSource(String source) {
        Objects.requireNonNull(source, "source");
        return new StringReader(source);
    }

    private static Reader wrapSource(InputStream source) {
        Objects.requireNonNull(source, "source");
        return new InputStreamReader(source, StandardCharsets.UTF_8);
    }
}

