/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson;

import java.lang.reflect.Type;
import java.util.Objects;
import name.martingeisse.grumpyjson.JsonProviders;
import name.martingeisse.grumpyjson.builtin.record.RecordConverterFactory;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializerRegistry;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializerRegistry;

public record JsonRegistries(JsonSerializerRegistry serializerRegistry, JsonDeserializerRegistry deserializerRegistry) implements JsonProviders
{
    public static JsonRegistries createDefault() {
        RecordConverterFactory recordConverterFactory = new RecordConverterFactory();
        JsonSerializerRegistry serializerRegistry = new JsonSerializerRegistry(recordConverterFactory);
        JsonDeserializerRegistry deserializerRegistry = new JsonDeserializerRegistry(recordConverterFactory);
        JsonRegistries registries = new JsonRegistries(serializerRegistry, deserializerRegistry);
        recordConverterFactory.setRegistries(registries);
        return registries;
    }

    public void registerSerializer(JsonSerializer<?> serializer) {
        Objects.requireNonNull(serializer, "serializer");
        this.serializerRegistry().register(serializer);
    }

    public void registerDeserializer(JsonDeserializer deserializer) {
        Objects.requireNonNull(deserializer, "deserializer");
        this.deserializerRegistry().register(deserializer);
    }

    public <T extends JsonSerializer<?> & JsonDeserializer> void registerDualConverter(T converter) {
        this.registerSerializer(converter);
        this.registerDeserializer(converter);
    }

    public void clear() {
        this.serializerRegistry.clear();
        this.deserializerRegistry.clear();
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.serializerRegistry.supportsClassForSerialization(clazz);
    }

    @Override
    public <T> JsonSerializer<T> getSerializer(Class<T> clazz) throws NotRegisteredException {
        Objects.requireNonNull(clazz, "clazz");
        return this.serializerRegistry.getSerializer(clazz);
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return this.deserializerRegistry.supportsTypeForDeserialization(type);
    }

    @Override
    public JsonDeserializer getDeserializer(Type type) throws NotRegisteredException {
        Objects.requireNonNull(type, "type");
        return this.deserializerRegistry.getDeserializer(type);
    }

    public void seal() {
        this.serializerRegistry().seal();
        this.deserializerRegistry().seal();
    }
}

