/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import name.martingeisse.grumpyjson.FieldErrorNode;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class ListConverter
implements JsonSerializer<List<?>>,
JsonDeserializer {
    private final JsonRegistries registries;

    public ListConverter(JsonRegistries registries) {
        Objects.requireNonNull(registries, "registries");
        this.registries = registries;
    }

    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return TypeUtil.isSingleParameterizedType(type, List.class) != null;
    }

    @Override
    public List<?> deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        if (json instanceof JsonArray) {
            JsonDeserializer elementDeserializer;
            JsonArray array = (JsonArray)json;
            Type elementType = TypeUtil.expectSingleParameterizedType(type, List.class);
            try {
                elementDeserializer = this.registries.getDeserializer(elementType);
            }
            catch (NotRegisteredException e) {
                throw new JsonDeserializationException(e.getMessage());
            }
            ArrayList<Object> result = new ArrayList<Object>();
            FieldErrorNode errorNode = null;
            for (int i = 0; i < array.size(); ++i) {
                try {
                    result.add(elementDeserializer.deserialize(array.get(i), elementType));
                    continue;
                }
                catch (JsonDeserializationException e) {
                    errorNode = e.getFieldErrorNode().in(Integer.toString(i)).and(errorNode);
                    continue;
                }
                catch (Exception e) {
                    errorNode = FieldErrorNode.create(e).in(Integer.toString(i)).and(errorNode);
                }
            }
            if (errorNode != null) {
                throw new JsonDeserializationException(errorNode);
            }
            return List.copyOf(result);
        }
        throw new JsonDeserializationException("expected list, found: " + String.valueOf(json));
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return List.class.isAssignableFrom(clazz);
    }

    @Override
    public JsonElement serialize(List<?> value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        JsonArray result = new JsonArray();
        FieldErrorNode errorNode = null;
        for (int i = 0; i < value.size(); ++i) {
            try {
                result.add(this.registries.serialize(value.get(i)));
                continue;
            }
            catch (JsonSerializationException e) {
                errorNode = e.getFieldErrorNode().in(Integer.toString(i)).and(errorNode);
                continue;
            }
            catch (Exception e) {
                errorNode = FieldErrorNode.create(e).in(Integer.toString(i)).and(errorNode);
            }
        }
        if (errorNode != null) {
            throw new JsonSerializationException(errorNode);
        }
        return result;
    }
}

