/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.reflect.Type;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializationException;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class LocalTimeConverter
implements JsonSerializer<LocalTime>,
JsonDeserializer {
    @Override
    public boolean supportsTypeForDeserialization(Type type) {
        Objects.requireNonNull(type, "type");
        return type.equals(LocalTime.class);
    }

    @Override
    public LocalTime deserialize(JsonElement json, Type type) throws JsonDeserializationException {
        JsonPrimitive primitive;
        Objects.requireNonNull(json, "json");
        Objects.requireNonNull(type, "type");
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            try {
                return LocalTime.parse(primitive.getAsString());
            }
            catch (DateTimeParseException e) {
                throw new JsonDeserializationException(e.getMessage());
            }
        }
        throw new JsonDeserializationException("expected string, found: " + String.valueOf(json));
    }

    @Override
    public boolean supportsClassForSerialization(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return clazz.equals(LocalTime.class);
    }

    @Override
    public JsonElement serialize(LocalTime value) throws JsonSerializationException {
        Objects.requireNonNull(value, "value");
        return new JsonPrimitive(value.toString());
    }
}

