/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.record;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import name.martingeisse.grumpyjson.JsonRegistries;
import name.martingeisse.grumpyjson.builtin.record.RecordConverter;
import name.martingeisse.grumpyjson.deserialize.JsonDeserializer;
import name.martingeisse.grumpyjson.serialize.JsonSerializer;

public final class RecordConverterFactory {
    private JsonRegistries registries;
    private final ConcurrentHashMap<Class<?>, RecordConverter<?>> map = new ConcurrentHashMap();

    public void setRegistries(JsonRegistries registries) {
        Objects.requireNonNull(registries, "registries");
        this.registries = registries;
    }

    public <T> JsonSerializer<T> getSerializer(Class<T> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.getConverter(clazz);
    }

    public JsonDeserializer getDeserializer(Class<?> rawClass) {
        Objects.requireNonNull(rawClass, "rawClass");
        return this.getConverter(rawClass);
    }

    public RecordConverter<?> getConverter(Class<?> clazz) {
        Objects.requireNonNull(clazz, "clazz");
        return this.map.computeIfAbsent(clazz, ignored -> new RecordConverter(clazz, this.registries));
    }
}

