/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.builtin.record;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import name.martingeisse.grumpyjson.serialize.JsonSerializationException;
import name.martingeisse.grumpyjson.util.TypeUtil;

public final class RecordInfo {
    private final Class<?> recordClass;
    private final List<ComponentInfo> componentInfos;
    private final Constructor<?> constructor;

    public RecordInfo(Class<?> recordClass) {
        Objects.requireNonNull(recordClass, "record");
        if (!recordClass.isRecord()) {
            throw new IllegalArgumentException("not a record: " + String.valueOf(recordClass));
        }
        this.recordClass = recordClass;
        RecordComponent[] components = recordClass.getRecordComponents();
        Class[] rawComponentTypes = new Class[components.length];
        ComponentInfo[] componentInfos = new ComponentInfo[components.length];
        for (int i = 0; i < components.length; ++i) {
            RecordComponent component = components[i];
            rawComponentTypes[i] = component.getType();
            componentInfos[i] = new ComponentInfo(component);
        }
        try {
            this.constructor = recordClass.getDeclaredConstructor(rawComponentTypes);
            this.constructor.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("could not find canonical constructor for record type " + String.valueOf(recordClass));
        }
        this.componentInfos = List.of(componentInfos);
    }

    public Class<?> getRecordClass() {
        return this.recordClass;
    }

    public List<ComponentInfo> getComponentInfos() {
        return this.componentInfos;
    }

    public Object invokeConstructor(Object[] arguments) {
        Objects.requireNonNull(arguments, "arguments");
        try {
            return this.constructor.newInstance(arguments);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public class ComponentInfo {
        private final RecordComponent component;

        public ComponentInfo(RecordComponent component) {
            Objects.requireNonNull(component, "component");
            this.component = component;
            component.getAccessor().setAccessible(true);
        }

        public String getName() {
            return this.component.getName();
        }

        public Type getType() {
            return this.component.getGenericType();
        }

        public Method getGetter() {
            return this.component.getAccessor();
        }

        public Object invokeGetter(Object container) {
            Objects.requireNonNull(container, "container");
            Method getter = this.getGetter();
            try {
                return getter.invoke(container, new Object[0]);
            }
            catch (Exception e) {
                throw new JsonSerializationException("could not invoke getter " + String.valueOf(getter) + " on " + String.valueOf(container));
            }
        }

        public Type getConcreteType(Type concreteRecordType) {
            Objects.requireNonNull(concreteRecordType, "concreteRecordType");
            if (concreteRecordType instanceof Class) {
                return this.component.getGenericType();
            }
            if (concreteRecordType instanceof ParameterizedType) {
                Type[] recordTypeArguments;
                ParameterizedType parameterizedRecordType = (ParameterizedType)concreteRecordType;
                TypeVariable<Class<?>>[] recordTypeParameters = RecordInfo.this.recordClass.getTypeParameters();
                if (recordTypeParameters.length != (recordTypeArguments = parameterizedRecordType.getActualTypeArguments()).length) {
                    throw new RuntimeException("type parameter/argument length mismatch for record " + String.valueOf(RecordInfo.this.recordClass));
                }
                HashMap<String, Type> typeArguments = new HashMap<String, Type>();
                for (int i = 0; i < recordTypeParameters.length; ++i) {
                    typeArguments.put(recordTypeParameters[i].getName(), recordTypeArguments[i]);
                }
                return TypeUtil.replaceTypeVariables(this.component.getGenericType(), typeArguments);
            }
            throw new RuntimeException("cannot find concrete component type for record type " + String.valueOf(concreteRecordType));
        }
    }
}

