/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.registry;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import name.martingeisse.grumpyjson.registry.NotRegisteredException;
import name.martingeisse.grumpyjson.registry.Sealable;
import name.martingeisse.grumpyjson.util.ListUtil;

public abstract class Registry<K, V>
extends Sealable {
    private final List<V> manuallyAddedRegistrables = new ArrayList<V>();
    private final ConcurrentMap<K, V> map = new ConcurrentHashMap();

    public final void clear() {
        this.ensureConfigurationPhase();
        this.manuallyAddedRegistrables.clear();
    }

    public final void register(V registrable) {
        Objects.requireNonNull(registrable, "registrable");
        this.ensureConfigurationPhase();
        this.manuallyAddedRegistrables.add(registrable);
    }

    @Override
    protected void onSeal() {
        ListUtil.reverseInPlace(this.manuallyAddedRegistrables);
    }

    public final boolean supports(K key) {
        Objects.requireNonNull(key, "key");
        this.ensureRunTimePhase();
        return this.getOrNull(key) != null;
    }

    public final V get(K key) throws NotRegisteredException {
        V result = this.getOrNull(key);
        if (result == null) {
            throw new NotRegisteredException(this.getErrorMessageForUnknownKey(key));
        }
        return result;
    }

    private V getOrNull(K key) {
        Objects.requireNonNull(key, "key");
        this.ensureRunTimePhase();
        return (V)this.map.computeIfAbsent(key, ignored -> {
            for (V registrable : this.manuallyAddedRegistrables) {
                if (!this.registrableSupports(registrable, key)) continue;
                return registrable;
            }
            return this.generateRegistrable(key);
        });
    }

    protected abstract boolean registrableSupports(V var1, K var2);

    protected abstract V generateRegistrable(K var1);

    protected abstract String getErrorMessageForUnknownKey(K var1);
}

