/*
 * Decompiled with CFR 0.152.
 */
package name.martingeisse.grumpyjson.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.Objects;
import name.martingeisse.grumpyjson.util.ParameterizedTypeImpl;

public class TypeUtil {
    private TypeUtil() {
    }

    public static Type[] isParameterizedType(Type type, Class<?> expectedRawClass, int expectedNumberOfTypeArguments) {
        Type[] typeArguments;
        ParameterizedType p;
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(expectedRawClass, "expectedRawClass");
        if (type instanceof ParameterizedType && (p = (ParameterizedType)type).getRawType().equals(expectedRawClass) && (typeArguments = p.getActualTypeArguments()).length == expectedNumberOfTypeArguments) {
            return typeArguments;
        }
        return null;
    }

    public static Type isSingleParameterizedType(Type type, Class<?> expectedRawClass) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(expectedRawClass, "expectedRawClass");
        Type[] result = TypeUtil.isParameterizedType(type, expectedRawClass, 1);
        return result == null ? null : result[0];
    }

    public static Type[] expectParameterizedType(Type type, Class<?> expectedRawClass, int expectedNumberOfTypeArguments) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(expectedRawClass, "expectedRawClass");
        Type[] result = TypeUtil.isParameterizedType(type, expectedRawClass, expectedNumberOfTypeArguments);
        if (result == null) {
            throw new RuntimeException("paramterized type not as expected");
        }
        return result;
    }

    public static Type expectSingleParameterizedType(Type type, Class<?> expectedRawClass) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(expectedRawClass, "expectedRawClass");
        Type result = TypeUtil.isSingleParameterizedType(type, expectedRawClass);
        if (result == null) {
            throw new RuntimeException("paramterized type not as expected");
        }
        return result;
    }

    public static Type replaceTypeVariables(Type original, Map<String, Type> bindings) {
        Objects.requireNonNull(original, "original");
        Objects.requireNonNull(bindings, "bindings");
        if (original instanceof Class) {
            return original;
        }
        if (original instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)original;
            Type ownerBeforeReplacement = parameterized.getOwnerType();
            Type ownerAfterReplacement = ownerBeforeReplacement == null ? null : TypeUtil.replaceTypeVariables(ownerBeforeReplacement, bindings);
            Type[] argumentsBeforeReplacement = parameterized.getActualTypeArguments();
            Type[] argumentsAfterReplacement = new Type[argumentsBeforeReplacement.length];
            for (int i = 0; i < argumentsBeforeReplacement.length; ++i) {
                argumentsAfterReplacement[i] = TypeUtil.replaceTypeVariables(argumentsBeforeReplacement[i], bindings);
            }
            return new ParameterizedTypeImpl(ownerAfterReplacement, parameterized.getRawType(), argumentsAfterReplacement);
        }
        if (original instanceof TypeVariable) {
            TypeVariable variable = (TypeVariable)original;
            Type boundType = bindings.get(variable.getName());
            if (boundType == null) {
                throw new IllegalArgumentException("no binding for type variable " + variable.getName());
            }
            return boundType;
        }
        throw new IllegalArgumentException("found unexpected type: " + String.valueOf(original));
    }
}

