/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls;

import io.github.kloping.file.FileUtils;
import io.github.kloping.object.ObjectUtils;
import io.github.kloping.serialize.HMLObject;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.component.ConfigFileManager;
import io.github.kloping.spt.interfaces.component.ContextManager;
import java.io.File;

public class ConfigFileManagerImpl
implements ConfigFileManager {
    private ContextManager contextManager;
    private static final String SUFFIX = ".hml";

    public ConfigFileManagerImpl(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    @Override
    public void load(String file) {
        if (!file.endsWith(SUFFIX)) {
            this.loadTxt(file);
        } else {
            this.loadHml(file);
        }
    }

    private void loadHml(String file) {
        String string = FileUtils.getStringFromFile((String)file);
        HMLObject object = HMLObject.parseObject((String)string);
        object.getEntry().forEach((k, v) -> this.contextManager.append(v.getClass(), v, (String)k));
    }

    private void loadTxt(String file) {
        String[] ss;
        for (String s : ss = FileUtils.getStringsFromFile((String)file)) {
            String[] s2 = s.split("=");
            if (s2.length < 2) continue;
            String m1 = s.replace(s2[0] + "=", "");
            Object o = ObjectUtils.maybeType((String)m1.trim());
            this.contextManager.append(o, s2[0]);
        }
        Logger logger = this.contextManager.getContextEntity(Logger.class);
        if (logger != null) {
            logger.Log("load config file ok for " + file, 0);
        }
    }

    @Override
    public void load(File file) {
        this.load(file.getAbsolutePath());
    }
}

