/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.qqpd;

import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.qqbot.api.AtAble;
import io.github.kloping.qqbot.api.DeleteAble;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.qqpd.message.MessageReference;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.impl.MessagePacket;
import io.github.kloping.qqbot.utils.BaseUtils;
import java.util.HashMap;
import java.util.Map;

public class Channel
implements SenderAndCidMidGetter,
AtAble,
DeleteAble {
    private Integer speakPermission;
    private Integer subType;
    private String ownerId;
    private String guildId;
    private String name;
    private String id;
    private Integer position;
    private String parentId;
    private Integer type;
    private Integer privateType;
    private String applicationId;
    public static final Map<String, String> SEND_MESSAGE_HEADERS = new HashMap<String, String>();
    public static final Map<String, String> SEND_FORM_DATA_HEADERS;
    @JSONField(serialize=false, deserialize=false)
    private Bot bot;

    @Override
    public ActionResult send(String text, RawMessage message) {
        RawPreMessage msg = new RawPreMessage(text);
        msg.setMessageReference(new MessageReference(message.getId()));
        return this.bot.messageBase.send(this.id, msg, SEND_MESSAGE_HEADERS);
    }

    @Override
    public ActionResult send(String text) {
        return this.bot.messageBase.send(this.id, new RawPreMessage(text), SEND_MESSAGE_HEADERS);
    }

    @Override
    public ActionResult send(MessagePacket packet) {
        RawPreMessage msg = new RawPreMessage();
        BaseUtils.packet2pre(packet, msg);
        return this.bot.messageBase.send(this.id, msg, SEND_MESSAGE_HEADERS);
    }

    @Override
    public ActionResult send(RawPreMessage msg) {
        return this.bot.messageBase.send(this.id, msg, SEND_MESSAGE_HEADERS);
    }

    @Override
    public At at() {
        return new At("channel", this.getId());
    }

    @Override
    public ActionResult send(SendAble msg) {
        return msg.send(this);
    }

    @Override
    public Object delete() {
        this.getBot().channelBase.delete(this.getId());
        return null;
    }

    @Override
    public String getCid() {
        return this.getId();
    }

    @Override
    public Bot getBot() {
        return this.bot;
    }

    @Override
    public void setBot(Bot bot) {
        this.bot = bot;
    }

    public Integer getSpeakPermission() {
        return this.speakPermission;
    }

    public Integer getSubType() {
        return this.subType;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getGuildId() {
        return this.guildId;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Integer getPosition() {
        return this.position;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Integer getType() {
        return this.type;
    }

    public Integer getPrivateType() {
        return this.privateType;
    }

    public String getApplicationId() {
        return this.applicationId;
    }

    public Channel setSpeakPermission(Integer speakPermission) {
        this.speakPermission = speakPermission;
        return this;
    }

    public Channel setSubType(Integer subType) {
        this.subType = subType;
        return this;
    }

    public Channel setOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Channel setGuildId(String guildId) {
        this.guildId = guildId;
        return this;
    }

    public Channel setName(String name) {
        this.name = name;
        return this;
    }

    public Channel setId(String id) {
        this.id = id;
        return this;
    }

    public Channel setPosition(Integer position) {
        this.position = position;
        return this;
    }

    public Channel setParentId(String parentId) {
        this.parentId = parentId;
        return this;
    }

    public Channel setType(Integer type2) {
        this.type = type2;
        return this;
    }

    public Channel setPrivateType(Integer privateType) {
        this.privateType = privateType;
        return this;
    }

    public Channel setApplicationId(String applicationId) {
        this.applicationId = applicationId;
        return this;
    }

    public String toString() {
        return "Channel(speakPermission=" + this.getSpeakPermission() + ", subType=" + this.getSubType() + ", ownerId=" + this.getOwnerId() + ", guildId=" + this.getGuildId() + ", name=" + this.getName() + ", id=" + this.getId() + ", position=" + this.getPosition() + ", parentId=" + this.getParentId() + ", type=" + this.getType() + ", privateType=" + this.getPrivateType() + ", applicationId=" + this.getApplicationId() + ", bot=" + this.getBot() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Channel)) {
            return false;
        }
        Channel other = (Channel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$speakPermission = this.getSpeakPermission();
        Integer other$speakPermission = other.getSpeakPermission();
        if (this$speakPermission == null ? other$speakPermission != null : !((Object)this$speakPermission).equals(other$speakPermission)) {
            return false;
        }
        Integer this$subType = this.getSubType();
        Integer other$subType = other.getSubType();
        if (this$subType == null ? other$subType != null : !((Object)this$subType).equals(other$subType)) {
            return false;
        }
        Integer this$position = this.getPosition();
        Integer other$position = other.getPosition();
        if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
            return false;
        }
        Integer this$type = this.getType();
        Integer other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)this$type).equals(other$type)) {
            return false;
        }
        Integer this$privateType = this.getPrivateType();
        Integer other$privateType = other.getPrivateType();
        if (this$privateType == null ? other$privateType != null : !((Object)this$privateType).equals(other$privateType)) {
            return false;
        }
        String this$ownerId = this.getOwnerId();
        String other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        String this$guildId = this.getGuildId();
        String other$guildId = other.getGuildId();
        if (this$guildId == null ? other$guildId != null : !this$guildId.equals(other$guildId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        String this$applicationId = this.getApplicationId();
        String other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) {
            return false;
        }
        Bot this$bot = this.getBot();
        Bot other$bot = other.getBot();
        return !(this$bot == null ? other$bot != null : !this$bot.equals(other$bot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Channel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $speakPermission = this.getSpeakPermission();
        result = result * 59 + ($speakPermission == null ? 43 : ((Object)$speakPermission).hashCode());
        Integer $subType = this.getSubType();
        result = result * 59 + ($subType == null ? 43 : ((Object)$subType).hashCode());
        Integer $position = this.getPosition();
        result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
        Integer $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)$type).hashCode());
        Integer $privateType = this.getPrivateType();
        result = result * 59 + ($privateType == null ? 43 : ((Object)$privateType).hashCode());
        String $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        String $guildId = this.getGuildId();
        result = result * 59 + ($guildId == null ? 43 : $guildId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        String $applicationId = this.getApplicationId();
        result = result * 59 + ($applicationId == null ? 43 : $applicationId.hashCode());
        Bot $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        return result;
    }

    static {
        SEND_MESSAGE_HEADERS.put("Content-Type", "application/json");
        SEND_MESSAGE_HEADERS.put("Accept-Encoding", "*/*");
        SEND_FORM_DATA_HEADERS = new HashMap<String, String>();
        SEND_FORM_DATA_HEADERS.put("Content-Type", "multipart/form-data");
        SEND_FORM_DATA_HEADERS.put("Accept-Encoding", "*/*");
    }
}

