/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.message.MessageEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.msg.MessageChain;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.Guild;
import io.github.kloping.qqbot.entities.qqpd.Member;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.impl.MessagePacket;
import io.github.kloping.qqbot.utils.BaseUtils;

public abstract class BaseMessageEvent
implements MessageEvent {
    protected RawMessage message;
    protected JSONObject metadata;
    protected Guild guild;
    protected Member sender;
    protected Channel channel;
    protected Bot bot;

    public BaseMessageEvent() {
    }

    public BaseMessageEvent(RawMessage message, JSONObject jo, Bot bot) {
        this.message = message;
        this.metadata = jo;
        this.bot = bot;
        this.guild = this.getBot().getGuild(message.getGuildId());
        this.channel = this.getGuild().channelMap().get(message.getChannelId());
        this.sender = this.getGuild().getMember(message.getAuthor().getId());
    }

    @Override
    public RawMessage getRawMessage() {
        return this.message;
    }

    @Override
    public JSONObject getMetadata() {
        return this.metadata;
    }

    @Override
    public Guild getGuild() {
        return this.guild;
    }

    @Override
    public Member getSender() {
        return this.sender;
    }

    @Override
    public Channel getChannel() {
        return this.channel;
    }

    @Override
    public ActionResult send(String text) {
        return this.getRawMessage().send(text);
    }

    @Override
    public ActionResult send(String text, RawMessage message) {
        return this.getRawMessage().send(text, message);
    }

    @Override
    public ActionResult send(MessagePacket packet) {
        return this.getRawMessage().send(packet);
    }

    @Override
    public ActionResult send(RawPreMessage msg) {
        return this.getRawMessage().send(msg);
    }

    @Override
    public Bot getBot() {
        return this.bot;
    }

    @Override
    public ActionResult send(SendAble msg) {
        return this.getRawMessage().send(msg);
    }

    @Override
    public MessageChain getMessage() {
        return BaseUtils.parseToMessageChain(this.getRawMessage());
    }
}

