/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot;

import io.github.kloping.common.Public;
import io.github.kloping.judge.Judge;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.Start0;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.impl.ListenerHost;
import io.github.kloping.qqbot.interfaces.ImageUploadInterceptor;
import io.github.kloping.qqbot.network.Events;
import io.github.kloping.qqbot.network.WebSocketListener;
import io.github.kloping.qqbot.network.WssWorker;
import io.github.kloping.qqbot.utils.LoggerImpl;
import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.StarterObjectApplication;
import io.github.kloping.spt.interfaces.component.ContextManager;
import io.github.kloping.spt.interfaces.component.HttpClientManager;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;

public class Starter
implements Runnable {
    public static final String NET_MAIN = "https://api.sgroup.qq.com/";
    public static final String APPID_ID = "appid";
    public static final String TOKEN_ID = "token";
    public static final String SECRET_ID = "secret";
    public static final String AUTH_ID = "appid-token";
    public static final String INTENTS_ID = "intents";
    public static final String SHARD_ID = "shard";
    public static final String PROPERTIES_ID = "properties";
    public static final String MAIN_FUTURE_ID = "main_future";
    public static final String RECONNECT_K_ID = "is_reconnect";
    public static final String CONFIG_ID = "config";
    public static final Integer CODE_4006 = 4006;
    public static final Integer CODE_4007 = 4007;
    public static final Integer CODE_4008 = 4008;
    public static final Integer CODE_4009 = 4009;
    public static final Integer CODE_4900 = 4900;
    public static final Integer CODE_4913 = 4913;
    private Config config = new Config();
    private WssWorker wssWorker;
    public final StarterObjectApplication APPLICATION = new StarterObjectApplication(Resource.class);
    private ContextManager contextManager;

    public Starter(String appid, String token) {
        this(appid, token, null);
    }

    public Starter(String appid, String token, String secret) {
        this.getConfig().setAppid(appid);
        this.getConfig().setToken(token);
        this.getConfig().setSecret(secret);
        this.APPLICATION.logger = LoggerImpl.INSTANCE;
    }

    @Override
    public void run() {
        this.APPLICATION.PRE_SCAN_RUNNABLE.add(() -> {
            this.APPLICATION.INSTANCE.getContextManager().append((Object)this.APPLICATION.logger);
            this.APPLICATION.INSTANCE.getContextManager().append((Object)this.APPLICATION.INSTANCE);
            this.APPLICATION.INSTANCE.getContextManager().append((Object)this.getConfig(), CONFIG_ID);
        });
        this.APPLICATION.logger.setLogLevel(1);
        this.APPLICATION.logger.setPrefix("[qq-pd-group]");
        this.APPLICATION.run0(Start0.class);
        this.after();
    }

    protected void after() {
        String appid = this.getConfig().getAppid();
        String token = this.getConfig().getToken();
        String secret = this.getConfig().getSecret();
        this.contextManager = this.APPLICATION.INSTANCE.getContextManager();
        this.contextManager.append((Object)this);
        this.contextManager.append((Object)appid, APPID_ID);
        this.contextManager.append((Object)token, TOKEN_ID);
        if (Judge.isNotEmpty((String)this.config.getSecret())) {
            this.contextManager.append((Object)secret, SECRET_ID);
        }
        this.contextManager.append((Object)this.getConfig().getCode(), INTENTS_ID);
        this.contextManager.append((Object)new Integer[]{0, 1}, SHARD_ID);
        this.contextManager.append((Object)("Bot " + appid + "." + token), AUTH_ID);
        this.contextManager.append((Object)this.getConfig().getReconnect(), RECONNECT_K_ID);
        this.wssWorker = (WssWorker)this.contextManager.getContextEntity(WssWorker.class);
        ((HttpClientManager)this.contextManager.getContextEntity(HttpClientManager.class)).setPrint(false);
        this.wssWork();
    }

    protected void wssWork() {
        Future<?> future = Public.EXECUTOR_SERVICE.submit(this.wssWorker);
        this.APPLICATION.INSTANCE.getContextManager().append(future, MAIN_FUTURE_ID);
    }

    public void setReconnect(Boolean reconnect) {
        this.getConfig().setReconnect(reconnect);
    }

    public void registerListenerHost(ListenerHost listenerHost) {
        this.getConfig().getListenerHosts().add(listenerHost);
    }

    public void registerEventsRegister(Class<? extends Events.EventRegister> cla) {
        this.APPLICATION.POST_SCAN_RUNNABLE.add(() -> {
            try {
                this.APPLICATION.INSTANCE.getClassManager().add(cla);
            }
            catch (Exception e) {
                this.APPLICATION.logger.error("An error occurred in the registration class " + cla.getSimpleName());
                this.APPLICATION.logger.error("\n\tat " + PartUtils.getExceptionLine((Throwable)e));
            }
        });
    }

    public Bot getBot() {
        return (Bot)this.contextManager.getContextEntity(Bot.class);
    }

    public Config getConfig() {
        return this.config;
    }

    public WssWorker getWssWorker() {
        return this.wssWorker;
    }

    public static class Config {
        private String appid;
        private String token;
        private String secret;
        private Integer code;
        private Boolean reconnect = true;
        private Set<ListenerHost> listenerHosts = new HashSet<ListenerHost>();
        private ImageUploadInterceptor interceptor0;
        private WebSocketListener webSocketListener;

        public String getAppid() {
            return this.appid;
        }

        public String getToken() {
            return this.token;
        }

        public String getSecret() {
            return this.secret;
        }

        public Integer getCode() {
            return this.code;
        }

        public Boolean getReconnect() {
            return this.reconnect;
        }

        public Set<ListenerHost> getListenerHosts() {
            return this.listenerHosts;
        }

        public ImageUploadInterceptor getInterceptor0() {
            return this.interceptor0;
        }

        public WebSocketListener getWebSocketListener() {
            return this.webSocketListener;
        }

        public void setAppid(String appid) {
            this.appid = appid;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setSecret(String secret) {
            this.secret = secret;
        }

        public void setCode(Integer code) {
            this.code = code;
        }

        public void setReconnect(Boolean reconnect) {
            this.reconnect = reconnect;
        }

        public void setListenerHosts(Set<ListenerHost> listenerHosts) {
            this.listenerHosts = listenerHosts;
        }

        public void setInterceptor0(ImageUploadInterceptor interceptor0) {
            this.interceptor0 = interceptor0;
        }

        public void setWebSocketListener(WebSocketListener webSocketListener) {
            this.webSocketListener = webSocketListener;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Config)) {
                return false;
            }
            Config other = (Config)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$code = this.getCode();
            Integer other$code = other.getCode();
            if (this$code == null ? other$code != null : !((Object)this$code).equals(other$code)) {
                return false;
            }
            Boolean this$reconnect = this.getReconnect();
            Boolean other$reconnect = other.getReconnect();
            if (this$reconnect == null ? other$reconnect != null : !((Object)this$reconnect).equals(other$reconnect)) {
                return false;
            }
            String this$appid = this.getAppid();
            String other$appid = other.getAppid();
            if (this$appid == null ? other$appid != null : !this$appid.equals(other$appid)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            if (this$token == null ? other$token != null : !this$token.equals(other$token)) {
                return false;
            }
            String this$secret = this.getSecret();
            String other$secret = other.getSecret();
            if (this$secret == null ? other$secret != null : !this$secret.equals(other$secret)) {
                return false;
            }
            Set<ListenerHost> this$listenerHosts = this.getListenerHosts();
            Set<ListenerHost> other$listenerHosts = other.getListenerHosts();
            if (this$listenerHosts == null ? other$listenerHosts != null : !((Object)this$listenerHosts).equals(other$listenerHosts)) {
                return false;
            }
            ImageUploadInterceptor this$interceptor0 = this.getInterceptor0();
            ImageUploadInterceptor other$interceptor0 = other.getInterceptor0();
            if (this$interceptor0 == null ? other$interceptor0 != null : !this$interceptor0.equals(other$interceptor0)) {
                return false;
            }
            WebSocketListener this$webSocketListener = this.getWebSocketListener();
            WebSocketListener other$webSocketListener = other.getWebSocketListener();
            return !(this$webSocketListener == null ? other$webSocketListener != null : !this$webSocketListener.equals(other$webSocketListener));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Config;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : ((Object)$code).hashCode());
            Boolean $reconnect = this.getReconnect();
            result = result * 59 + ($reconnect == null ? 43 : ((Object)$reconnect).hashCode());
            String $appid = this.getAppid();
            result = result * 59 + ($appid == null ? 43 : $appid.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            String $secret = this.getSecret();
            result = result * 59 + ($secret == null ? 43 : $secret.hashCode());
            Set<ListenerHost> $listenerHosts = this.getListenerHosts();
            result = result * 59 + ($listenerHosts == null ? 43 : ((Object)$listenerHosts).hashCode());
            ImageUploadInterceptor $interceptor0 = this.getInterceptor0();
            result = result * 59 + ($interceptor0 == null ? 43 : $interceptor0.hashCode());
            WebSocketListener $webSocketListener = this.getWebSocketListener();
            result = result * 59 + ($webSocketListener == null ? 43 : $webSocketListener.hashCode());
            return result;
        }

        public String toString() {
            return "Starter.Config(appid=" + this.getAppid() + ", token=" + this.getToken() + ", secret=" + this.getSecret() + ", code=" + this.getCode() + ", reconnect=" + this.getReconnect() + ", listenerHosts=" + this.getListenerHosts() + ", interceptor0=" + this.getInterceptor0() + ", webSocketListener=" + this.getWebSocketListener() + ")";
        }
    }
}

