/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message.v2;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.api.SenderV2;
import io.github.kloping.qqbot.api.v2.FriendMessageEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.v2.Friend;
import io.github.kloping.qqbot.http.BaseV2;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.http.data.V2MsgData;
import io.github.kloping.qqbot.http.data.V2Result;
import io.github.kloping.qqbot.impl.message.v2.BaseMessageEvent;

public class BaseFriendMessageEvent
extends BaseMessageEvent<Friend>
implements FriendMessageEvent,
SenderAndCidMidGetter,
SenderV2 {
    private Friend subject;
    private Bot bot;
    private Integer seq = 1;

    public BaseFriendMessageEvent(RawMessage message, JSONObject jo, Bot bot) {
        super(message, jo, bot);
        this.bot = bot;
        this.metadata = jo;
        this.rawMessage = message;
        this.msgId = this.getMetadata().getString("id");
        this.subject = new Friend(this.getMetadata().getJSONObject("author"));
        this.subject.setBot(bot);
    }

    @Override
    public String getId() {
        return this.metadata.getString("raw-id");
    }

    @Override
    public Friend getFriend() {
        return this.subject;
    }

    @Override
    public String getOpenId() {
        return this.getFriend().getOpenid();
    }

    @Override
    public Friend getSender() {
        return this.getFriend();
    }

    @Override
    public Friend getSubject() {
        return this.subject;
    }

    @Override
    public V2Result sendMessage(String text) {
        return this.sendMessage(text, this.getMsgSeq());
    }

    public V2Result sendMessage(String text, int seq) {
        V2MsgData data = new V2MsgData().setMsg_id(this.getMsgId()).setContent(text).setMsg_seq(seq);
        return this.getV2().send(this.getSubject().getOpenid(), JSON.toJSONString((Object)data), Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public V2Result sendMessage(SendAble msg) {
        return (V2Result)msg.send(this).getData();
    }

    @Override
    public Result<V2Result> send(String text) {
        return new Result<V2Result>(this.sendMessage(text));
    }

    @Override
    public Result<V2Result> send(String text, RawMessage message) {
        return message.send(text, message);
    }

    @Override
    public Result send(SendAble msg) {
        return msg.send(this);
    }

    @Override
    public String getCid() {
        return this.getSubject().getCid();
    }

    @Override
    public String getMid() {
        return this.getMsgId();
    }

    @Override
    public EnvType getEnvType() {
        return EnvType.GROUP_USER;
    }

    @Override
    public BaseV2 getV2() {
        return this.bot.userBaseV2;
    }

    @Override
    public Integer getMsgSeq() {
        Integer n = this.seq;
        Integer n2 = this.seq = Integer.valueOf(this.seq + 1);
        return n;
    }

    @Override
    public Integer setMsgSeq(Integer seq) {
        Integer oseq = this.seq;
        this.seq = seq;
        return oseq;
    }

    @Override
    public String toString() {
        return String.format("[type(%s) %s].%s:%s", EnvType.USER.name(), this.getSubject().getId(), this.getSender().getId(), this.getRawMessage().toString0());
    }

    @Override
    public String getClassName() {
        return "FriendMessageEvent";
    }

    @Override
    public void setBot(Bot bot) {
        this.bot = bot;
    }
}

