/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.network;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.common.Public;
import io.github.kloping.map.MapUtils;
import io.github.kloping.qqbot.Starter;
import io.github.kloping.qqbot.api.event.Event;
import io.github.kloping.qqbot.api.exc.RequestException;
import io.github.kloping.qqbot.api.message.MessageEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.Pack;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.impl.ListenerHost;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import io.github.kloping.qqbot.network.WssWorker;
import io.github.kloping.qqbot.utils.InvokeUtils;
import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.AutoStandAfter;
import io.github.kloping.spt.annotations.Entity;
import io.github.kloping.spt.interfaces.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Entity
public class Events
implements OnPackReceive {
    public static final String EXTEND_ID = "raw-id";
    @AutoStand
    Starter.Config config;
    @AutoStand
    Logger logger;
    @AutoStand
    Bot bot;
    private final Map<Method, ListenerHost> m2l = new HashMap<Method, ListenerHost>();
    private int cap = 0;
    public Map<String, List<EventRegister>> id2reg = new HashMap<String, List<EventRegister>>();

    @AutoStandAfter
    public void r1(WssWorker wssWorker) {
        wssWorker.getOnPackReceives().add(this);
    }

    @Override
    public boolean onReceive(Pack pack) {
        String t = pack.getT();
        if (t == null) {
            return false;
        }
        JSONObject jo = JSON.parseObject((String)JSON.toJSONString((Object)pack.getD()));
        jo.put(EXTEND_ID, (Object)pack.getId());
        Public.EXECUTOR_SERVICE.submit(() -> {
            try {
                this.onEvent(t, jo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return false;
    }

    private void onEvent(String t, JSONObject obj) throws Exception {
        Object c0 = null;
        RawMessage msg = null;
        msg = (RawMessage)obj.toJavaObject(RawMessage.class);
        if (msg == null) {
            this.logger.waring(String.format("Unknown Pack(%s)", obj.toString()));
            return;
        }
        List<EventRegister> registers = this.id2reg.get(t);
        if (registers == null || registers.isEmpty()) {
            this.logger.waring(String.format("%s yet not registered", t));
            return;
        }
        msg.setBot(this.bot);
        for (EventRegister register : registers) {
            Event event = register.handle(t, obj, msg);
            if (event == null) {
                return;
            }
            for (Method method : this.getM2L().keySet()) {
                ListenerHost l = this.getM2L().get(method);
                if (!method.getParameterTypes()[0].isAssignableFrom(event.getClass())) continue;
                this.invokeBefore(l, event, method, this);
                Public.EXECUTOR_SERVICE.submit(() -> {
                    block8: {
                        try {
                            method.invoke((Object)l, event);
                        }
                        catch (IllegalAccessException e) {
                            this.logger.error("EventReceiver The method parameter is set incorrectly");
                            this.logger.error(e.getMessage() + "\n\tat " + PartUtils.getExceptionLine((Throwable)e));
                        }
                        catch (InvocationTargetException e) {
                            if (l.handleException(e.getTargetException())) {
                                if (e.getTargetException() instanceof RequestException) {
                                    RequestException re = (RequestException)e.getTargetException();
                                    this.logger.error(String.format("%s: code(%s) %s at", re.getClass().getSimpleName(), re.getCode(), re.getData().getMessage()));
                                    for (StackTraceElement traceElement : re.getStackTrace()) {
                                        this.logger.error(String.format("\t%s.%s(%s:%s)", traceElement.getClassName(), traceElement.getMethodName(), traceElement.getFileName() == null ? "unknown" : traceElement.getFileName(), traceElement.getLineNumber()));
                                    }
                                } else {
                                    this.logger.error(PartUtils.getExceptionLine((Throwable)e.getTargetException()));
                                }
                            }
                        }
                        catch (Exception e) {
                            if (!l.handleException(e)) break block8;
                            this.logger.error(PartUtils.getExceptionLine((Throwable)e));
                        }
                    }
                });
            }
            this.logger.info(String.format("Bot(%s) post(%s) from %s", this.bot.getInfo().getUsername(), event, event.getClassName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Method, ListenerHost> getM2L() {
        if (this.m2l.isEmpty() || this.cap != this.config.getListenerHosts().size()) {
            Map<Method, ListenerHost> map = this.m2l;
            synchronized (map) {
                this.cap = 0;
                for (ListenerHost listenerHost : this.config.getListenerHosts()) {
                    for (Method method : InvokeUtils.getAllMethod(listenerHost)) {
                        this.m2l.put(method, listenerHost);
                    }
                    ++this.cap;
                }
            }
        }
        return this.m2l;
    }

    public Events register(String id, EventRegister register) {
        MapUtils.append(this.id2reg, (Object)id, (Object)register, LinkedList.class);
        return this;
    }

    private void invokeBefore(ListenerHost l, Event event, Method method, Events events) {
        if (method.isAnnotationPresent(ListenerHost.Filter.class) && event instanceof MessageEvent) {
            ListenerHost.Filter filter = method.getAnnotation(ListenerHost.Filter.class);
            ((MessageEvent)event).setFilter(filter.exclusions());
        }
    }

    public static interface EventRegister {
        public Event handle(String var1, JSONObject var2, RawMessage var3);
    }
}

