/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.network;

import io.github.kloping.judge.Judge;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.Starter;
import io.github.kloping.qqbot.entities.Pack;
import io.github.kloping.qqbot.http.BotBase;
import io.github.kloping.qqbot.interfaces.OnCloseListener;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import io.github.kloping.qqbot.network.WebSocketListener;
import io.github.kloping.qqbot.network.hookauth.HookAuth;
import io.github.kloping.spt.annotations.AutoStand;
import io.github.kloping.spt.annotations.Entity;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.component.ContextManager;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

@Entity
public class WssWorker
implements Runnable {
    @AutoStand
    private ContextManager contextManager;
    @AutoStand
    private BotBase botBase;
    @AutoStand
    private Logger logger;
    @AutoStand
    HookAuth hookAuth;
    @AutoStand
    Starter.Config config;
    public WebSocketClient webSocket;
    protected Integer msgr = 0;
    protected Integer msgs = 0;
    protected URI uri;
    public List<OnCloseListener> closeListeners = new ArrayList<OnCloseListener>();
    public List<OnPackReceive> onPackReceives = new LinkedList<OnPackReceive>();

    @Override
    public void run() {
        if (this.config.getWebhookport() != null && this.config.getWebhookport() > 0) {
            this.hookAuth.webhookServerStart();
            return;
        }
        try {
            try {
                if (this.uri == null) {
                    this.uri = Judge.isEmpty((String)this.config.getWslink()) ? new URI(this.botBase.gateway().getUrl()) : new URI(this.config.getWslink());
                }
            }
            catch (NullPointerException ex) {
                this.logger.error(String.format("%s Probably The APPID or TOKEN is incorrect", ex.getClass().getName()));
                return;
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            this.logger.log("ws url:" + this.uri);
            if (this.webSocket != null && !this.webSocket.isClosed()) {
                this.webSocket.close();
            }
            this.webSocket = new WebSocketClient(this.uri){

                public void onOpen(ServerHandshake serverHandshake) {
                    if (WssWorker.this.preMethods(new Object[]{serverHandshake})) {
                        return;
                    }
                    WssWorker.this.logger.info("wss opened");
                }

                public void onMessage(String s) {
                    if (WssWorker.this.config.getWebSocketListener() != null && !WssWorker.this.config.getWebSocketListener().onMessage(WssWorker.this.webSocket, s)) {
                        return;
                    }
                    Pack pack = (Pack)Resource.GSON.fromJson(s, Pack.class);
                    WssWorker.this.logger.log(String.format("websocket-r: %s", s));
                    if (pack == null) {
                        WssWorker.this.logger.error(String.format("message pack parse error (%s)", s));
                    } else {
                        for (OnPackReceive onPackReceive : WssWorker.this.onPackReceives) {
                            if (onPackReceive.onReceive(pack)) break;
                        }
                    }
                    Integer n = WssWorker.this.msgr;
                    Integer n2 = WssWorker.this.msgr = Integer.valueOf(WssWorker.this.msgr + 1);
                }

                public void send(String msg) throws NotYetConnectedException {
                    if (WssWorker.this.preMethods(new Object[]{msg})) {
                        return;
                    }
                    super.send(msg);
                    WssWorker.this.logger.log("wss send: " + msg);
                    Integer n = WssWorker.this.msgs;
                    Integer n2 = WssWorker.this.msgs = Integer.valueOf(WssWorker.this.msgs + 1);
                }

                public void onClose(int i, String s, boolean b) {
                    if (WssWorker.this.preMethods(new Object[]{i, s, b})) {
                        return;
                    }
                    WssWorker.this.logger.waring("wss closed with code " + i + " " + s);
                    for (OnCloseListener onCloseListener : WssWorker.this.closeListeners) {
                        onCloseListener.onClose(i, WssWorker.this.webSocket);
                    }
                }

                public void onError(Exception e) {
                    if (WssWorker.this.preMethods(new Object[]{e})) {
                        return;
                    }
                    WssWorker.this.logger.error("wss error");
                    e.printStackTrace();
                }
            };
            this.webSocket.setConnectionLostTimeout(86);
            this.webSocket.connectBlocking(10L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.error("\u5728WebSocketClient\u542f\u52a8\u65f6\u5931\u8d25");
            e.printStackTrace();
            if (!this.config.getReconnect().booleanValue()) {
                return;
            }
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException ex) {
                e.printStackTrace();
            }
            this.run();
        }
    }

    public Boolean getReconnect() {
        Boolean k = (Boolean)this.contextManager.getContextEntity(Boolean.class, "is_reconnect");
        return k == null ? false : k;
    }

    public List<OnCloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    public List<OnPackReceive> getOnPackReceives() {
        return this.onPackReceives;
    }

    private boolean preMethods(Object ... objects) {
        WebSocketListener listener = this.config.getWebSocketListener();
        if (listener == null) {
            return false;
        }
        Object o1 = objects[0];
        if (o1 instanceof Exception) {
            return !listener.onError(this.webSocket, (Exception)o1);
        }
        if (o1 instanceof String) {
            return !listener.onSend(this.webSocket, o1.toString());
        }
        if (o1 instanceof ServerHandshake) {
            return !listener.onOpen(this.webSocket, (ServerHandshake)o1);
        }
        if (o1 instanceof Integer) {
            return !listener.onClose(this.webSocket, (Integer)objects[0], (String)objects[1], (Boolean)objects[2]);
        }
        return false;
    }
}

