/*
 * Decompiled with CFR 0.152.
 */
package io.github.magicpluginteam.pluginapi.utils;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.bukkit.plugin.java.JavaPlugin;

public class ClassUtils {
    public static List<String> getJarFiles(Class<?> clazz) {
        try {
            File file = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI());
            return new JarFile(file).stream().filter(ZipEntry::isDirectory).map(JarEntry::getRealName).toList();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            throw new AssertionError((Object)"Error occurred while get jar files");
        }
    }

    public static void loadJarFilesToFolder(JavaPlugin plugin, boolean force, List<String> include, List<String> exclude) {
        File[] files = plugin.getDataFolder().listFiles();
        if (files == null || files.length == 0) {
            ClassUtils.getJarFiles(plugin.getClass()).stream().filter(it -> include.stream().filter(it::endsWith).findFirst().orElse(null) != null && !exclude.contains(it)).filter(it -> force || !new File(plugin.getDataFolder(), (String)it).exists()).forEach(it -> plugin.saveResource(it, false));
        }
    }
}

