/*
 * Decompiled with CFR 0.152.
 */
package RenderMultipoints;

import ArmyC2.C2SD.Utilities.ErrorLogger;
import ArmyC2.C2SD.Utilities.IPointConversion;
import ArmyC2.C2SD.Utilities.MilStdSymbol;
import ArmyC2.C2SD.Utilities.RendererException;
import ArmyC2.C2SD.Utilities.RendererSettings;
import ArmyC2.C2SD.Utilities.ShapeInfo;
import ArmyC2.C2SD.Utilities.SymbolDraw;
import JavaLineArray.CELineArray;
import JavaLineArray.POINT2;
import JavaLineArray.Shape2;
import JavaLineArray.arraysupport;
import JavaLineArray.lineutility;
import JavaLineArray.ref;
import JavaTacticalRenderer.Modifier2;
import JavaTacticalRenderer.P1;
import JavaTacticalRenderer.TGLight;
import JavaTacticalRenderer.clsChannelUtility;
import JavaTacticalRenderer.clsMETOC;
import JavaTacticalRenderer.mdlGeodesic;
import RenderMultipoints.clsClipPolygon2;
import RenderMultipoints.clsClipQuad;
import RenderMultipoints.clsRenderer2;
import RenderMultipoints.clsUtility;
import RenderMultipoints.clsUtilityCPOF;
import RenderMultipoints.clsUtilityGE;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;

public final class clsRenderer {
    private static final String _className = "clsRenderer";
    private static final double feetPerMeter = 3.28084;

    private static void setClientCoords(MilStdSymbol milStd, TGLight tg) {
        try {
            ArrayList<POINT2> latLongs = new ArrayList<POINT2>();
            int j = 0;
            ArrayList coords = milStd.getCoordinates();
            Point2D.Double pt2d = null;
            POINT2 pt2 = null;
            for (j = 0; j < coords.size(); ++j) {
                pt2d = (Point2D.Double)coords.get(j);
                pt2 = clsUtility.Point2DToPOINT2(pt2d);
                latLongs.add(pt2);
            }
            tg.set_LatLongs(latLongs);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"setClientCoords", (Exception)new RendererException("Failed to set geo points or pixels for " + milStd.getSymbolID(), (Throwable)exc));
        }
    }

    private static ArrayList<Point2D.Double> getClientCoords(TGLight tg) {
        ArrayList<Point2D.Double> coords = null;
        try {
            int j = 0;
            Point2D.Double pt2d = null;
            POINT2 pt2 = null;
            coords = new ArrayList<Point2D.Double>();
            for (j = 0; j < tg.LatLongs.size(); ++j) {
                pt2 = (POINT2)tg.LatLongs.get(j);
                pt2d = new Point2D.Double(pt2.x, pt2.y);
                coords.add(pt2d);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"getClientCoords", (Exception)new RendererException("Failed to set geo points or pixels for " + tg.get_SymbolId(), (Throwable)exc));
        }
        return coords;
    }

    public static MilStdSymbol createMilStdSymboFromTGLight(TGLight tg, IPointConversion converter) {
        MilStdSymbol milStd = null;
        try {
            String symbolId = tg.get_SymbolId();
            int std = tg.getSymbologyStandard();
            JavaTacticalRenderer.clsUtility.initializeLinetypes((int)std);
            int lineType = JavaTacticalRenderer.clsUtility.GetLinetypeFromString((String)symbolId);
            String status = tg.get_Status();
            if (status == null || !status.equals("A") || !JavaTacticalRenderer.clsUtility.isBasicShape((int)lineType)) {
                // empty if block
            }
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            boolean isClosedArea = JavaTacticalRenderer.clsUtility.isClosedPolygon((int)lineType);
            if (isClosedArea) {
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.Pixels);
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.LatLongs);
            }
            ArrayList<Point2D.Double> coords = clsRenderer.getClientCoords(tg);
            tg.set_Font(new Font("Arial", 0, 12));
            HashMap<String, String> modifiers = new HashMap<String, String>();
            modifiers.put("W", tg.get_DTG());
            modifiers.put("W1", tg.get_DTG1());
            modifiers.put("H", tg.get_H());
            modifiers.put("H1", tg.get_H1());
            modifiers.put("H2", tg.get_H2());
            modifiers.put("T", tg.get_Name());
            modifiers.put("T1", tg.get_T1());
            modifiers.put("Y", tg.get_Location());
            modifiers.put("N", tg.get_N());
            milStd = new MilStdSymbol(symbolId, "1", coords, modifiers);
            milStd.setFillColor(tg.get_FillColor());
            milStd.setLineColor(tg.get_LineColor());
            milStd.setLineWidth(tg.get_LineThickness());
            milStd.setFillStyle(tg.get_TexturePaint());
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"createMilStdSymboFromTGLight", (Exception)new RendererException("Failed to set geo points or pixels for " + tg.get_SymbolId(), (Throwable)exc));
        }
        return milStd;
    }

    public static int getRevDLinetype(TGLight tg) {
        int linetype = -1;
        try {
            String symbolId = tg.get_SymbolId();
            if (symbolId.length() > 15) {
                String setA = symbolId.substring(0, 10);
                String setB = symbolId.substring(10);
                String code = setB.substring(0, 6);
                String symbolSet = setA.substring(4, 6);
                int nSymbol = Integer.parseInt(symbolSet);
                if (nSymbol == 25) {
                    linetype = clsRenderer.getCMLineType(symbolSet, code);
                } else if (nSymbol == 45 || nSymbol == 46) {
                    linetype = clsMETOC.getWeatherLinetype((String)symbolSet, (String)code);
                }
            } else {
                linetype = JavaTacticalRenderer.clsUtility.GetLinetypeFromString((String)symbolId);
            }
            tg.set_LineType(linetype);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"setRevDLinetype", (Exception)new RendererException("Failed in setRevDLinetype ", (Throwable)exc));
        }
        return linetype;
    }

    public static TGLight createTGLightFromMilStdSymbol(MilStdSymbol milStd, IPointConversion converter) {
        TGLight tg = new TGLight();
        try {
            ArrayList<Double> AN;
            ArrayList AM;
            String altitudeLabel;
            String symbolId = milStd.getSymbolID();
            int std = milStd.getSymbologyStandard();
            tg.setSymbologyStandard(std);
            JavaTacticalRenderer.clsUtility.initializeLinetypes((int)std);
            tg.set_SymbolId(symbolId);
            boolean useLineInterpolation = milStd.getUseLineInterpolation();
            tg.set_UseLineInterpolation(useLineInterpolation);
            int lineType = clsRenderer.getRevDLinetype(tg);
            String status = tg.get_Status();
            if (status != null && status.equals("A") && !JavaTacticalRenderer.clsUtility.isBasicShape((int)lineType)) {
                tg.set_LineStyle(1);
            }
            tg.set_VisibleModifiers(true);
            clsRenderer.setClientCoords(milStd, tg);
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            tg.set_Font(RendererSettings.getInstance().getMPLabelFont());
            tg.set_FillColor(milStd.getFillColor());
            tg.set_LineColor(milStd.getLineColor());
            tg.set_LineThickness(milStd.getLineWidth());
            tg.set_TexturePaint(milStd.getFillStyle());
            if (JavaTacticalRenderer.clsUtility.isBasicShape((int)lineType)) {
                tg.set_Fillstyle(milStd.getPatternFillType());
            }
            if (JavaTacticalRenderer.clsUtility.isBasicShape((int)lineType)) {
                tg.set_PatternFillType(milStd.getPatternFillType());
            }
            if (milStd.getTextColor() != null) {
                tg.set_TextColor(milStd.getTextColor());
            } else {
                tg.set_TextColor(tg.get_LineColor());
            }
            if (milStd.getTextBackgroundColor() != null) {
                tg.set_FontBackColor(milStd.getTextBackgroundColor());
            } else {
                tg.set_FontBackColor(SymbolDraw.getIdealTextBackgroundColor((Color)tg.get_TextColor()));
            }
            if (milStd.getModifier("W") != null) {
                tg.set_DTG(milStd.getModifier("W"));
            }
            if (milStd.getModifier("W1") != null) {
                tg.set_DTG1(milStd.getModifier("W1"));
            }
            if (milStd.getModifier("H") != null) {
                tg.set_H(milStd.getModifier("H"));
            }
            if (milStd.getModifier("H1") != null) {
                tg.set_H1(milStd.getModifier("H1"));
            }
            if (milStd.getModifier("H2") != null) {
                tg.set_H2(milStd.getModifier("H2"));
            }
            if (milStd.getModifier("T") != null) {
                tg.set_Name(milStd.getModifier("T"));
            }
            if (milStd.getModifier("T1") != null) {
                tg.set_T1(milStd.getModifier("T1"));
            }
            if (milStd.getModifier("Y") != null) {
                tg.set_Location(milStd.getModifier("Y"));
            }
            if (milStd.getModifier("N") != null) {
                tg.set_N(milStd.getModifier("N"));
            }
            tg.set_UseDashArray(milStd.getUseDashArray());
            tg.set_UseHatchFill(milStd.getUsePatternFill());
            tg.set_HideOptionalLabels(milStd.getHideOptionalLabels());
            boolean isClosedArea = JavaTacticalRenderer.clsUtility.isClosedPolygon((int)lineType);
            if (lineType == 23111000 && tg.Pixels.size() == 2) {
                POINT2 pt0 = (POINT2)tg.Pixels.get(0);
                POINT2 pt1 = (POINT2)tg.Pixels.get(1);
                POINT2 p0 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (int)2, (double)5.0);
                POINT2 p1 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt1, (int)2, (double)5.0);
                POINT2 p2 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt1, (int)3, (double)5.0);
                POINT2 p3 = lineutility.ExtendDirectedLine((POINT2)pt0, (POINT2)pt1, (POINT2)pt0, (int)3, (double)5.0);
                tg.Pixels.clear();
                tg.Pixels.add(p0);
                tg.Pixels.add(p1);
                tg.Pixels.add(p2);
                tg.Pixels.add(p3);
                tg.LatLongs = clsUtility.PixelsToLatLong(tg.Pixels, converter);
            }
            if (isClosedArea) {
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.Pixels);
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.LatLongs);
            }
            if ((altitudeLabel = milStd.getAltitudeMode()) == null || altitudeLabel.isEmpty()) {
                altitudeLabel = "MSL";
            }
            double x_alt = 0.0;
            int n_alt = 0;
            String strXAlt = "";
            if (lineType == 13000000 || lineType == 13000001 || lineType == 13000002) {
                POINT2 pt0;
                AM = milStd.getModifiers_AM_AN_X("AM");
                AN = milStd.getModifiers_AM_AN_X("AN");
                double r = 0.0;
                double b = 0.0;
                if (AM.size() == 1) {
                    r = (Double)AM.get(0);
                    AM.add(r);
                    AM.add(0.0);
                } else if (AM.size() == 2) {
                    r = (Double)AM.get(0);
                    b = (Double)AM.get(1);
                    AM.set(1, r);
                    AM.add(b);
                }
                if (AN == null) {
                    AN = new ArrayList<Double>();
                }
                if (AN.size() < 1) {
                    AN.add(new Double(0.0));
                }
                if (lineType == 13000002) {
                    double am0 = (Double)AM.get(0);
                    if (AM.size() < 2) {
                        AM.add(am0);
                    } else {
                        AM.set(1, am0);
                    }
                }
                if (AM != null && AM.size() >= 2 && AN != null && AN.size() >= 1) {
                    POINT2 ptAzimuth = new POINT2(0.0, 0.0);
                    ptAzimuth.x = (Double)AN.get(0);
                    POINT2 ptCenter = (POINT2)tg.Pixels.get(0);
                    pt0 = mdlGeodesic.geodesic_coordinate((POINT2)((POINT2)tg.LatLongs.get(0)), (double)((Double)AM.get(0)), (double)90.0);
                    POINT2 pt1 = mdlGeodesic.geodesic_coordinate((POINT2)((POINT2)tg.LatLongs.get(0)), (double)((Double)AM.get(1)), (double)0.0);
                    Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                    Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                    pt02d = converter.GeoToPixels(pt02d);
                    pt12d = converter.GeoToPixels(pt12d);
                    pt0 = new POINT2(pt02d.getX(), pt02d.getY());
                    pt1 = new POINT2(pt12d.getX(), pt12d.getY());
                    tg.Pixels = new ArrayList();
                    tg.Pixels.add(ptCenter);
                    tg.Pixels.add(pt0);
                    tg.Pixels.add(pt1);
                    tg.Pixels.add(ptAzimuth);
                }
                if (AM != null && AM.size() > 2) {
                    double dist = (Double)AM.get(2);
                    pt0 = mdlGeodesic.geodesic_coordinate((POINT2)((POINT2)tg.LatLongs.get(0)), (double)dist, (double)45.0);
                    Point2D pt02d = new Point2D.Double(((POINT2)tg.LatLongs.get((int)0)).x, ((POINT2)tg.LatLongs.get((int)0)).y);
                    Point2D pt12d = new Point2D.Double(pt0.x, pt0.y);
                    pt02d = converter.GeoToPixels(pt02d);
                    pt12d = converter.GeoToPixels(pt12d);
                    pt0 = new POINT2(pt02d.getX(), pt02d.getY());
                    POINT2 pt1 = new POINT2(pt12d.getX(), pt12d.getY());
                    dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)pt1);
                    ((POINT2)tg.Pixels.get((int)0)).style = (int)dist;
                }
            }
            if (lineType == 243112000) {
                AM = milStd.getModifiers_AM_AN_X("AM");
                AN = milStd.getModifiers_AM_AN_X("AN");
                ArrayList X = milStd.getModifiers_AM_AN_X("X");
                if (AM != null) {
                    String strT1 = "";
                    for (int j = 0; j < AM.size(); ++j) {
                        strT1 = strT1 + Double.toString((Double)AM.get(j));
                        if (j >= AM.size() - 1) continue;
                        strT1 = strT1 + ",";
                    }
                    tg.set_T1(strT1);
                }
                if (AN != null) {
                    String strT = "";
                    String az = "";
                    for (int j = 0; j < AN.size(); ++j) {
                        strT = strT + AN.get(j);
                        if (j >= AN.size() - 1) continue;
                        strT = strT + ",";
                    }
                    tg.set_Name(strT);
                }
                if (X != null) {
                    String strH1 = "";
                    for (int j = 0; j < X.size(); ++j) {
                        x_alt = (Double)X.get(j) * 3.28084;
                        x_alt *= 10.0;
                        x_alt = Math.round(x_alt);
                        n_alt = (int)x_alt;
                        x_alt = (double)n_alt / 10.0;
                        strXAlt = Double.toString(x_alt) + " ft. " + altitudeLabel;
                        strH1 = strH1 + strXAlt;
                        if (j >= X.size() - 1) continue;
                        strH1 = strH1 + ",";
                    }
                    tg.set_H1(strH1);
                }
                if (AM != null && AN != null) {
                    int len;
                    String c;
                    int numSectors = AN.size() / 2;
                    double min = 0.0;
                    double max = 0.0;
                    String strLeftRightMinMax = "";
                    for (int j = 0; j < numSectors; ++j) {
                        double left = (Double)AN.get(2 * j);
                        double right = (Double)AN.get(2 * j + 1);
                        if (j + 1 == AM.size()) break;
                        min = (Double)AM.get(j);
                        max = (Double)AM.get(j + 1);
                        strLeftRightMinMax = strLeftRightMinMax + Double.toString(left) + "," + Double.toString(right) + "," + Double.toString(min) + "," + Double.toString(max);
                        if (j >= numSectors - 1) continue;
                        strLeftRightMinMax = strLeftRightMinMax + ",";
                    }
                    if ((c = strLeftRightMinMax.substring((len = strLeftRightMinMax.length()) - 1, len)).equalsIgnoreCase(",")) {
                        strLeftRightMinMax = strLeftRightMinMax.substring(0, len - 1);
                    }
                    tg.set_H2(strLeftRightMinMax);
                }
            }
            int j = 0;
            if (lineType == 15000003 || lineType == 15000004) {
                double minLat = ((POINT2)tg.LatLongs.get((int)0)).y;
                double maxLat = ((POINT2)tg.LatLongs.get((int)0)).y;
                double minLong = ((POINT2)tg.LatLongs.get((int)0)).x;
                double maxLong = ((POINT2)tg.LatLongs.get((int)0)).x;
                for (j = 1; j < tg.LatLongs.size(); ++j) {
                    if (((POINT2)tg.LatLongs.get((int)j)).x < minLong) {
                        minLong = ((POINT2)tg.LatLongs.get((int)j)).x;
                    }
                    if (((POINT2)tg.LatLongs.get((int)j)).x > maxLong) {
                        maxLong = ((POINT2)tg.LatLongs.get((int)j)).x;
                    }
                    if (((POINT2)tg.LatLongs.get((int)j)).y < minLat) {
                        minLat = ((POINT2)tg.LatLongs.get((int)j)).y;
                    }
                    if (!(((POINT2)tg.LatLongs.get((int)j)).y > maxLat)) continue;
                    maxLat = ((POINT2)tg.LatLongs.get((int)j)).y;
                }
                tg.LatLongs = new ArrayList();
                tg.LatLongs.add(new POINT2(minLong, maxLat));
                tg.LatLongs.add(new POINT2(maxLong, maxLat));
                tg.LatLongs.add(new POINT2(maxLong, minLat));
                tg.LatLongs.add(new POINT2(minLong, minLat));
                if (lineType == 15000004) {
                    tg.LatLongs.add(new POINT2(minLong, maxLat));
                }
                tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            }
            switch (lineType) {
                case 15000000: 
                case 15000001: 
                case 15000003: {
                    String H2 = null;
                    double dist = 0.0;
                    ArrayList AM2 = milStd.getModifiers_AM_AN_X("AM");
                    if (AM2 != null && AM2.size() > 0) {
                        H2 = ((Double)AM2.get(0)).toString();
                        tg.set_H2(H2);
                    }
                    if (H2 == null || H2.isEmpty()) break;
                    for (j = 0; j < tg.LatLongs.size(); ++j) {
                        if (tg.LatLongs.size() <= j) continue;
                        if (!Double.isNaN(Double.parseDouble(H2))) {
                            if (j == 0) {
                                dist = Double.parseDouble(H2);
                                POINT2 pt0 = new POINT2((POINT2)tg.LatLongs.get(0));
                                POINT2 pt1 = mdlGeodesic.geodesic_coordinate((POINT2)pt0, (double)dist, (double)45.0);
                                Point2D pt02d = new Point2D.Double(pt0.x, pt0.y);
                                Point2D pt12d = new Point2D.Double(pt1.x, pt1.y);
                                pt02d = converter.GeoToPixels(pt02d);
                                pt12d = converter.GeoToPixels(pt12d);
                                pt0.x = pt02d.getX();
                                pt0.y = pt02d.getY();
                                pt1.x = pt12d.getX();
                                pt1.y = pt12d.getY();
                                dist = lineutility.CalcDistanceDouble((POINT2)pt0, (POINT2)pt1);
                            }
                            ((POINT2)tg.Pixels.get((int)j)).style = Math.round((float)dist);
                            continue;
                        }
                        ((POINT2)tg.Pixels.get((int)j)).style = 0;
                    }
                    break;
                }
            }
            if (lineType == 25200101) {
                ArrayList AM3 = milStd.getModifiers_AM_AN_X("AM");
                ArrayList AN2 = milStd.getModifiers_AM_AN_X("AN");
                if (AM3 != null && AM3.size() > 1) {
                    String H = ((Double)AM3.get(0)).toString();
                    tg.set_H(H);
                    String T1 = ((Double)AM3.get(1)).toString();
                    tg.set_T1(T1);
                }
                if (AN2 != null && AN2.size() > 0) {
                    String H2 = ((Double)AN2.get(0)).toString();
                    tg.set_H2(H2);
                }
            }
            switch (lineType) {
                case 22231000: 
                case 22232000: 
                case 22233000: 
                case 22234000: 
                case 22234100: 
                case 22234200: 
                case 24322100: 
                case 24322200: 
                case 24322300: {
                    ArrayList X = milStd.getModifiers_AM_AN_X("X");
                    if (X != null && X.size() > 0) {
                        x_alt = (Double)X.get(0) * 3.28084;
                        x_alt *= 10.0;
                        x_alt = Math.round(x_alt);
                        n_alt = (int)x_alt;
                        x_alt = (double)n_alt / 10.0;
                        strXAlt = Double.toString(x_alt) + " ft. " + altitudeLabel;
                        tg.set_H(strXAlt);
                    }
                    if (X == null || X.size() <= 1) break;
                    x_alt = (Double)X.get(1) * 3.28084;
                    x_alt *= 10.0;
                    x_alt = Math.round(x_alt);
                    n_alt = (int)x_alt;
                    x_alt = (double)n_alt / 10.0;
                    strXAlt = Double.toString(x_alt) + " ft. " + altitudeLabel;
                    tg.set_H1(strXAlt);
                    break;
                }
                case 22221000: 
                case 22222000: 
                case 22222001: 
                case 22223000: 
                case 22224000: 
                case 22224001: 
                case 22225000: {
                    POINT2 pt = (POINT2)tg.LatLongs.get(0);
                    Point2D.Double pt2d0 = new Point2D.Double(pt.x, pt.y);
                    Point2D pt2d0Pixels = converter.GeoToPixels((Point2D)pt2d0);
                    POINT2 pt0Pixels = new POINT2(pt2d0Pixels.getX(), pt2d0Pixels.getY());
                    double dist = 10000.0;
                    POINT2 pt2 = mdlGeodesic.geodesic_coordinate((POINT2)pt, (double)dist, (double)0.0);
                    Point2D.Double pt2d1 = new Point2D.Double(pt2.x, pt2.y);
                    Point2D pt2d1Pixels = converter.GeoToPixels((Point2D)pt2d1);
                    POINT2 pt1Pixels = new POINT2(pt2d1Pixels.getX(), pt2d1Pixels.getY());
                    double distPixels = lineutility.CalcDistanceDouble((POINT2)pt0Pixels, (POINT2)pt1Pixels);
                    double pixelsPerMeter = distPixels / dist;
                    ArrayList AM4 = milStd.getModifiers_AM_AN_X("AM");
                    if (AM4 != null) {
                        String H2 = "";
                        for (j = 0; j < AM4.size(); ++j) {
                            H2 = H2 + ((Double)AM4.get(j)).toString();
                            if (j >= AM4.size() - 1) continue;
                            H2 = H2 + ",";
                        }
                        tg.set_H2(H2);
                    }
                    String[] strRadii = null;
                    double maxWidth = 0.0;
                    double temp = 0.0;
                    double maxWidthMeters = 0.0;
                    if (tg.get_H2() != null && !tg.get_H2().isEmpty() && (strRadii = tg.get_H2().split(",")) != null && strRadii.length > 0) {
                        for (j = 0; j < strRadii.length; ++j) {
                            if (Double.isNaN(Double.parseDouble(strRadii[j])) || !((temp = Double.parseDouble(strRadii[j])) > maxWidth)) continue;
                            maxWidth = temp;
                        }
                        maxWidthMeters = maxWidth;
                        maxWidth *= pixelsPerMeter / 2.0;
                    }
                    if (tg.get_H2() != null && !tg.get_H2().isEmpty() && strRadii != null && strRadii.length > 0) {
                        double pixels = 0.0;
                        for (j = 0; j < tg.Pixels.size(); ++j) {
                            if (tg.Pixels.size() <= j) continue;
                            if (strRadii.length > j) {
                                if (!Double.isNaN(Double.parseDouble(strRadii[j]))) {
                                    pixels = Double.parseDouble(strRadii[j]) * pixelsPerMeter / 2.0;
                                    ((POINT2)tg.Pixels.get((int)j)).style = (int)pixels;
                                    ((POINT2)tg.LatLongs.get((int)j)).style = (int)pixels;
                                    continue;
                                }
                                ((POINT2)tg.Pixels.get((int)j)).style = (int)maxWidth;
                                ((POINT2)tg.LatLongs.get((int)j)).style = (int)maxWidth;
                                continue;
                            }
                            ((POINT2)tg.Pixels.get((int)j)).style = (int)maxWidth;
                            ((POINT2)tg.LatLongs.get((int)j)).style = (int)maxWidth;
                        }
                    }
                    tg.set_H2(Double.toString(maxWidthMeters) + "m");
                    ArrayList X = milStd.getModifiers_AM_AN_X("X");
                    if (X != null && X.size() > 0) {
                        x_alt = (Double)X.get(0) * 3.28084;
                        x_alt *= 10.0;
                        x_alt = Math.round(x_alt);
                        n_alt = (int)x_alt;
                        x_alt = (double)n_alt / 10.0;
                        strXAlt = Double.toString(x_alt) + " ft. " + altitudeLabel;
                        tg.set_H(strXAlt);
                    }
                    if (X == null || X.size() <= 1) break;
                    x_alt = (Double)X.get(1) * 3.28084;
                    x_alt *= 10.0;
                    x_alt = Math.round(x_alt);
                    n_alt = (int)x_alt;
                    x_alt = (double)n_alt / 10.0;
                    strXAlt = Double.toString(x_alt) + " ft. " + altitudeLabel;
                    tg.set_H1(strXAlt);
                    break;
                }
            }
            switch (lineType) {
                case 24361000: 
                case 24362000: 
                case 24363000: {
                    ArrayList X = milStd.getModifiers_AM_AN_X("X");
                    String strH1 = "";
                    if (X == null || X.isEmpty()) break;
                    x_alt = (Double)X.get(0) * 3.28084;
                    x_alt *= 10.0;
                    x_alt = Math.round(x_alt);
                    n_alt = (int)x_alt;
                    x_alt = (double)n_alt / 10.0;
                    strXAlt = Double.toString(x_alt) + " ft. " + altitudeLabel;
                    tg.set_H1(strXAlt);
                    break;
                }
            }
            if (lineType == 243111000) {
                ArrayList AM5 = milStd.getModifiers_AM_AN_X("AM");
                ArrayList X = milStd.getModifiers_AM_AN_X("X");
                String strH2 = "";
                String strH1 = "";
                if (AM5 != null) {
                    for (j = 0; j < AM5.size(); ++j) {
                        strH2 = strH2 + Double.toString((Double)AM5.get(j));
                        if (j < AM5.size() - 1) {
                            strH2 = strH2 + ",";
                        }
                        if (X != null && j < X.size()) {
                            x_alt = (Double)X.get(j) * 3.28084;
                            x_alt *= 10.0;
                            x_alt = Math.round(x_alt);
                            n_alt = (int)x_alt;
                            x_alt = (double)n_alt / 10.0;
                            strXAlt = Double.toString(x_alt) + " ft. " + altitudeLabel;
                            strH1 = strH1 + strXAlt;
                            if (j < X.size() - 1) {
                                strH1 = strH1 + ",";
                            }
                        }
                        if (j == 2) break;
                    }
                }
                tg.set_H2(strH2);
                tg.set_H1(strH1);
            }
            switch (lineType) {
                case 15000000: 
                case 15000001: 
                case 15000002: 
                case 15000003: {
                    if (tg.get_FillColor() != null) break;
                    tg.set_FillColor(Color.LIGHT_GRAY);
                    break;
                }
            }
            switch (lineType) {
                case 15000002: 
                case 24312000: 
                case 24321200: 
                case 24321300: 
                case 24322200: 
                case 24322300: 
                case 24323200: 
                case 24323300: 
                case 24324200: 
                case 24324300: 
                case 24325200: 
                case 24325300: 
                case 24326101: 
                case 24326200: 
                case 24331200: 
                case 24331300: 
                case 24332200: 
                case 24332300: 
                case 24333200: 
                case 24333300: 
                case 24334200: 
                case 24334300: 
                case 24335200: 
                case 24335300: 
                case 24336200: 
                case 24336300: 
                case 24337200: 
                case 24337300: 
                case 24338200: 
                case 24338300: 
                case 24339200: 
                case 24339300: 
                case 24352000: 
                case 24353000: 
                case 24362000: 
                case 24363000: {
                    ArrayList AM6 = milStd.getModifiers_AM_AN_X("AM");
                    if (AM6 != null && AM6.size() > 0) {
                        String strT1 = Double.toString((Double)AM6.get(0));
                        tg.set_T1(strT1);
                        break;
                    }
                    if (lineType != 15000002 || tg.LatLongs.size() <= 1) break;
                    double dist = mdlGeodesic.geodesic_distance((POINT2)((POINT2)tg.LatLongs.get(0)), (POINT2)((POINT2)tg.LatLongs.get(1)), null, null);
                    String strT1 = Double.toString(dist);
                    tg.set_T1(strT1);
                    break;
                }
            }
            if (lineType == 24311000 || lineType == 14000001 || lineType == 14000002) {
                ArrayList AM7 = milStd.getModifiers_AM_AN_X("AM");
                ArrayList<Double> AN3 = milStd.getModifiers_AM_AN_X("AN");
                if (lineType == 14000002) {
                    double r = (Double)AM7.get(0);
                    double b = 0.0;
                    if (AM7.size() == 1) {
                        AM7.add(r);
                        AM7.add(b);
                    } else if (AM7.size() == 2) {
                        b = (Double)AM7.get(1);
                        AM7.set(1, r);
                        AM7.add(b);
                    } else if (AM7.size() > 2) {
                        AM7.set(1, r);
                    }
                }
                if (lineType == 14000002) {
                    double am0 = (Double)AM7.get(0);
                    if (AM7.size() < 2) {
                        AM7.add(am0);
                    } else {
                        AM7.set(1, am0);
                    }
                }
                if (AN3 == null) {
                    AN3 = new ArrayList<Double>();
                }
                if (AN3.isEmpty()) {
                    AN3.add(0.0);
                }
                if (AM7 != null && AM7.size() > 1 && AN3 != null && AN3.size() > 0) {
                    String strT1 = Double.toString((Double)AM7.get(0));
                    String strH = Double.toString((Double)AM7.get(1));
                    tg.set_T1(strT1);
                    tg.set_H(strH);
                    String strH2 = Double.toString((Double)AN3.get(0));
                    tg.set_H2(strH2);
                }
                if (AM7.size() > 2) {
                    String strH1 = Double.toString((Double)AM7.get(2));
                    tg.set_H1(strH1);
                }
                if (AM7.size() <= 2) {
                    tg.set_H1("0");
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"createTGLightfromMilStdSymbol", (Exception)new RendererException("Failed to build multipoint TG for " + milStd.getSymbolID(), (Throwable)exc));
        }
        return tg;
    }

    public static TGLight createTGLightFromMilStdSymbol(MilStdSymbol milStd, IPointConversion converter, Boolean computeChannelPt) {
        TGLight tg = new TGLight();
        try {
            int lineType;
            boolean isClosedArea;
            String symbolId = milStd.getSymbolID();
            tg.set_SymbolId(symbolId);
            String status = tg.get_Status();
            if (status != null && status.equals("A")) {
                tg.set_LineStyle(1);
            }
            tg.set_VisibleModifiers(true);
            clsRenderer.setClientCoords(milStd, tg);
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, converter);
            tg.set_Font(new Font("Arial", 0, 12));
            tg.set_FillColor(milStd.getFillColor());
            tg.set_LineColor(milStd.getLineColor());
            tg.set_LineThickness(milStd.getLineWidth());
            tg.set_TexturePaint(milStd.getFillStyle());
            tg.set_FontBackColor(Color.WHITE);
            tg.set_TextColor(tg.get_LineColor());
            if (milStd.getModifier("W") != null) {
                tg.set_DTG(milStd.getModifier("W"));
            }
            if (milStd.getModifier("W1") != null) {
                tg.set_DTG1(milStd.getModifier("W1"));
            }
            if (milStd.getModifier("H") != null) {
                tg.set_H(milStd.getModifier("H"));
            }
            if (milStd.getModifier("H1") != null) {
                tg.set_H1(milStd.getModifier("H1"));
            }
            if (milStd.getModifier("H2") != null) {
                tg.set_H2(milStd.getModifier("H2"));
            }
            if (milStd.getModifier("T") != null) {
                tg.set_Name(milStd.getModifier("T"));
            }
            if (milStd.getModifier("T1") != null) {
                tg.set_T1(milStd.getModifier("T1"));
            }
            if (milStd.getModifier("Y") != null) {
                tg.set_Location(milStd.getModifier("Y"));
            }
            if (milStd.getModifier("N") != null) {
                tg.set_N(milStd.getModifier("N"));
            }
            if (isClosedArea = JavaTacticalRenderer.clsUtility.isClosedPolygon((int)(lineType = JavaTacticalRenderer.clsUtility.GetLinetypeFromString((String)symbolId)))) {
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.Pixels);
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.LatLongs);
            }
            if (computeChannelPt.booleanValue()) {
                switch (lineType) {
                    case 21700000: 
                    case 21710000: 
                    case 22320000: 
                    case 22521100: 
                    case 22521200: 
                    case 22521300: 
                    case 22521410: 
                    case 22521420: {
                        POINT2 ptPixels = JavaTacticalRenderer.clsUtility.ComputeLastPoint((ArrayList)tg.Pixels);
                        tg.Pixels.add(ptPixels);
                        Point pt = clsUtility.POINT2ToPoint(ptPixels);
                        Point2D ptGeo2d = converter.PixelsToGeo((Point2D)pt);
                        POINT2 ptGeo = new POINT2(ptGeo2d.getX(), ptGeo2d.getY());
                        tg.LatLongs.add(ptGeo);
                        break;
                    }
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"createTGLightfromMilStdSymbol", (Exception)new RendererException("Failed to build multipoint TG for " + milStd.getSymbolID(), (Throwable)exc));
        }
        return tg;
    }

    public static void render(MilStdSymbol symbol, IPointConversion converter) {
        try {
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbol(symbol, converter, null);
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            clsUtility.FilterAXADPoints(tg, converter);
            clsUtility.FilterPoints(tg);
            clsRenderer.GetLineArray(tg, converter, shapeInfos, modifierShapeInfos);
            symbol.setModifierShapes(modifierShapeInfos);
            symbol.setSymbolShapes(shapeInfos);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render", (Exception)new RendererException("Failed to render " + symbol.getSymbolID(), (Throwable)exc));
        }
    }

    public static void render_TG(TGLight tg, IPointConversion converter, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos) {
        try {
            int lineType = -1;
            boolean isClosedArea = false;
            clsRenderer.setHostileLC(tg);
            String symbolId = tg.get_SymbolId();
            lineType = clsMETOC.IsWeather((String)symbolId);
            if (lineType < 0) {
                lineType = JavaTacticalRenderer.clsUtility.GetLinetypeFromString((String)symbolId);
            }
            if (isClosedArea = JavaTacticalRenderer.clsUtility.isClosedPolygon((int)lineType)) {
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.Pixels);
                JavaTacticalRenderer.clsUtility.ClosePolygon((ArrayList)tg.LatLongs);
            }
            clsUtility.FilterAXADPoints(tg, converter);
            clsUtility.FilterPoints(tg);
            clsRenderer.GetLineArray(tg, converter, shapeInfos, modifierShapeInfos);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render", (Exception)new RendererException("Failed to render " + tg.get_SymbolId(), (Throwable)exc));
        }
    }

    private static void GetLineArray(TGLight tg, IPointConversion converter, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos) {
        try {
            ArrayList<Shape2> shapes = new ArrayList<Shape2>();
            ArrayList<Shape2> modifierShapes = new ArrayList<Shape2>();
            int lineType = tg.get_LineType();
            int minPoints2 = JavaTacticalRenderer.clsUtility.GetMinPoints((int)lineType);
            ref minPoints = new ref();
            ArrayList channelPoints = new ArrayList();
            boolean bolChange1 = JavaTacticalRenderer.clsUtility.IsChange1Area((int)lineType, (ref)minPoints);
            int bolMeTOC = clsMETOC.IsWeather((String)tg.get_SymbolId());
            tg.modifiers = new ArrayList();
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            Modifier2.AddModifiersGeo((TGLight)tg, (Graphics2D)g2d, null, (IPointConversion)converter);
            int rev = tg.getSymbologyStandard();
            Object hatchShape = null;
            if (converter == null) {
                JavaTacticalRenderer.clsUtility.getHatchShape((TGLight)tg, (BufferedImage)bi);
            }
            if (tg.Pixels.size() < minPoints2) {
                lineType = -1;
                bolChange1 = false;
            }
            if (bolChange1) {
                tg.Pixels.clear();
                bolChange1 = clsUtilityCPOF.Change1TacticalAreas(tg, lineType, converter, shapes);
            } else if (bolMeTOC > 0) {
                try {
                    clsMETOC.GetMeTOCShape((TGLight)tg, shapes, (int)rev);
                }
                catch (Exception ex) {
                    JavaTacticalRenderer.clsUtility.WriteFile((String)"Error in ClsMETOC.GetMeTOCShape");
                }
            } else if (CELineArray.CIsChannel((int)lineType) == 0) {
                if (lineType != 23111001) {
                    tg.Pixels = arraysupport.GetLineArray2((int)lineType, (ArrayList)tg.Pixels, shapes, null, (int)rev, (IPointConversion)converter);
                    Modifier2.GetIntegralTextShapes((TGLight)tg, (Graphics2D)g2d, shapes);
                }
                if (lineType == 23111001) {
                    ArrayList tempShapes = null;
                    ArrayList partitions = clsChannelUtility.GetPartitions2((TGLight)tg);
                    ArrayList pixels = null;
                    int l = 0;
                    int k = 0;
                    for (l = 0; l < partitions.size(); ++l) {
                        tempShapes = new ArrayList();
                        pixels = new ArrayList();
                        for (k = ((P1)partitions.get((int)l)).start; k <= ((P1)partitions.get((int)l)).end_Renamed + 1; ++k) {
                            pixels.add((POINT2)tg.Pixels.get(k));
                        }
                        pixels = arraysupport.GetLineArray2((int)lineType, pixels, tempShapes, null, (int)rev, (IPointConversion)converter);
                        shapes.addAll(tempShapes);
                    }
                }
            } else {
                clsChannelUtility.DrawChannel((ArrayList)tg.Pixels, (int)lineType, (TGLight)tg, shapes, channelPoints, (int)rev);
                tg.Pixels = channelPoints;
            }
            JavaTacticalRenderer.clsUtility.SetShapeProperties((TGLight)tg, shapes, (BufferedImage)bi);
            Modifier2.AddModifiers2((TGLight)tg);
            if (hatchShape != null) {
                shapes.add((Shape2)hatchShape);
            }
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
            if (modifierShapeInfos != null) {
                Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, modifierShapes, (boolean)false, (IPointConversion)converter);
                clsRenderer.Shape2ToShapeInfo(modifierShapeInfos, modifierShapes);
                bi.flush();
                g2d.dispose();
                bi = null;
                g2d = null;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"GetLineArray", (Exception)new RendererException("Points calculator failed for " + tg.get_SymbolId(), (Throwable)exc));
        }
    }

    private static void setShapeInfoType(ShapeInfo shapeInfo, Shape2 shape) {
        if (shape.getShapeType() == Shape2.SHAPE_TYPE_FILL) {
            shapeInfo.setShapeType(ShapeInfo.SHAPE_TYPE_FILL);
        } else if (shape.getShapeType() == Shape2.SHAPE_TYPE_MODIFIER) {
            shapeInfo.setShapeType(ShapeInfo.SHAPE_TYPE_MODIFIER);
        } else if (shape.getShapeType() == Shape2.SHAPE_TYPE_MODIFIER_FILL) {
            shapeInfo.setShapeType(ShapeInfo.SHAPE_TYPE_MODIFIER_FILL);
        } else {
            shapeInfo.setShapeType(ShapeInfo.SHAPE_TYPE_POLYLINE);
        }
    }

    private static void Shape2ToShapeInfo(ArrayList<ShapeInfo> shapeInfos, ArrayList<Shape2> shapes) {
        try {
            int j = 0;
            Shape2 shape = null;
            if (shapes == null || shapeInfos == null || shapes.size() == 0) {
                return;
            }
            for (j = 0; j < shapes.size(); ++j) {
                shape = shapes.get(j);
                shapeInfos.add((ShapeInfo)shape);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"Shape2ToShapeInfo", (Exception)new RendererException("Failed to build ShapeInfo ArrayList", (Throwable)exc));
        }
    }

    private static boolean setGenericLine(TGLight tg, IPointConversion converter, Rectangle2D clipBounds) {
        boolean result = false;
        try {
            if (clipBounds == null) {
                return false;
            }
            double scale = clsRenderer.getScale(tg, converter, clipBounds);
            double mbrDist = 0.0;
            POINT2 ptUl = new POINT2();
            POINT2 ptUr = new POINT2();
            POINT2 ptLr = new POINT2();
            POINT2 ptLl = new POINT2();
            if (scale < 500.0) {
                Modifier2.GetMBR((TGLight)tg, (POINT2)ptUl, (POINT2)ptUr, (POINT2)ptLr, (POINT2)ptLl);
                mbrDist = lineutility.CalcDistanceDouble((POINT2)ptUl, (POINT2)ptLr);
                if (mbrDist > 1000.0) {
                    tg.set_SymbolId("GENERIC---****X");
                    tg.set_LineType(22131001);
                    result = true;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"setGenericLine", (Exception)new RendererException("Failed inside setGenericLine", (Throwable)exc));
        }
        return result;
    }

    private static void shiftClipPoints(ArrayList<Point2D> clipPoints) {
        int j = 0;
        Point2D pt0 = null;
        Point2D pt1 = null;
        for (j = 0; j < clipPoints.size() - 1; ++j) {
            pt0 = clipPoints.get(j);
            pt1 = clipPoints.get(j + 1);
            if (pt0.getX() == pt1.getX()) {
                pt1.setLocation(pt1.getX() + 1.0, pt1.getY());
            }
            if (pt0.getY() != pt1.getY()) continue;
            pt1.setLocation(pt1.getX(), pt1.getY() + 1.0);
        }
        pt0 = clipPoints.get(0);
        Point2D ptLast = clipPoints.get(clipPoints.size() - 1);
    }

    public static boolean intersectsClipArea(TGLight tg, IPointConversion converter, Object clipArea) {
        boolean result = false;
        try {
            double minx;
            double coordsTop;
            double coordsLeft;
            if (clipArea == null || tg.LatLongs.size() < 2) {
                return true;
            }
            RectangularShape clipBounds = null;
            ArrayList clipPoints = null;
            if (clipArea != null) {
                if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                    clipBounds = (Rectangle2D.Double)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                    clipBounds = (Rectangle2D)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                    clipPoints = (ArrayList)clipArea;
                    clipBounds = clsUtility.getMBR(clipPoints);
                }
            }
            int j = 0;
            double x = clipBounds.getMinX();
            double y = clipBounds.getMinY();
            double width = clipBounds.getWidth();
            double height = clipBounds.getHeight();
            POINT2 tl = new POINT2(x, y);
            POINT2 br = new POINT2(x + width, y + height);
            tl = clsUtility.PointPixelsToLatLong(tl, converter);
            br = clsUtility.PointPixelsToLatLong(br, converter);
            double coordsRight = coordsLeft = ((POINT2)tg.LatLongs.get((int)0)).x;
            double coordsBottom = coordsTop = ((POINT2)tg.LatLongs.get((int)0)).y;
            boolean intersects = false;
            double maxx = minx = ((POINT2)tg.LatLongs.get((int)0)).x;
            double maxNegX = 0.0;
            for (j = 0; j < tg.LatLongs.size(); ++j) {
                POINT2 pt = (POINT2)tg.LatLongs.get(j);
                if (pt.x < minx) {
                    minx = pt.x;
                }
                if (pt.x > maxx) {
                    maxx = pt.x;
                }
                if (maxNegX == 0.0 && pt.x < 0.0) {
                    maxNegX = pt.x;
                }
                if (maxNegX < 0.0 && pt.x < 0.0 && pt.x > maxNegX) {
                    maxNegX = pt.x;
                }
                if (pt.y < coordsBottom) {
                    coordsBottom = pt.y;
                }
                if (!(pt.y > coordsTop)) continue;
                coordsTop = pt.y;
            }
            boolean coordSpanIDL = false;
            if (maxx == 180.0 || minx == -180.0) {
                coordSpanIDL = true;
            }
            if (maxx - minx >= 180.0) {
                coordSpanIDL = true;
                coordsLeft = maxx;
                coordsRight = maxNegX;
            } else {
                coordsLeft = minx;
                coordsRight = maxx;
            }
            if (br.y <= coordsBottom && coordsBottom <= tl.y) {
                intersects = true;
            } else if (coordsBottom <= br.y && br.y <= coordsTop) {
                intersects = true;
            } else {
                return false;
            }
            intersects = false;
            boolean boxSpanIDL = false;
            if (tl.x == 180.0 || tl.x == -180.0 || br.x == 180.0 || br.x == -180.0) {
                boxSpanIDL = true;
            } else if (Math.abs(br.x - tl.x) > 180.0) {
                boxSpanIDL = true;
            }
            if (coordSpanIDL && boxSpanIDL) {
                intersects = true;
            } else if (!coordSpanIDL && !boxSpanIDL) {
                if (coordsLeft <= tl.x && tl.x <= coordsRight) {
                    intersects = true;
                }
                if (coordsLeft <= br.x && br.x <= coordsRight) {
                    intersects = true;
                }
                if (tl.x <= coordsLeft && coordsLeft <= br.x) {
                    intersects = true;
                }
                if (tl.x <= coordsRight && coordsRight <= br.x) {
                    intersects = true;
                }
            } else if (!coordSpanIDL && boxSpanIDL) {
                if (tl.x < coordsRight && coordsRight < 180.0) {
                    intersects = true;
                }
                if (-180.0 < coordsLeft && coordsLeft < br.x) {
                    intersects = true;
                }
            } else if (coordSpanIDL && !boxSpanIDL) {
                if (coordsLeft < br.x && br.x < 180.0) {
                    intersects = true;
                }
                if (-180.0 < tl.x && tl.x < coordsRight) {
                    intersects = true;
                }
            }
            return intersects;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"intersectsClipArea", (Exception)new RendererException("Failed inside intersectsClipArea", (Throwable)exc));
            return result;
        }
    }

    public static void renderWithPolylines(MilStdSymbol mss, IPointConversion converter, Object clipArea) {
        try {
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbol(mss, converter);
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            double scale = clsRenderer.getScale(tg, converter, clipArea);
            if (clsRenderer.intersectsClipArea(tg, converter, clipArea)) {
                clsRenderer.render_GE(tg, shapeInfos, modifierShapeInfos, converter, clipArea);
            }
            mss.setSymbolShapes(shapeInfos);
            mss.setModifierShapes(modifierShapeInfos);
            mss.set_WasClipped(tg.get_WasClipped());
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"renderWithPolylines", (Exception)new RendererException("Failed inside renderWithPolylines", (Throwable)exc));
        }
    }

    private static void reversePoints(TGLight tg) {
        int j = 0;
        ArrayList pts = null;
        switch (tg.get_LineType()) {
            case 231117100: 
            case 231117101: {
                if (tg.Pixels != null) {
                    pts = (ArrayList)tg.Pixels.clone();
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        tg.Pixels.set(j, (POINT2)pts.get(pts.size() - j - 1));
                    }
                }
                if (tg.LatLongs == null) break;
                pts = (ArrayList)tg.LatLongs.clone();
                for (j = 0; j < tg.LatLongs.size(); ++j) {
                    tg.LatLongs.set(j, (POINT2)pts.get(pts.size() - j - 1));
                }
                break;
            }
        }
    }

    private static void reversePointsRevD(TGLight tg) {
        try {
            int j = 0;
            ArrayList pts = null;
            if (tg.get_SymbolId().length() < 20) {
                return;
            }
            String setB = tg.get_SymbolId().substring(10);
            String entityCode = setB.substring(0, 6);
            int nCode = Integer.parseInt(entityCode);
            switch (nCode) {
                case 290301: 
                case 290305: 
                case 290306: 
                case 290307: 
                case 290308: 
                case 290309: {
                    if (tg.Pixels != null) {
                        pts = (ArrayList)tg.Pixels.clone();
                        for (j = 0; j < tg.Pixels.size(); ++j) {
                            tg.Pixels.set(j, (POINT2)pts.get(pts.size() - j - 1));
                        }
                    }
                    if (tg.LatLongs == null) break;
                    pts = (ArrayList)tg.LatLongs.clone();
                    for (j = 0; j < tg.LatLongs.size(); ++j) {
                        tg.LatLongs.set(j, (POINT2)pts.get(pts.size() - j - 1));
                    }
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"renderWithPolylines", (Exception)new RendererException("Failed inside renderWithPolylines", (Throwable)exc));
        }
    }

    public static void render_GE(TGLight tg, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos, IPointConversion converter, Object clipArea) {
        try {
            clsRenderer.setTGProperties(tg);
            double scale = clsRenderer.getScale(tg, converter, clipArea);
            Rectangle2D clipBounds = null;
            CELineArray.setClient((String)"ge");
            ArrayList origFillPixels = lineutility.getDeepCopy((ArrayList)tg.Pixels);
            ArrayList<Point2D> clipPoints = null;
            if (clipArea != null) {
                if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                    clipBounds = (Rectangle2D.Double)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                    clipBounds = (Rectangle2D)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                    clipPoints = (ArrayList<Point2D>)clipArea;
                }
            }
            double zoomFactor = clsUtilityGE.getZoomFactor(clipBounds, clipPoints, tg.Pixels);
            boolean useClipPoints = false;
            if (useClipPoints && clipBounds != null) {
                double x = clipBounds.getMinX();
                double y = clipBounds.getMinY();
                double width = clipBounds.getWidth();
                double height = clipBounds.getHeight();
                clipPoints = new ArrayList<Point2D>();
                clipPoints.add(new Point2D.Double(x, y));
                clipPoints.add(new Point2D.Double(x + width, y));
                clipPoints.add(new Point2D.Double(x + width, y + height));
                clipPoints.add(new Point2D.Double(x, y + height));
                clipPoints.add(new Point2D.Double(x, y));
                clipBounds = null;
            }
            if (tg.get_Client() == null || tg.get_Client().isEmpty()) {
                tg.set_client("ge");
            }
            clsUtility.RemoveDuplicatePoints(tg);
            int rev = tg.getSymbologyStandard();
            JavaTacticalRenderer.clsUtility.initializeLinetypes((int)rev);
            JavaTacticalRenderer.clsUtility.setRevC((TGLight)tg);
            int linetype = tg.get_LineType();
            if (linetype < 0) {
                linetype = JavaTacticalRenderer.clsUtility.GetLinetypeFromString((String)tg.get_SymbolId());
                tg.set_LineType(linetype);
            }
            Boolean isTextFlipped = false;
            ArrayList<Shape2> shapes = null;
            clsUtilityGE.setSplineLinetype(tg);
            clsRenderer.setHostileLC(tg);
            clsUtilityCPOF.SegmentGeoPoints(tg, converter, zoomFactor);
            if ((clipBounds != null || clipPoints != null) && clsUtilityCPOF.canClipPoints(tg).booleanValue()) {
                if (clipBounds != null) {
                    clsClipPolygon2.ClipPolygon(tg, clipBounds);
                } else if (clipPoints != null) {
                    clsClipQuad.ClipPolygon(tg, clipPoints);
                }
                clsUtilityGE.removeTrailingPoints(tg, clipArea);
                tg.LatLongs = clsUtility.PixelsToLatLong(tg.Pixels, converter);
            }
            JavaTacticalRenderer.clsUtility.InterpolatePixels((TGLight)tg);
            tg.modifiers = new ArrayList();
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            Modifier2.AddModifiersGeo2((TGLight)tg, (Graphics2D)g2d, (Object)clipArea, (IPointConversion)converter);
            clsUtilityCPOF.FilterPoints2(tg, converter);
            JavaTacticalRenderer.clsUtility.FilterVerticalSegments((TGLight)tg);
            clsUtility.FilterAXADPoints(tg, converter);
            clsUtilityCPOF.ClearPixelsStyle(tg);
            ArrayList<Shape2> linesWithFillShapes = null;
            ArrayList savePixels = tg.Pixels;
            tg.Pixels = origFillPixels;
            if (clipBounds != null) {
                linesWithFillShapes = clsClipPolygon2.LinesWithFill(tg, clipBounds);
            } else if (clipPoints != null) {
                linesWithFillShapes = clsClipQuad.LinesWithFill(tg, clipPoints);
            } else if (clipArea == null) {
                linesWithFillShapes = clsClipPolygon2.LinesWithFill(tg, clipBounds);
            }
            tg.Pixels = savePixels;
            ArrayList<Shape2> rangeFanFillShapes = null;
            int savefillStyle = tg.get_FillStyle();
            if (linetype == 243111000) {
                tg.set_Fillstyle(0);
            }
            if (clipBounds != null) {
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
            } else if (clipPoints != null) {
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipPoints);
            } else if (clipArea == null) {
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
            }
            switch (linetype) {
                case 243111000: 
                case 243112000: {
                    if (tg.get_FillColor() == null || tg.get_FillColor().getAlpha() < 2) break;
                    TGLight tg1 = clsUtilityCPOF.GetCircularRangeFanFillTG(tg);
                    tg1.set_Fillstyle(savefillStyle);
                    tg1.set_SymbolId(tg.get_SymbolId());
                    if (clipBounds != null) {
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, clipBounds);
                    } else if (clipPoints != null) {
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, clipPoints);
                    } else if (clipArea == null) {
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, clipBounds);
                    }
                    if (rangeFanFillShapes == null) break;
                    shapes.addAll(0, rangeFanFillShapes);
                    break;
                }
                default: {
                    clsRenderer2.getAutoshapeFillShape(tg, shapes);
                }
            }
            clsUtilityCPOF.LinesWithSeparateFill(tg.get_LineType(), shapes);
            clsClipPolygon2.addAbatisFill(tg, shapes);
            if (shapes != null && linesWithFillShapes != null && linesWithFillShapes.size() > 0) {
                shapes.addAll(0, linesWithFillShapes);
            }
            if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipBounds);
            } else if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipPoints != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipPoints);
            }
            clsRenderer.resolvePostClippedShapes(tg, shapes);
            if (modifierShapeInfos != null) {
                ArrayList<Shape2> textSpecs = new ArrayList<Shape2>();
                Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, textSpecs, (boolean)isTextFlipped, (IPointConversion)converter);
                clsRenderer.Shape2ToShapeInfo(modifierShapeInfos, textSpecs);
            }
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
            clsUtilityGE.buildHatchFills(tg, shapeInfos);
            if (clipBounds != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipBounds);
            } else if (clipPoints != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipPoints);
            } else if (clipArea == null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipBounds);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render_GE", (Exception)new RendererException("Failed inside render_GE", (Throwable)exc));
        }
    }

    public static void render_Shape(MilStdSymbol milStd, IPointConversion ipc, Object clipArea, int shapeType, Color lineColor, Color fillColor, int hatch) {
        try {
            Rectangle2D clipBounds = null;
            ArrayList clipPoints = null;
            if (clipArea != null) {
                if (clipArea.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                    clipBounds = (Rectangle2D.Double)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(Rectangle.class)) {
                    clipBounds = (Rectangle2D)clipArea;
                } else if (clipArea.getClass().isAssignableFrom(ArrayList.class)) {
                    clipPoints = (ArrayList)clipArea;
                }
            }
            TGLight tg = new TGLight();
            tg.set_SymbolId(milStd.getSymbolID());
            clsRenderer.setClientCoords(milStd, tg);
            tg.Pixels = clsUtility.LatLongToPixels(tg.LatLongs, ipc);
            Shape2 shape = new Shape2(shapeType);
            shape.setFillColor(fillColor);
            if (lineColor != null) {
                shape.setLineColor(lineColor);
                shape.setStroke((Stroke)new BasicStroke(milStd.getLineWidth()));
            }
            for (int j = 0; j < tg.Pixels.size(); ++j) {
                POINT2 pt = (POINT2)tg.Pixels.get(j);
                if (j == 0) {
                    shape.moveTo(pt);
                    continue;
                }
                shape.lineTo(pt);
            }
            ArrayList<Shape2> shapes = new ArrayList<Shape2>();
            shapes.add(shape);
            if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipBounds);
            } else if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipPoints != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipPoints);
            }
            shape = shapes.get(0);
            if (hatch > 1) {
                shape = clsUtilityGE.buildHatchFill(tg, (ShapeInfo)shape, hatch);
                shape.setLineColor(lineColor);
                shape.setStroke((Stroke)new BasicStroke(1.0f));
                shapes.add(shape);
            }
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
            if (clipBounds != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipBounds);
            } else if (clipPoints != null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipPoints);
            } else if (clipArea == null) {
                clsUtilityGE.SetShapeInfosPolylines(tg, shapeInfos, clipBounds);
            }
            if (milStd.getSymbolShapes() == null) {
                milStd.setSymbolShapes(shapeInfos);
            } else {
                milStd.getSymbolShapes().addAll(shapeInfos);
            }
            return;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render_Shape", (Exception)new RendererException("Failed inside render_Shape", (Throwable)exc));
            return;
        }
    }

    private static void resolvePostClippedShapes(TGLight tg, ArrayList<Shape2> shapes) {
        try {
            switch (tg.get_LineType()) {
                case 13000001: 
                case 13000002: 
                case 14000001: 
                case 14000002: 
                case 15000000: 
                case 15000001: 
                case 15000002: 
                case 15000003: {
                    break;
                }
                default: {
                    return;
                }
            }
            Color fillColor = tg.get_FillColor();
            shapes.get(0).setFillColor(fillColor);
            shapes.get(1).setFillColor(null);
            int fillStyle = tg.get_FillStyle();
            shapes.get(0).set_Fillstyle(0);
            shapes.get(1).set_Fillstyle(fillStyle);
            return;
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render_GE", (Exception)new RendererException("Failed inside resolvePostClippedShapes", (Throwable)exc));
            return;
        }
    }

    private static void setHostileLC(TGLight tg) {
        try {
            Boolean usas1314 = true;
            ArrayList pts = new ArrayList();
            int j = 0;
            switch (tg.get_LineType()) {
                case 22123000: {
                    if (!usas1314.booleanValue() || tg.get_Affiliation() != null && !tg.get_Affiliation().equals("H")) break;
                    pts = (ArrayList)tg.Pixels.clone();
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        tg.Pixels.set(j, (POINT2)pts.get(pts.size() - j - 1));
                    }
                    pts = (ArrayList)tg.LatLongs.clone();
                    for (j = 0; j < tg.LatLongs.size(); ++j) {
                        tg.LatLongs.set(j, (POINT2)pts.get(pts.size() - j - 1));
                    }
                    break;
                }
                case 23112000: {
                    pts = (ArrayList)tg.Pixels.clone();
                    for (j = 0; j < tg.Pixels.size(); ++j) {
                        tg.Pixels.set(j, (POINT2)pts.get(pts.size() - j - 1));
                    }
                    pts = (ArrayList)tg.LatLongs.clone();
                    for (j = 0; j < tg.LatLongs.size(); ++j) {
                        tg.LatLongs.set(j, (POINT2)pts.get(pts.size() - j - 1));
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"setHostileLC", (Exception)new RendererException("Failed inside setHostileLC", (Throwable)exc));
        }
    }

    protected static double getScale(TGLight tg, IPointConversion converter, Object clipBounds) {
        double scale = 0.0;
        try {
            if (clipBounds == null || converter == null) {
                return 0.0;
            }
            Rectangle2D clipRect = null;
            ArrayList clipArray = null;
            if (clipBounds.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                clipRect = (Rectangle2D)clipBounds;
            } else if (clipBounds.getClass().isAssignableFrom(Rectangle2D.class)) {
                clipRect = (Rectangle2D)clipBounds;
            } else if (clipBounds.getClass().isAssignableFrom(Rectangle.class)) {
                clipRect = (Rectangle2D)clipBounds;
            } else if (clipBounds.getClass().isAssignableFrom(ArrayList.class)) {
                clipArray = (ArrayList)clipBounds;
                clipRect = clsUtility.getMBR(clipArray);
            }
            double left = clipRect.getMinX();
            double right = clipRect.getMaxX();
            double distanceInPixels = Math.abs(right - left);
            double top = clipRect.getMinY();
            Point2D.Double ul = new Point2D.Double(left, top);
            Point2D.Double ur = new Point2D.Double(right, top);
            Point2D ulGeo = converter.PixelsToGeo((Point2D)ul);
            Point2D urGeo = converter.PixelsToGeo((Point2D)ur);
            POINT2 pt2ulGeo = new POINT2(ulGeo.getX(), ulGeo.getY());
            POINT2 pt2urGeo = new POINT2(urGeo.getX(), urGeo.getY());
            double distanceInMeters = mdlGeodesic.geodesic_distance((POINT2)pt2ulGeo, (POINT2)pt2urGeo, null, null);
            scale = distanceInPixels / distanceInMeters * 0.010416666666666666 * 0.025400050800101603;
            scale = 1.0 / scale;
            int lineType = tg.get_LineType();
            if (lineType == 23200000 && scale >= 250000.0 && tg.get_SymbolId().length() <= 15) {
                tg.set_LineType(23200001);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"getScale", (Exception)new RendererException("Failed inside getScale", (Throwable)exc));
        }
        return scale;
    }

    private static boolean setClip(Object clipBounds, Rectangle2D clipRect, ArrayList<Point2D> clipArray) {
        try {
            if (clipBounds == null) {
                return false;
            }
            if (clipBounds.getClass().isAssignableFrom(Rectangle2D.Double.class)) {
                clipRect.setRect((Rectangle2D)clipBounds);
            } else if (clipBounds.getClass().isAssignableFrom(Rectangle2D.class)) {
                clipRect.setRect((Rectangle2D)clipBounds);
            } else if (clipBounds.getClass().isAssignableFrom(Rectangle.class)) {
                clipRect.setRect((Rectangle2D)clipBounds);
            } else if (clipBounds.getClass().isAssignableFrom(ArrayList.class)) {
                clipArray.addAll((ArrayList)clipBounds);
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"setClip", (Exception)new RendererException("Failed inside setClip", (Throwable)exc));
        }
        return true;
    }

    public static void render(MilStdSymbol mss, IPointConversion converter, Object clipBounds) {
        try {
            ArrayList<ShapeInfo> shapeInfos = new ArrayList<ShapeInfo>();
            ArrayList<ShapeInfo> modifierShapeInfos = new ArrayList<ShapeInfo>();
            clsRenderer.render(mss, converter, shapeInfos, modifierShapeInfos, clipBounds);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render", (Exception)new RendererException("render", (Throwable)exc));
        }
    }

    public static void render(MilStdSymbol mss, IPointConversion converter, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos, Object clipBounds) {
        try {
            Rectangle2D.Double clipRect = new Rectangle2D.Double();
            ArrayList<Point2D> clipArray = new ArrayList<Point2D>();
            clsRenderer.setClip(clipBounds, clipRect, clipArray);
            int rev = mss.getSymbologyStandard();
            JavaTacticalRenderer.clsUtility.initializeLinetypes((int)rev);
            TGLight tg = clsRenderer.createTGLightFromMilStdSymbol(mss, converter);
            CELineArray.setClient((String)"generic");
            JavaTacticalRenderer.clsUtility.setRevC((TGLight)tg);
            double scale = clsRenderer.getScale(tg, converter, clipBounds);
            int linetype = tg.get_LineType();
            clsUtility.RemoveDuplicatePoints(tg);
            clsRenderer.setHostileLC(tg);
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            clsUtilityCPOF.SegmentGeoPoints(tg, converter, 1.0);
            clsUtility.FilterAXADPoints(tg, converter);
            JavaTacticalRenderer.clsUtility.FilterVerticalSegments((TGLight)tg);
            boolean isChange1Area = JavaTacticalRenderer.clsUtility.IsChange1Area((int)linetype, null);
            boolean isTextFlipped = false;
            ArrayList farLeftPixels = new ArrayList();
            ArrayList farRightPixels = new ArrayList();
            if (!isChange1Area) {
                clsUtilityCPOF.GetFarPixels(tg, converter, farLeftPixels, farRightPixels);
            }
            ArrayList<Object> shapesLeft = new ArrayList();
            ArrayList<Object> shapesRight = new ArrayList();
            ArrayList<Object> shapes = null;
            ArrayList textSpecsLeft = null;
            ArrayList textSpecsRight = null;
            textSpecsLeft = new ArrayList();
            textSpecsRight = new ArrayList();
            if (farLeftPixels.size() > 0) {
                tg.Pixels = farLeftPixels;
                shapesLeft = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, textSpecsLeft, (boolean)isTextFlipped, null);
            }
            if (farRightPixels.size() > 0) {
                tg.Pixels = farRightPixels;
                shapesRight = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, textSpecsRight, (boolean)isTextFlipped, null);
            }
            ArrayList<Shape2> textSpecs = new ArrayList<Shape2>();
            if (shapesLeft.isEmpty() || shapesRight.isEmpty()) {
                ArrayList<Shape2> linesWithFillShapes = null;
                linesWithFillShapes = clipArray != null && !clipArray.isEmpty() ? clsClipQuad.LinesWithFill(tg, clipArray) : (clipRect != null && ((RectangularShape)clipRect).getWidth() != 0.0 ? clsClipPolygon2.LinesWithFill(tg, clipRect) : clsClipPolygon2.LinesWithFill(tg, null));
                if (clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                    if (clipArray != null && !clipArray.isEmpty()) {
                        clsClipQuad.ClipPolygon(tg, clipArray);
                    } else if (clipRect != null && ((RectangularShape)clipRect).getWidth() != 0.0) {
                        clsClipPolygon2.ClipPolygon(tg, clipRect);
                    }
                    tg.LatLongs = clsUtility.PixelsToLatLong(tg.Pixels, converter);
                }
                JavaTacticalRenderer.clsUtility.InterpolatePixels((TGLight)tg);
                tg.modifiers = new ArrayList();
                Modifier2.AddModifiersGeo((TGLight)tg, (Graphics2D)g2d, (Object)clipBounds, (IPointConversion)converter);
                clsUtilityCPOF.FilterPoints2(tg, converter);
                clsUtilityCPOF.ClearPixelsStyle(tg);
                ArrayList<Shape2> rangeFanFillShapes = null;
                int savefillStyle = tg.get_FillStyle();
                if (linetype == 243111000) {
                    tg.set_Fillstyle(0);
                }
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                switch (linetype) {
                    case 243111000: 
                    case 243112000: {
                        TGLight tg1 = clsUtilityCPOF.GetCircularRangeFanFillTG(tg);
                        tg1.set_Fillstyle(savefillStyle);
                        rangeFanFillShapes = clsRenderer2.GetLineArray(tg1, converter, isTextFlipped, clipBounds);
                        if (rangeFanFillShapes == null) break;
                        shapes.addAll(0, rangeFanFillShapes);
                        break;
                    }
                }
                clsUtilityCPOF.LinesWithSeparateFill(tg.get_LineType(), shapes);
                clsClipPolygon2.addAbatisFill(tg, shapes);
                if (shapes != null && linesWithFillShapes != null && linesWithFillShapes.size() > 0) {
                    shapes.addAll(0, linesWithFillShapes);
                }
                if (shapes != null && shapes.size() > 0) {
                    Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, textSpecs, (boolean)isTextFlipped, null);
                    clsRenderer.Shape2ToShapeInfo(modifierShapeInfos, textSpecs);
                    mss.setModifierShapes(modifierShapeInfos);
                }
            } else {
                shapes = shapesLeft;
                shapes.addAll(shapesRight);
                if (textSpecs != null) {
                    textSpecs.addAll(textSpecsLeft);
                    textSpecs.addAll(textSpecsRight);
                }
            }
            if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipBounds);
            }
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
            mss.setSymbolShapes(shapeInfos);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render", (Exception)new RendererException("Failed inside render", (Throwable)exc));
        }
    }

    public static void render(TGLight tg, IPointConversion converter, ArrayList<ShapeInfo> shapeInfos, ArrayList<ShapeInfo> modifierShapeInfos, Rectangle2D clipBounds) {
        try {
            clsRenderer.setHostileLC(tg);
            boolean isChange1Area = JavaTacticalRenderer.clsUtility.IsChange1Area((int)tg.get_LineType(), null);
            boolean isTextFlipped = false;
            ArrayList farLeftPixels = new ArrayList();
            ArrayList farRightPixels = new ArrayList();
            if (!isChange1Area) {
                clsUtilityCPOF.GetFarPixels(tg, converter, farLeftPixels, farRightPixels);
            }
            BufferedImage bi = new BufferedImage(8, 8, 2);
            Graphics2D g2d = bi.createGraphics();
            ArrayList<Object> shapesLeft = new ArrayList();
            ArrayList<Object> shapesRight = new ArrayList();
            ArrayList<Object> shapes = null;
            ArrayList textSpecsLeft = null;
            ArrayList textSpecsRight = null;
            textSpecsLeft = new ArrayList();
            textSpecsRight = new ArrayList();
            if (farLeftPixels.size() > 0) {
                tg.Pixels = farLeftPixels;
                shapesLeft = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, textSpecsLeft, (boolean)isTextFlipped, null);
            }
            if (farRightPixels.size() > 0) {
                tg.Pixels = farRightPixels;
                shapesRight = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, textSpecsRight, (boolean)isTextFlipped, null);
            }
            ArrayList<Shape2> textSpecs = new ArrayList<Shape2>();
            if (shapesLeft.isEmpty() || shapesRight.isEmpty()) {
                ArrayList<Shape2> linesWithFillShapes = clsClipPolygon2.LinesWithFill(tg, clipBounds);
                if (clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                    clsClipPolygon2.ClipPolygon(tg, clipBounds);
                }
                shapes = clsRenderer2.GetLineArray(tg, converter, isTextFlipped, clipBounds);
                clsUtilityCPOF.LinesWithSeparateFill(tg.get_LineType(), shapes);
                clsClipPolygon2.addAbatisFill(tg, shapes);
                if (shapes != null && linesWithFillShapes != null && linesWithFillShapes.size() > 0) {
                    shapes.addAll(0, linesWithFillShapes);
                }
                if (shapes != null && shapes.size() > 0) {
                    Modifier2.DisplayModifiers2((TGLight)tg, (Graphics2D)g2d, textSpecs, (boolean)isTextFlipped, null);
                    clsRenderer.Shape2ToShapeInfo(modifierShapeInfos, textSpecs);
                }
            } else {
                shapes = shapesLeft;
                shapes.addAll(shapesRight);
                if (textSpecs != null) {
                    textSpecs.addAll(textSpecsLeft);
                    textSpecs.addAll(textSpecsRight);
                }
            }
            if (!clsUtilityCPOF.canClipPoints(tg).booleanValue() && clipBounds != null) {
                shapes = clsUtilityCPOF.postClipShapes(tg, shapes, clipBounds);
            }
            clsRenderer.Shape2ToShapeInfo(shapeInfos, shapes);
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"render", (Exception)new RendererException("Failed inside render", (Throwable)exc));
        }
    }

    private static int getCMLineType(String SymbolSet, String entityCode) {
        int symbolSet = Integer.parseInt(SymbolSet);
        if (symbolSet != 25) {
            return -1;
        }
        int nCode = Integer.parseInt(entityCode);
        switch (nCode) {
            case 200101: 
            case 200201: {
                return 25200101;
            }
            case 120100: {
                return 22621000;
            }
            case 120200: {
                return 22625000;
            }
            case 120300: {
                return 22626000;
            }
            case 120400: {
                return 221311000;
            }
            case 151401: {
                return 22521200;
            }
            case 151402: {
                return 22521300;
            }
            case 151403: {
                return 22521410;
            }
            case 151404: 
            case 151405: 
            case 151407: 
            case 151408: {
                return 22521420;
            }
            case 151406: {
                return 22320000;
            }
            case 110101: 
            case 110102: 
            case 110103: {
                return 22121000;
            }
            case 110200: {
                return 22125000;
            }
            case 120101: {
                return 22621000;
            }
            case 120102: {
                return 22625000;
            }
            case 120103: {
                return 22626000;
            }
            case 120104: {
                return 221311000;
            }
            case 140100: 
            case 140101: 
            case 140102: 
            case 140103: 
            case 140104: {
                return 22122000;
            }
            case 140200: {
                return 22123000;
            }
            case 140300: {
                return 22124000;
            }
            case 140400: 
            case 140401: {
                return 22124000;
            }
            case 140500: {
                return 22422000;
            }
            case 140601: {
                return 22522100;
            }
            case 140602: {
                return 22522210;
            }
            case 140603: 
            case 140604: 
            case 140606: 
            case 140607: {
                return 22522220;
            }
            case 140605: {
                return 22330000;
            }
            case 140700: {
                return 22523000;
            }
            case 140800: {
                return 22524000;
            }
            case 140900: {
                return 22525000;
            }
            case 141000: {
                return 22526000;
            }
            case 141100: {
                return 22527000;
            }
            case 141200: {
                return 22528000;
            }
            case 150101: 
            case 150102: 
            case 150103: 
            case 150104: 
            case 200401: {
                return 22536000;
            }
            case 150200: 
            case 150300: 
            case 150301: 
            case 150302: 
            case 150400: {
                return 22132000;
            }
            case 150501: 
            case 150502: 
            case 150503: {
                return 22131000;
            }
            case 150600: {
                return 22135000;
            }
            case 150700: {
                return 22136000;
            }
            case 150800: {
                return 22137000;
            }
            case 150900: {
                return 22138000;
            }
            case 151000: {
                return 22134000;
            }
            case 151100: {
                return 221310000;
            }
            case 151200: 
            case 151201: {
                return 22431000;
            }
            case 151202: {
                return 22431100;
            }
            case 151204: {
                return 21600000;
            }
            case 151205: {
                return 211900000;
            }
            case 151300: {
                return 22133000;
            }
            case 151203: {
                return 23350000;
            }
            case 151500: {
                return 22531000;
            }
            case 151600: {
                return 22532000;
            }
            case 151700: {
                return 22535000;
            }
            case 151801: 
            case 151802: {
                return 22624000;
            }
            case 151900: {
                return 22536000;
            }
            case 152000: {
                return 22533000;
            }
            case 152100: {
                return 22534000;
            }
            case 152200: {
                return 22139000;
            }
            case 141300: {
                return 22622000;
            }
            case 141400: {
                return 22623000;
            }
            case 141500: {
                return 22612000;
            }
            case 141600: {
                return 22613000;
            }
            case 141700: {
                return 22611000;
            }
            case 170100: 
            case 170101: {
                return 22221000;
            }
            case 170200: {
                return 22225000;
            }
            case 170300: {
                return 22222000;
            }
            case 170400: {
                return 22222000;
            }
            case 170500: {
                return 22223000;
            }
            case 170600: {
                return 22222000;
            }
            case 170700: {
                return 22224000;
            }
            case 170800: {
                return 22536000;
            }
            case 170900: {
                return 22233000;
            }
            case 171000: {
                return 22231000;
            }
            case 171100: 
            case 171200: 
            case 171300: 
            case 171400: 
            case 171500: {
                return 22231000;
            }
            case 171600: {
                return 22234000;
            }
            case 171700: {
                return 22234100;
            }
            case 171800: {
                return 22234200;
            }
            case 171900: {
                return 22232000;
            }
            case 172000: {
                return 22235000;
            }
            case 190100: 
            case 190200: {
                return 24210000;
            }
            case 200202: 
            case 200402: 
            case 240804: {
                return 24321200;
            }
            case 200300: {
                return 24321300;
            }
            case 220100: {
                return 26400000;
            }
            case 220101: {
                return 26410000;
            }
            case 220102: {
                return 26400000;
            }
            case 220103: 
            case 220104: {
                return 26420000;
            }
            case 220105: {
                return 26430000;
            }
            case 220106: {
                return 26440000;
            }
            case 218400: {
                return 26220000;
            }
            case 220107: 
            case 220108: {
                return 26400000;
            }
            case 230100: 
            case 230200: {
                return 22310000;
            }
            case 240101: {
                return 24322100;
            }
            case 240102: {
                return 24322200;
            }
            case 240103: {
                return 24322300;
            }
            case 240201: {
                return 24323100;
            }
            case 240202: {
                return 24323200;
            }
            case 240203: {
                return 24323300;
            }
            case 240301: {
                return 24324100;
            }
            case 240302: {
                return 24324200;
            }
            case 240303: {
                return 24324300;
            }
            case 240401: {
                return 24325100;
            }
            case 240402: {
                return 24325200;
            }
            case 240403: {
                return 24325300;
            }
            case 240501: {
                return 24326100;
            }
            case 240502: {
                return 24326200;
            }
            case 260100: {
                return 24210000;
            }
            case 260200: {
                return 24220000;
            }
            case 260300: {
                return 24230000;
            }
            case 260400: {
                return 24210000;
            }
            case 260500: {
                return 24240000;
            }
            case 260600: {
                return 24225000;
            }
            case 240701: {
                return 24250000;
            }
            case 240702: {
                return 24211000;
            }
            case 240703: {
                return 24260000;
            }
            case 240801: {
                return 24330000;
            }
            case 240802: {
                return 24311000;
            }
            case 240803: {
                return 24312000;
            }
            case 240805: {
                return 24313000;
            }
            case 240806: 
            case 240807: {
                return 24314000;
            }
            case 240808: {
                return 24315000;
            }
            case 241001: {
                return 24321100;
            }
            case 241002: {
                return 24321200;
            }
            case 241003: {
                return 24321300;
            }
            case 241101: {
                return 24331100;
            }
            case 241102: {
                return 24331200;
            }
            case 241103: {
                return 24331300;
            }
            case 241201: {
                return 24332100;
            }
            case 241202: {
                return 24332200;
            }
            case 241203: {
                return 24332300;
            }
            case 241301: {
                return 24334100;
            }
            case 241302: {
                return 24334200;
            }
            case 241303: {
                return 24334300;
            }
            case 241401: {
                return 24336100;
            }
            case 241402: {
                return 24336200;
            }
            case 241403: {
                return 24336300;
            }
            case 241501: {
                return 24335100;
            }
            case 241502: {
                return 24335200;
            }
            case 241503: {
                return 24335300;
            }
            case 241601: {
                return 24333100;
            }
            case 241602: {
                return 24333200;
            }
            case 241603: {
                return 24333300;
            }
            case 241701: {
                return 24338100;
            }
            case 241702: {
                return 24338200;
            }
            case 241703: {
                return 24338300;
            }
            case 241801: {
                return 24339100;
            }
            case 241802: {
                return 24339200;
            }
            case 241803: {
                return 24339300;
            }
            case 241901: {
                return 24337100;
            }
            case 241902: {
                return 24337200;
            }
            case 241903: {
                return 24337300;
            }
            case 242000: {
                return 24226000;
            }
            case 242100: {
                return 243111000;
            }
            case 242200: {
                return 243112000;
            }
            case 242301: {
                return 24351000;
            }
            case 242302: {
                return 24352000;
            }
            case 242303: {
                return 24353000;
            }
            case 242304: {
                return 24361000;
            }
            case 242305: {
                return 24362000;
            }
            case 242306: {
                return 24363000;
            }
            case 270100: {
                return 23111000;
            }
            case 270200: {
                return 23113000;
            }
            case 270300: {
                return 23114000;
            }
            case 270400: {
                return 23115000;
            }
            case 270501: {
                return 23171000;
            }
            case 270502: {
                return 23174000;
            }
            case 270503: {
                return 23172000;
            }
            case 270504: {
                return 23173000;
            }
            case 270601: {
                return 23211000;
            }
            case 270602: {
                return 23212000;
            }
            case 270603: {
                return 23213000;
            }
            case 271100: {
                return 23163000;
            }
            case 271201: {
                return 23191000;
            }
            case 271202: {
                return 23192000;
            }
            case 271203: {
                return 23193000;
            }
            case 271204: {
                return 23194000;
            }
            case 280100: {
                return 23120000;
            }
            case 290100: {
                return 23112000;
            }
            case 290201: {
                return 23131100;
            }
            case 290202: {
                return 23131200;
            }
            case 290203: {
                return 23132000;
            }
            case 290204: {
                return 23134000;
            }
            case 290301: {
                return 231111000;
            }
            case 290302: {
                return 231112000;
            }
            case 290303: {
                return 231113000;
            }
            case 290304: {
                return 231114000;
            }
            case 290305: {
                return 231115000;
            }
            case 290306: {
                return 231116000;
            }
            case 290307: {
                return 231117100;
            }
            case 290308: {
                return 231117200;
            }
            case 290309: {
                return 231117300;
            }
            case 290600: {
                return 23226000;
            }
            case 270706: {
                return 0x222248;
            }
            case 270707: {
                return 23162000;
            }
            case 270800: {
                return 23164000;
            }
            case 270900: {
                return 22340000;
            }
            case 270901: {
                return 22350000;
            }
            case 271000: {
                return 23180000;
            }
            case 290400: {
                return 23157000;
            }
            case 290500: {
                return 231100000;
            }
            case 282003: {
                return 23200000;
            }
            case 271300: {
                return 23221000;
            }
            case 271400: {
                return 23222000;
            }
            case 271500: {
                return 23224000;
            }
            case 271600: {
                return 23225000;
            }
            case 290700: {
                return 23223000;
            }
            case 290800: {
                return 23227000;
            }
            case 290900: {
                return 23330000;
            }
            case 291000: {
                return 23340000;
            }
            case 272100: {
                return 23410000;
            }
            case 272200: {
                return 23490000;
            }
            case 310100: {
                return 25310000;
            }
            case 310200: {
                return 25320000;
            }
            case 310300: {
                return 25330000;
            }
            case 310400: {
                return 25340000;
            }
            case 310500: {
                return 25353000;
            }
            case 310600: {
                return 25351000;
            }
            case 310700: {
                return 25352000;
            }
            case 330100: {
                return 25211000;
            }
            case 330200: {
                return 25212000;
            }
            case 330300: {
                return 25221000;
            }
            case 330301: {
                return 25223000;
            }
            case 330302: {
                return 25225000;
            }
            case 330303: {
                return 25224000;
            }
            case 330400: {
                return 25222000;
            }
            case 330401: {
                return 25223000;
            }
            case 330402: {
                return 25225000;
            }
            case 330403: {
                return 25224000;
            }
            case 340100: {
                return 21100000;
            }
            case 340200: {
                return 21200000;
            }
            case 340300: {
                return 21300000;
            }
            case 340400: {
                return 21400000;
            }
            case 340500: {
                return 21500000;
            }
            case 340600: {
                return 21700000;
            }
            case 340700: {
                return 21710000;
            }
            case 340800: {
                return 21800000;
            }
            case 341000: {
                return 211000000;
            }
            case 341100: {
                return 211100000;
            }
            case 341200: {
                return 211200000;
            }
            case 341300: {
                return 211210000;
            }
            case 341500: {
                return 211400000;
            }
            case 341700: {
                return 211600000;
            }
            case 341800: {
                return 211700000;
            }
            case 341900: {
                return 211800000;
            }
            case 342000: {
                return 212000000;
            }
            case 342100: {
                return 212100000;
            }
            case 342201: {
                return 212230000;
            }
            case 342202: {
                return 212220000;
            }
            case 342203: {
                return 212210000;
            }
            case 342300: {
                return 212300000;
            }
            case 342400: {
                return 212400000;
            }
            case 342500: {
                return 212410000;
            }
            case 300100: {
                return 24210000;
            }
        }
        return -1;
    }

    public static void setTGProperties(TGLight tg) {
        try {
            if (tg.get_SymbolId().length() < 20) {
                return;
            }
            String setA = tg.get_SymbolId().substring(0, 10);
            String setB = tg.get_SymbolId().substring(10);
            String symbolSet = setA.substring(4, 6);
            int nSymbolSet = Integer.parseInt(symbolSet);
            if (nSymbolSet != 25) {
                return;
            }
            String code = setB.substring(0, 6);
            int nCode = Integer.parseInt(code);
            switch (nCode) {
                case 140101: {
                    break;
                }
                case 140102: {
                    tg.set_LineStyle(1);
                    break;
                }
                case 140103: {
                    break;
                }
                case 140104: 
                case 140607: 
                case 150102: 
                case 150104: {
                    tg.set_LineStyle(1);
                    break;
                }
                case 140401: 
                case 140604: 
                case 150400: 
                case 151405: 
                case 220104: 
                case 240807: {
                    tg.set_LineStyle(1);
                    break;
                }
                case 140606: 
                case 150501: 
                case 150502: 
                case 150503: 
                case 151802: {
                    break;
                }
                case 151407: {
                    tg.set_Name("");
                    break;
                }
                case 151408: {
                    tg.set_Name("");
                    tg.set_LineStyle(1);
                    break;
                }
                case 200101: {
                    tg.set_FillColor(new Color(255, 155, 0, 191));
                    break;
                }
                case 200201: 
                case 200202: {
                    tg.set_FillColor(new Color(85, 119, 136, 191));
                    break;
                }
                case 270100: {
                    tg.set_T1("");
                    break;
                }
                case 290301: 
                case 290305: 
                case 290306: 
                case 290307: 
                case 290308: 
                case 290309: {
                    clsRenderer.reversePointsRevD(tg);
                    break;
                }
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException((String)_className, (String)"setTGProperties", (Exception)new RendererException("Failed inside setTGProperties", (Throwable)exc));
        }
    }
}

