/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.RectUtilities;
import armyc2.c5isr.renderer.utilities.SymbolDimensionInfo;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.StringReader;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageOutputStream;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;

public class ImageInfo
implements SymbolDimensionInfo {
    public static final String FormatPNG = "png";
    public static final String FormatJPG = "jpg";
    private BufferedImage _Image = null;
    private int _X = 0;
    private int _Y = 0;
    private int _symbolCenterX = 0;
    private int _symbolCenterY = 0;
    Rectangle2D _symbolBounds = null;

    protected ImageInfo() {
    }

    public ImageInfo(BufferedImage image, int x, int y) {
        this._Image = image;
        this._X = x;
        this._Y = y;
        this._symbolCenterX = image.getWidth() / 2;
        this._symbolCenterY = image.getHeight() / 2;
    }

    public ImageInfo(BufferedImage bi, Point2D centerPoint, Rectangle2D symbolBounds) {
        this._Image = bi;
        this._symbolCenterX = (int)centerPoint.getX();
        this._symbolCenterY = (int)centerPoint.getY();
        this._symbolBounds = symbolBounds;
    }

    public ImageInfo(BufferedImage image, int x, int y, int symbolCenterX, int symbolCenterY) {
        this._Image = image;
        this._X = x;
        this._Y = y;
        this._symbolCenterX = symbolCenterX;
        this._symbolCenterY = symbolCenterY;
    }

    public ImageInfo(BufferedImage image, int x, int y, int symbolCenterX, int symbolCenterY, Rectangle2D symbolBounds) {
        this._Image = image;
        this._X = x;
        this._Y = y;
        this._symbolCenterX = symbolCenterX;
        this._symbolCenterY = symbolCenterY;
        this._symbolBounds = symbolBounds;
    }

    public BufferedImage getImage() {
        return this._Image;
    }

    public int getX() {
        return this._X;
    }

    public int getY() {
        return this._Y;
    }

    public Point getPoint() {
        return new Point(this._X, this._Y);
    }

    @Override
    public int getSymbolCenterX() {
        return this._symbolCenterX;
    }

    @Override
    public int getSymbolCenterY() {
        return this._symbolCenterY;
    }

    @Override
    public Point getSymbolCenterPoint() {
        return new Point(this._symbolCenterX, this._symbolCenterY);
    }

    @Override
    public Rectangle2D getSymbolBounds() {
        return new Rectangle2D.Double(this._symbolBounds.getX(), this._symbolBounds.getY(), this._symbolBounds.getWidth(), this._symbolBounds.getHeight());
    }

    @Override
    public Rectangle2D getImageBounds() {
        return new Rectangle(0, 0, this._Image.getWidth(), this._Image.getHeight());
    }

    public Boolean SaveImageToFile(String filePath, String imageFormat) {
        try {
            File outFile = new File(filePath);
            return ImageIO.write((RenderedImage)this._Image, imageFormat, outFile);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("ImageInfo", "SaveImageToFile", exc);
            return false;
        }
    }

    public Boolean SaveImageToPNG(ImageOutputStream ios) {
        try {
            BufferedImage image = this._Image;
            Iterator<ImageWriter> itr = ImageIO.getImageWritersBySuffix(FormatPNG);
            String metaDataFormatName = "";
            if (itr.hasNext()) {
                ImageWriter iw = itr.next();
                IIOMetadata meta = iw.getDefaultImageMetadata(new ImageTypeSpecifier(image), null);
                metaDataFormatName = meta.getMetadataFormatNames()[0];
                StringBuilder XML = new StringBuilder("");
                XML.append("<" + metaDataFormatName + ">");
                XML.append("<tEXt>");
                XML.append("<tEXtEntry keyword=\"centerPoint\" value=\"x=" + String.valueOf(this._symbolCenterX) + ",y=" + String.valueOf(this._symbolCenterY) + "\"/>");
                XML.append("<tEXtEntry keyword=\"bounds\" value=\"x=" + String.valueOf(this._symbolBounds.getX()) + ",y=" + String.valueOf(this._symbolBounds.getY()) + ",width=" + String.valueOf(this._symbolBounds.getWidth()) + ",height=" + String.valueOf(this._symbolBounds.getHeight()) + "\"/>");
                XML.append("<tEXtEntry keyword=\"imageExtent\" value=\"width=" + String.valueOf(this._Image.getWidth()) + ",height=" + String.valueOf(this._Image.getHeight()) + "\"/>");
                XML.append("</tEXt>");
                XML.append("</" + metaDataFormatName + ">");
                DOMResult domresult = new DOMResult();
                TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(XML.toString())), domresult);
                Node document = domresult.getNode();
                meta.mergeTree(metaDataFormatName, document.getFirstChild());
                IIOImage iioImage = new IIOImage(image, null, null);
                iioImage.setMetadata(meta);
                iw.setOutput(ios);
                iw.write(null, iioImage, null);
                ios.close();
                iw.dispose();
                iw = null;
                itr = null;
                iioImage = null;
                return true;
            }
            ErrorLogger.LogMessage("ImageInfo", "SaveImageToPNG", "no PNG imageWriter available");
            return false;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("ImageInfo", "SaveImageToFile", exc);
            return false;
        }
    }

    public byte[] getImageAsByteArray() {
        byte[] byteArray = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            BufferedImage image = this._Image;
            ImageIO.write((RenderedImage)image, FormatPNG, baos);
            baos.flush();
            byteArray = baos.toByteArray();
            baos.close();
        }
        catch (Exception exc) {
            ErrorLogger.LogException("PNGInfo", "getImageAsByteArray", exc);
        }
        return byteArray;
    }

    public byte[] getImageAsByteArrayWithMetaInfo() {
        byte[] metaImage = null;
        try {
            BufferedImage image = this._Image;
            Iterator<ImageWriter> itr = ImageIO.getImageWritersBySuffix(FormatPNG);
            String metaDataFormatName = "";
            if (itr.hasNext()) {
                ImageWriter iw = itr.next();
                IIOMetadata meta = iw.getDefaultImageMetadata(new ImageTypeSpecifier(image), null);
                metaDataFormatName = meta.getMetadataFormatNames()[0];
                StringBuilder XML = new StringBuilder("");
                XML.append("<" + metaDataFormatName + ">");
                XML.append("<tEXt>");
                XML.append("<tEXtEntry keyword=\"centerPoint\" value=\"x=" + String.valueOf(this._symbolCenterX) + ",y=" + String.valueOf(this._symbolCenterY) + "\"/>");
                XML.append("<tEXtEntry keyword=\"bounds\" value=\"x=" + String.valueOf(this._symbolBounds.getX()) + ",y=" + String.valueOf(this._symbolBounds.getY()) + ",width=" + String.valueOf(this._symbolBounds.getWidth()) + ",height=" + String.valueOf(this._symbolBounds.getHeight()) + "\"/>");
                XML.append("<tEXtEntry keyword=\"imageExtent\" value=\"width=" + String.valueOf(image.getWidth()) + ",height=" + String.valueOf(image.getHeight()) + "\"/>");
                XML.append("</tEXt>");
                XML.append("</" + metaDataFormatName + ">");
                DOMResult domresult = new DOMResult();
                TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(XML.toString())), domresult);
                Node document = domresult.getNode();
                meta.mergeTree(metaDataFormatName, document.getFirstChild());
                IIOImage iioImage = new IIOImage(image, null, null);
                iioImage.setMetadata(meta);
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ImageOutputStream ios = ImageIO.createImageOutputStream(bytes);
                iw.setOutput(ios);
                iw.write(null, iioImage, null);
                ios.close();
                iw.dispose();
                iw = null;
                itr = null;
                iioImage = null;
                bytes.flush();
                metaImage = bytes.toByteArray();
                bytes.close();
                return metaImage;
            }
            ErrorLogger.LogMessage("ImageInfo", "getImageAsByteArrayWithMetaInfo", "no PNG imageWriter available");
            return null;
        }
        catch (Exception exc) {
            ErrorLogger.LogException("ImageInfo", "getImageAsByteArrayWithMetaInfo", exc);
            return null;
        }
    }

    public static BufferedImage CenterImageOnPoint(BufferedImage image, Point2D point) {
        BufferedImage bi = null;
        int x = 0;
        int y = 0;
        int height = 0;
        int width = 0;
        height = image.getHeight();
        width = image.getWidth();
        try {
            if (point.getY() > (double)height - point.getY()) {
                height = (int)(point.getY() * 2.0);
                y = 0;
            } else {
                height = (int)(((double)height - point.getY()) * 2.0);
                y = (int)((double)(height / 2) - point.getY());
            }
            if (point.getX() > (double)width - point.getX()) {
                width = (int)(point.getX() * 2.0);
                x = 0;
            } else {
                width = (int)(((double)width - point.getX()) * 2.0);
                x = (int)((double)(width / 2) - point.getX());
            }
            bi = new BufferedImage(width, height, 2);
            Graphics2D g2d = bi.createGraphics();
            g2d.drawImage((Image)image, x, y, null);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("ImageInfo", "CenterImageOnPoint", exc);
        }
        return bi;
    }

    public static Boolean CanWriteImageFormat(String format) {
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(format);
        return iter.hasNext();
    }

    public static BufferedImage getScaledInstance(BufferedImage srcImage, int targetWidth, int targetHeight, Object hint, boolean higherQuality, boolean keepProportion) {
        int h;
        int w;
        int type = srcImage.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = srcImage;
        double ratio = 0.0;
        double SrcW = srcImage.getWidth();
        double SrcH = srcImage.getHeight();
        double tW = targetWidth;
        double tH = targetHeight;
        if (keepProportion) {
            ratio = Math.min(tH / SrcH, tW / SrcW);
            targetWidth = (int)(SrcW * ratio);
            targetHeight = (int)(SrcH * ratio);
        }
        if (higherQuality) {
            w = srcImage.getWidth();
            h = srcImage.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }

    public ImageInfo getSquareImageInfo() {
        int y;
        int x;
        int iheight;
        int iwidth;
        int height;
        ImageInfo ii = null;
        int width = this._Image.getWidth();
        if (width > (height = this._Image.getHeight())) {
            iwidth = width;
            iheight = width;
            x = 0;
            y = (iheight - height) / 2;
        } else if (width < height) {
            iwidth = height;
            iheight = height;
            x = (iwidth - width) / 2;
            y = 0;
        } else {
            iwidth = width;
            iheight = height;
            x = 0;
            y = 0;
        }
        BufferedImage bmp = new BufferedImage(iwidth, iheight, 2);
        Graphics2D g2d = bmp.createGraphics();
        g2d.drawImage((Image)this._Image, x, y, null);
        Point center = new Point(this._symbolCenterX, this._symbolCenterY);
        center.translate(x, y);
        Rectangle2D symbolBounds = RectUtilities.copyRect(this._symbolBounds);
        RectUtilities.shift(this._symbolBounds, x, y);
        ii = new ImageInfo(bmp, center, symbolBounds);
        return ii;
    }
}

