/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.AffiliationColors;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.SettingsChangedEvent;
import armyc2.c5isr.renderer.utilities.SettingsEventListener;
import java.awt.Color;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;

public class RendererSettings {
    private static RendererSettings _instance = null;
    private static int _TextBackgroundMethod = 3;
    public static final int TextBackgroundMethod_NONE = 0;
    public static final int TextBackgroundMethod_COLORFILL = 1;
    public static final int TextBackgroundMethod_OUTLINE = 2;
    public static final int TextBackgroundMethod_OUTLINE_QUICK = 3;
    private static int _TextBackgroundAutoColorThreshold = 160;
    private static int _TextOutlineWidth = 1;
    private static Color _ColorLabelForeground = null;
    private static Color _ColorLabelBackground = new Color(255, 255, 255, 255);
    private static int _PixelSize = 50;
    private static boolean _AutoCollapseModifiers = true;
    private static int _SymbolOutlineWidth = 1;
    private static boolean _OutlineSPControlMeasures = true;
    private static Boolean _CenterOnHQStaff = true;
    public static int OperationalConditionModifierType_SLASH = 0;
    public static int OperationalConditionModifierType_BAR = 1;
    private static int _OCMType = 1;
    public static final int SeaMineRenderMethod_MEDAL = 1;
    public static final int SeaMineRenderMethod_ALT = 2;
    public static int _SeaMineRenderMethod = 1;
    private static boolean _UseLineInterpolation = true;
    private static String _ModifierFontName = "arial";
    private static int _ModifierFontType = 1;
    private static int _ModifierFontSize = 12;
    private static int _ModifierFontKerning = 0;
    private static float _ModifierFontTracking = 0.0f;
    private boolean _scaleEchelon = false;
    private boolean _DrawAffiliationModifierAsLabel = false;
    private static String _MPLabelFontName = "arial";
    private static int _MPLabelFontType = 1;
    private static int _MPLabelFontSize = 12;
    private static float _KMLLabelScale = 1.0f;
    private static int _DPI = 96;
    private static int _CacheSize = 1024;
    private static int _VMSize = 10240;
    private static boolean _CacheEnabled = true;
    private boolean _TwoLabelOnly = false;
    private Color _friendlyUnitFillColor = AffiliationColors.FriendlyUnitFillColor;
    private Color _hostileUnitFillColor = AffiliationColors.HostileUnitFillColor;
    private Color _neutralUnitFillColor = AffiliationColors.NeutralUnitFillColor;
    private Color _unknownUnitFillColor = AffiliationColors.UnknownUnitFillColor;
    private Color _friendlyGraphicFillColor = AffiliationColors.FriendlyGraphicFillColor;
    private Color _hostileGraphicFillColor = AffiliationColors.HostileGraphicFillColor;
    private Color _neutralGraphicFillColor = AffiliationColors.NeutralGraphicFillColor;
    private Color _unknownGraphicFillColor = AffiliationColors.UnknownGraphicFillColor;
    private Color _friendlyUnitLineColor = AffiliationColors.FriendlyUnitLineColor;
    private Color _hostileUnitLineColor = AffiliationColors.HostileUnitLineColor;
    private Color _neutralUnitLineColor = AffiliationColors.NeutralUnitLineColor;
    private Color _unknownUnitLineColor = AffiliationColors.UnknownUnitLineColor;
    private Color _friendlyGraphicLineColor = AffiliationColors.FriendlyGraphicLineColor;
    private Color _hostileGraphicLineColor = AffiliationColors.HostileGraphicLineColor;
    private Color _neutralGraphicLineColor = AffiliationColors.NeutralGraphicLineColor;
    private Color _unknownGraphicLineColor = AffiliationColors.UnknownGraphicLineColor;
    private ArrayList<SettingsEventListener> _Listeners = new ArrayList();

    private RendererSettings() {
        this.Init();
    }

    public static synchronized RendererSettings getInstance() {
        if (_instance == null) {
            _instance = new RendererSettings();
        }
        return _instance;
    }

    private void Init() {
        try {
            _VMSize = (int)Runtime.getRuntime().maxMemory();
            _CacheSize = Math.round((float)_VMSize * 0.03f);
        }
        catch (Exception exc) {
            ErrorLogger.LogException("RendererSettings", "Init", exc, Level.WARNING);
        }
    }

    public void addEventListener(SettingsEventListener sel) {
        this._Listeners.add(sel);
    }

    private void raiseEvents(String event) {
        for (SettingsEventListener l : this._Listeners) {
            l.SettingsEventChanged(event);
        }
    }

    public synchronized void setTextBackgroundMethod(int textBackgroundMethod) {
        _TextBackgroundMethod = textBackgroundMethod;
        if (_TextBackgroundMethod == 2) {
            _TextOutlineWidth = 4;
        } else if (_TextBackgroundMethod == 3) {
            _TextOutlineWidth = 1;
        }
    }

    public synchronized int getTextBackgroundMethod() {
        return _TextBackgroundMethod;
    }

    public void setDefaultPixelSize(int size) {
        _PixelSize = size;
    }

    public int getDefaultPixelSize() {
        return _PixelSize;
    }

    public void setOperationalConditionModifierType(int value) {
        _OCMType = value;
    }

    public int getOperationalConditionModifierType() {
        return _OCMType;
    }

    public void setSeaMineRenderMethod(int method) {
        _SeaMineRenderMethod = method;
    }

    public int getSeaMineRenderMethod() {
        return _SeaMineRenderMethod;
    }

    public void setUseLineInterpolation(boolean value) {
        _UseLineInterpolation = value;
    }

    public boolean getUseLineInterpolation() {
        return _UseLineInterpolation;
    }

    public void setDeviceDPI(int value) {
        _DPI = value;
    }

    public int getDeviceDPI() {
        return _DPI;
    }

    public void setAutoCollapseModifiers(boolean value) {
        _AutoCollapseModifiers = value;
    }

    public boolean getAutoCollapseModifiers() {
        return _AutoCollapseModifiers;
    }

    public void setCenterOnHQStaff(Boolean value) {
        _CenterOnHQStaff = value;
    }

    public Boolean getCenterOnHQStaff() {
        return _CenterOnHQStaff;
    }

    public synchronized int getTextOutlineWidth() {
        return _TextOutlineWidth;
    }

    public void setTextBackgroundAutoColorThreshold(int value) {
        _TextBackgroundAutoColorThreshold = value;
    }

    public int getTextBackgroundAutoColorThreshold() {
        return _TextBackgroundAutoColorThreshold;
    }

    public synchronized void setSinglePointSymbolOutlineWidth(int width) {
        _SymbolOutlineWidth = width;
    }

    public synchronized int getSinglePointSymbolOutlineWidth() {
        return _SymbolOutlineWidth;
    }

    public void setOutlineSPControlMeasures(boolean value) {
        _OutlineSPControlMeasures = value;
    }

    public boolean getOutlineSPControlMeasures() {
        return _OutlineSPControlMeasures;
    }

    public void setScaleEchelon(boolean value) {
        this._scaleEchelon = value;
    }

    public boolean getScaleEchelon() {
        return this._scaleEchelon;
    }

    public void setDrawAffiliationModifierAsLabel(boolean value) {
        this._DrawAffiliationModifierAsLabel = value;
    }

    public boolean getDrawAffiliationModifierAsLabel() {
        return this._DrawAffiliationModifierAsLabel;
    }

    public void setLabelFont(String name, int type, int size) {
        _ModifierFontName = name;
        _ModifierFontType = type;
        _ModifierFontSize = size;
        _ModifierFontKerning = 0;
        _ModifierFontTracking = TextAttribute.TRACKING_LOOSE.floatValue();
        SettingsChangedEvent sce = new SettingsChangedEvent("FONT_CHANGED");
        this.raiseEvents("FONT_CHANGED");
    }

    public void setMPLabelFont(String name, int type, int size) {
        _MPLabelFontName = name;
        _MPLabelFontType = type;
        _MPLabelFontSize = size;
        _KMLLabelScale = 1.0f;
        SettingsChangedEvent sce = new SettingsChangedEvent("FONT_CHANGED");
        this.raiseEvents("FONT_CHANGED");
    }

    public void setMPLabelFont(String name, int type, int size, float kmlScale) {
        _MPLabelFontName = name;
        _MPLabelFontType = type;
        _MPLabelFontSize = Math.round((float)size * kmlScale);
        _KMLLabelScale = kmlScale;
        SettingsChangedEvent sce = new SettingsChangedEvent("FONT_CHANGED");
        this.raiseEvents("FONT_CHANGED");
    }

    public String getMPLabelFontName() {
        return _MPLabelFontName;
    }

    public int getMPLabelFontType() {
        return _MPLabelFontType;
    }

    public int getMPLabelFontSize() {
        return _MPLabelFontSize;
    }

    public void setLabelFont(String name, int type, int size, Boolean kerning, float tracking) {
        _ModifierFontName = name;
        _ModifierFontType = type;
        _ModifierFontSize = size;
        _ModifierFontKerning = kerning == false ? 0 : TextAttribute.KERNING_ON;
        _ModifierFontTracking = tracking;
    }

    public String getLabelFontName() {
        return _ModifierFontName;
    }

    public int getLabelFontType() {
        return _ModifierFontType;
    }

    public int getLabelFontSize() {
        return _ModifierFontSize;
    }

    public int getLabelFontKerning() {
        return _ModifierFontKerning;
    }

    public float getLabelFontTracking() {
        return _ModifierFontTracking;
    }

    public Font getLabelFont() {
        try {
            HashMap<TextAttribute, Number> map = new HashMap<TextAttribute, Number>();
            map.put(TextAttribute.KERNING, _ModifierFontKerning);
            map.put(TextAttribute.TRACKING, Float.valueOf(_ModifierFontTracking));
            Font temp = new Font(_ModifierFontName, _ModifierFontType, _ModifierFontSize);
            return temp.deriveFont(map);
        }
        catch (Exception exc) {
            String message = "font creation error, returning \"" + _ModifierFontName + "\" font, " + _ModifierFontSize + "pt. Check font name and type.";
            ErrorLogger.LogMessage("RendererSettings", "getLabelFont", message);
            ErrorLogger.LogMessage("RendererSettings", "getLabelFont", exc.getMessage());
            return new Font("arial", 1, 12);
        }
    }

    public Font getMPLabelFont() {
        try {
            HashMap map = new HashMap();
            Font temp = new Font(_MPLabelFontName, _MPLabelFontType, _MPLabelFontSize);
            return temp;
        }
        catch (Exception exc) {
            String message = "font creation error, returning \"" + _MPLabelFontName + "\" font, " + _MPLabelFontSize + "pt. Check font name and type.";
            ErrorLogger.LogMessage("RendererSettings", "getMPLabelFont", message);
            ErrorLogger.LogMessage("RendererSettings", "getMPLabelFont", exc.getMessage());
            return new Font("arial", 1, 12);
        }
    }

    public float getKMLLabelScale() {
        return _KMLLabelScale;
    }

    private void setCacheSize(int bytes) {
        if (bytes > _VMSize / 10) {
            bytes = _VMSize / 10;
        }
        _CacheSize = bytes;
        SettingsChangedEvent sce = new SettingsChangedEvent("CACHE_CHANGED");
        this.raiseEvents("CACHE_CHANGED");
    }

    private int getCacheSize() {
        return _CacheSize;
    }

    public void setCacheEnabled(boolean active) {
        if (_CacheEnabled != active) {
            _CacheEnabled = active;
            this.raiseEvents("CACHE_TOGGLED");
        }
    }

    public boolean getCacheEnabled() {
        return _CacheEnabled;
    }

    public boolean getTwoLabelOnly() {
        return this._TwoLabelOnly;
    }

    public void setTwoLabelOnly(boolean TwoLabelOnly) {
        this._TwoLabelOnly = TwoLabelOnly;
    }

    public Color getFriendlyUnitFillColor() {
        return this._friendlyUnitFillColor;
    }

    public void setFriendlyUnitFillColor(Color friendlyUnitFillColor) {
        if (friendlyUnitFillColor != null) {
            this._friendlyUnitFillColor = friendlyUnitFillColor;
        }
    }

    public Color getHostileUnitFillColor() {
        return this._hostileUnitFillColor;
    }

    public void setHostileUnitFillColor(Color hostileUnitFillColor) {
        if (hostileUnitFillColor != null) {
            this._hostileUnitFillColor = hostileUnitFillColor;
        }
    }

    public Color getNeutralUnitFillColor() {
        return this._neutralUnitFillColor;
    }

    public void setNeutralUnitFillColor(Color neutralUnitFillColor) {
        if (neutralUnitFillColor != null) {
            this._neutralUnitFillColor = neutralUnitFillColor;
        }
    }

    public Color getUnknownUnitFillColor() {
        return this._unknownUnitFillColor;
    }

    public void setUnknownUnitFillColor(Color unknownUnitFillColor) {
        if (unknownUnitFillColor != null) {
            this._unknownUnitFillColor = unknownUnitFillColor;
        }
    }

    public Color getHostileGraphicFillColor() {
        return this._hostileGraphicFillColor;
    }

    public void setHostileGraphicFillColor(Color hostileGraphicFillColor) {
        if (hostileGraphicFillColor != null) {
            this._hostileGraphicFillColor = hostileGraphicFillColor;
        }
    }

    public Color getFriendlyGraphicFillColor() {
        return this._friendlyGraphicFillColor;
    }

    public void setFriendlyGraphicFillColor(Color friendlyGraphicFillColor) {
        if (friendlyGraphicFillColor != null) {
            this._friendlyGraphicFillColor = friendlyGraphicFillColor;
        }
    }

    public Color getNeutralGraphicFillColor() {
        return this._neutralGraphicFillColor;
    }

    public void setNeutralGraphicFillColor(Color neutralGraphicFillColor) {
        if (neutralGraphicFillColor != null) {
            this._neutralGraphicFillColor = neutralGraphicFillColor;
        }
    }

    public Color getUnknownGraphicFillColor() {
        return this._unknownGraphicFillColor;
    }

    public void setUnknownGraphicFillColor(Color unknownGraphicFillColor) {
        if (unknownGraphicFillColor != null) {
            this._unknownGraphicFillColor = unknownGraphicFillColor;
        }
    }

    public Color getFriendlyUnitLineColor() {
        return this._friendlyUnitLineColor;
    }

    public void setFriendlyUnitLineColor(Color friendlyUnitLineColor) {
        if (friendlyUnitLineColor != null) {
            this._friendlyUnitLineColor = friendlyUnitLineColor;
        }
    }

    public Color getHostileUnitLineColor() {
        return this._hostileUnitLineColor;
    }

    public void setHostileUnitLineColor(Color hostileUnitLineColor) {
        if (hostileUnitLineColor != null) {
            this._hostileUnitLineColor = hostileUnitLineColor;
        }
    }

    public Color getNeutralUnitLineColor() {
        return this._neutralUnitLineColor;
    }

    public void setNeutralUnitLineColor(Color neutralUnitLineColor) {
        if (neutralUnitLineColor != null) {
            this._neutralUnitLineColor = neutralUnitLineColor;
        }
    }

    public Color getUnknownUnitLineColor() {
        return this._unknownUnitLineColor;
    }

    public void setUnknownUnitLineColor(Color unknownUnitLineColor) {
        if (unknownUnitLineColor != null) {
            this._unknownUnitLineColor = unknownUnitLineColor;
        }
    }

    public Color getFriendlyGraphicLineColor() {
        return this._friendlyGraphicLineColor;
    }

    public void setFriendlyGraphicLineColor(Color friendlyGraphicLineColor) {
        if (friendlyGraphicLineColor != null) {
            this._friendlyGraphicLineColor = friendlyGraphicLineColor;
        }
    }

    public Color getHostileGraphicLineColor() {
        return this._hostileGraphicLineColor;
    }

    public void setHostileGraphicLineColor(Color hostileGraphicLineColor) {
        if (hostileGraphicLineColor != null) {
            this._hostileGraphicLineColor = hostileGraphicLineColor;
        }
    }

    public Color getNeutralGraphicLineColor() {
        return this._neutralGraphicLineColor;
    }

    public void setNeutralGraphicLineColor(Color neutralGraphicLineColor) {
        if (neutralGraphicLineColor != null) {
            this._neutralGraphicLineColor = neutralGraphicLineColor;
        }
    }

    public Color getUnknownGraphicLineColor() {
        return this._unknownGraphicLineColor;
    }

    public void setUnknownGraphicLineColor(Color unknownGraphicLineColor) {
        if (unknownGraphicLineColor != null) {
            this._unknownGraphicLineColor = unknownGraphicLineColor;
        }
    }

    public void setGraphicPreferredAffiliationColors(Color friendlyGraphicLineColor, Color hostileGraphicLineColor, Color neutralGraphicLineColor, Color unknownGraphicLineColor, Color friendlyGraphicFillColor, Color hostileGraphicFillColor, Color neutralGraphicFillColor, Color unknownGraphicFillColor) {
        this.setFriendlyGraphicLineColor(friendlyGraphicLineColor);
        this.setHostileGraphicLineColor(hostileGraphicLineColor);
        this.setNeutralGraphicLineColor(neutralGraphicLineColor);
        this.setUnknownGraphicLineColor(unknownGraphicLineColor);
        this.setFriendlyGraphicFillColor(friendlyGraphicFillColor);
        this.setHostileGraphicFillColor(hostileGraphicFillColor);
        this.setNeutralGraphicFillColor(neutralGraphicFillColor);
        this.setUnknownGraphicFillColor(unknownGraphicFillColor);
    }

    public void setUnitPreferredAffiliationColors(Color friendlyUnitLineColor, Color hostileUnitLineColor, Color neutralUnitLineColor, Color unknownUnitLineColor, Color friendlyUnitFillColor, Color hostileUnitFillColor, Color neutralUnitFillColor, Color unknownUnitFillColor) {
        this.setFriendlyUnitLineColor(friendlyUnitLineColor);
        this.setHostileUnitLineColor(hostileUnitLineColor);
        this.setNeutralUnitLineColor(neutralUnitLineColor);
        this.setUnknownUnitLineColor(unknownUnitLineColor);
        this.setFriendlyUnitFillColor(friendlyUnitFillColor);
        this.setHostileUnitFillColor(hostileUnitFillColor);
        this.setNeutralUnitFillColor(neutralUnitFillColor);
        this.setUnknownUnitFillColor(unknownUnitFillColor);
    }
}

