/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.web.render.GeoPixelConversion;

public class GeoPixelConversion3D {
    public static double metersPerPixel(double scale) {
        return GeoPixelConversion.metersPerPixel(scale);
    }

    public static double lat2y(double latitude, double scale, double latOrigin, double metPerPix) {
        double latRem = Math.abs(latitude - latOrigin);
        double pixDis = 0.0;
        if (latRem > 0.0) {
            pixDis = latRem * 111319.49166666667 / metPerPix;
            if (latitude > latOrigin) {
                pixDis = -pixDis;
            }
        }
        return pixDis;
    }

    public static double y2lat(double yPosition, double scale, double latOrigin, double metPerPix) {
        double latitude = latOrigin;
        if (yPosition != 0.0) {
            latitude = latOrigin - yPosition * metPerPix / 111319.49166666667;
        }
        return latitude;
    }

    public static double long2x(double longitude, double scale, double longOrigin, double latitude, double metPerPix) {
        double longRem = Math.abs(longitude - longOrigin);
        double metersPerDeg = GeoPixelConversion3D.GetMetersPerDegAtLat(latitude);
        double pixDis = 0.0;
        if (longRem > 0.0) {
            pixDis = longRem * metersPerDeg / metPerPix;
            if (longitude < longOrigin) {
                pixDis = -pixDis;
            }
        }
        return pixDis;
    }

    public static double x2long(double xPosition, double scale, double longOrigin, double latitude, double metPerPix) {
        double metersPerDeg = GeoPixelConversion3D.GetMetersPerDegAtLat(latitude);
        double longitude = longOrigin;
        if (xPosition != 0.0) {
            longitude = longOrigin + xPosition * metPerPix / metersPerDeg;
        }
        return longitude;
    }

    public static double Deg2Rad(double deg) {
        double conv_factor = Math.PI / 180;
        return deg * conv_factor;
    }

    public static double GetMetersPerDegAtLat(double lat) {
        lat = GeoPixelConversion3D.Deg2Rad(lat);
        double p1 = 111412.84;
        double p2 = -93.5;
        double p3 = 0.118;
        double longlen = p1 * Math.cos(lat) + p2 * Math.cos(3.0 * lat) + p3 * Math.cos(5.0 * lat);
        return longlen;
    }
}

