/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.util.ArrayList;

public class MilStdAttributes {
    public static final String LineColor = "LINECOLOR";
    public static final String FillColor = "FILLCOLOR";
    public static final String IconColor = "ICONCOLOR";
    public static final String PixelSize = "PIXELSIZE";
    public static final String KeepUnitRatio = "KEEPUNITRATIO";
    public static final String Alpha = "ALPHA";
    public static final String OutlineSymbol = "OUTLINESYMBOL";
    public static final String OutlineColor = "OUTLINECOLOR";
    public static final String DrawAsIcon = "DRAWASICON";
    public static final String LineWidth = "LINEWIDTH";
    public static final String TextColor = "TEXTCOLOR";
    public static final String TextBackgroundColor = "TEXTBACKGROUNDCOLOR";
    public static final String UseDashArray = "USEDASHARRAY";
    public static final String AltitudeMode = "ALTITUDEMODE";
    public static final String HideOptionalLabels = "HIDEOPTIONALLABELS";
    public static final String UsePatternFill = "USEPATTERNFILL";
    public static final String PatternFillType = "PATTERNFILLTYPE";
    public static final String DistanceUnits = "DISTANCEUNITS";
    public static final String AltitudeUnits = "ALTITUDEUNITS";
    public static final String EngagementBarColor = "ENGAGEMENTBARCOLOR";
    public static final String PatternScale = "PATTERNSCALE";

    public static ArrayList<String> GetModifierList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(LineColor);
        list.add(FillColor);
        list.add(PixelSize);
        list.add(KeepUnitRatio);
        list.add(Alpha);
        list.add(OutlineSymbol);
        list.add(OutlineColor);
        list.add(DrawAsIcon);
        list.add(HideOptionalLabels);
        list.add(DistanceUnits);
        list.add(AltitudeUnits);
        list.add(EngagementBarColor);
        return list;
    }

    public static ArrayList<String> GetAttributesList(String symbolID) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(LineColor);
        list.add(FillColor);
        list.add(PixelSize);
        if (!SymbolUtilities.isMultiPoint(symbolID)) {
            list.add(KeepUnitRatio);
            list.add(OutlineSymbol);
            list.add(OutlineColor);
            list.add(DrawAsIcon);
            if (SymbolUtilities.hasModifier(symbolID, "AO_ENGAGEMENT_BAR").booleanValue()) {
                list.add(EngagementBarColor);
            }
        } else {
            list.add(LineWidth);
            list.add(HideOptionalLabels);
            list.add(DistanceUnits);
            list.add(AltitudeUnits);
        }
        list.add(Alpha);
        return list;
    }

    public static String getAttributeName(String attribute) {
        switch (attribute) {
            case "LINECOLOR": {
                return "Line Color";
            }
            case "FILLCOLOR": {
                return "Fill Color";
            }
            case "PIXELSIZE": {
                return "Pixel Size";
            }
            case "KEEPUNITRATIO": {
                return "Keep Unit Ratio";
            }
            case "ALPHA": {
                return "Alpha";
            }
            case "OUTLINESYMBOL": {
                return "Outline Symbol";
            }
            case "OUTLINECOLOR": {
                return "Outline Color";
            }
            case "DRAWASICON": {
                return "Draw as Icon";
            }
            case "LINEWIDTH": {
                return "Line Width";
            }
            case "TEXTCOLOR": {
                return "Text Color";
            }
            case "TEXTBACKGROUNDCOLOR": {
                return "Text Background Color";
            }
            case "USEDASHARRAY": {
                return "Use Dash Array";
            }
            case "ALTITUDEMODE": {
                return "Altitude Mode";
            }
            case "HIDEOPTIONALLABELS": {
                return "Hide Optional Labels";
            }
            case "USEPATTERNFILL": {
                return "Use Pattern Fill";
            }
            case "PATTERNFILLTYPE": {
                return "Pattern Fill Type";
            }
            case "DISTANCEUNITS": {
                return "Distance Units";
            }
            case "ALTITUDEUNITS": {
                return "Altitude Units";
            }
        }
        return "unrecognized attribute";
    }

    public static String getAttributeKey(String attribute) {
        switch (attribute.toUpperCase()) {
            case "LINECOLOR": {
                return LineColor;
            }
            case "FILLCOLOR": {
                return FillColor;
            }
            case "PIXELSIZE": {
                return PixelSize;
            }
            case "KEEPUNITRATIO": {
                return KeepUnitRatio;
            }
            case "ALPHA": {
                return Alpha;
            }
            case "OUTLINESYMBOL": {
                return OutlineSymbol;
            }
            case "OUTLINECOLOR": {
                return OutlineColor;
            }
            case "DRAWASICON": {
                return DrawAsIcon;
            }
            case "LINEWIDTH": {
                return LineWidth;
            }
            case "TEXTCOLOR": {
                return TextColor;
            }
            case "TEXTBACKGROUNDCOLOR": {
                return TextBackgroundColor;
            }
            case "USEDASHARRAY": {
                return UseDashArray;
            }
            case "ALTITUDEMODE": {
                return AltitudeMode;
            }
            case "HIDEOPTIONALLABELS": {
                return HideOptionalLabels;
            }
            case "USEPATTERNFILL": {
                return UsePatternFill;
            }
            case "PATTERNFILLTYPE": {
                return PatternFillType;
            }
            case "DISTANCEUNITS": {
                return DistanceUnits;
            }
            case "ALTITUDEUNITS": {
                return AltitudeUnits;
            }
        }
        return null;
    }
}

