/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.AffiliationColors;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.MSInfo;
import armyc2.c5isr.renderer.utilities.MSLookup;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.SVGLookup;
import armyc2.c5isr.renderer.utilities.SymbolID;
import java.awt.Color;
import java.awt.Point;
import java.awt.geom.Rectangle2D;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.regex.Pattern;

public class SymbolUtilities {
    private static SimpleDateFormat dateFormatFront = new SimpleDateFormat("ddHHmmss", Locale.US);
    private static SimpleDateFormat dateFormatBack = new SimpleDateFormat("MMMyyyy", Locale.US);
    private static SimpleDateFormat dateFormatFull = new SimpleDateFormat("ddHHmmssZMMMyyyy", Locale.US);
    private static SimpleDateFormat dateFormatZulu = new SimpleDateFormat("Z", Locale.US);
    private static final String Digits = "(\\p{Digit}+)";
    private static final String HexDigits = "(\\p{XDigit}+)";
    private static final String Exp = "[eE][+-]?(\\p{Digit}+)";
    private static final String fpRegex = "[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*";
    private static final Pattern pIsNumber = Pattern.compile("[\\x00-\\x20]*[+-]?(NaN|Infinity|((((\\p{Digit}+)(\\.)?((\\p{Digit}+)?)([eE][+-]?(\\p{Digit}+))?)|(\\.((\\p{Digit}+))([eE][+-]?(\\p{Digit}+))?)|(((0[xX](\\p{XDigit}+)(\\.)?)|(0[xX](\\p{XDigit}+)?(\\.)(\\p{XDigit}+)))[pP][+-]?(\\p{Digit}+)))[fFdD]?))[\\x00-\\x20]*");

    public static boolean isNumber(String text) {
        return pIsNumber.matcher(text).matches();
    }

    public static String getDateLabel(Date time) {
        String modifierString = null;
        String zulu = "";
        zulu = dateFormatZulu.format(time);
        if (zulu != null && zulu.length() == 5) {
            zulu = zulu.startsWith("+") ? zulu.substring(1, 3) : zulu.substring(0, 3);
            int intZulu = Integer.valueOf(zulu);
            zulu = SymbolUtilities.getZuluCharFromTimeZoneOffset(intZulu);
        } else {
            zulu = SymbolUtilities.getZuluCharFromTimeZoneOffset(time);
        }
        modifierString = dateFormatFront.format(time) + zulu + dateFormatBack.format(time);
        return modifierString.toUpperCase();
    }

    private static String getZuluCharFromTimeZoneOffset(Date time) {
        TimeZone tz = TimeZone.getDefault();
        Date offset = new Date(tz.getOffset(time.getTime()));
        long lOffset = offset.getTime() / 3600000L;
        int hour = (int)lOffset;
        return SymbolUtilities.getZuluCharFromTimeZoneOffset(hour);
    }

    private static String getZuluCharFromTimeZoneOffset(int hour) {
        if (hour == 0) {
            return "Z";
        }
        if (hour == -1) {
            return "N";
        }
        if (hour == -2) {
            return "O";
        }
        if (hour == -3) {
            return "P";
        }
        if (hour == -4) {
            return "Q";
        }
        if (hour == -5) {
            return "R";
        }
        if (hour == -6) {
            return "S";
        }
        if (hour == -7) {
            return "T";
        }
        if (hour == -8) {
            return "U";
        }
        if (hour == -9) {
            return "V";
        }
        if (hour == -10) {
            return "W";
        }
        if (hour == -11) {
            return "X";
        }
        if (hour == -12) {
            return "Y";
        }
        if (hour == 1) {
            return "A";
        }
        if (hour == 2) {
            return "B";
        }
        if (hour == 3) {
            return "C";
        }
        if (hour == 4) {
            return "D";
        }
        if (hour == 5) {
            return "E";
        }
        if (hour == 6) {
            return "F";
        }
        if (hour == 7) {
            return "G";
        }
        if (hour == 8) {
            return "H";
        }
        if (hour == 9) {
            return "I";
        }
        if (hour == 10) {
            return "K";
        }
        if (hour == 11) {
            return "L";
        }
        if (hour == 12) {
            return "M";
        }
        return "-";
    }

    public static Boolean hasModifier(String symbolID, String modifier) {
        MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
        if (msi != null) {
            ArrayList<String> mods = msi.getModifiers();
            if (mods != null && mods.contains(modifier)) {
                return true;
            }
            if (msi.getSymbolSet() == 25 && modifier.equals("AB_FEINT_DUMMY_INDICATOR")) {
                return true;
            }
            return false;
        }
        return false;
    }

    public static String getBasicSymbolID(String id) {
        if (id.length() == 8) {
            return id;
        }
        if (id.startsWith("B")) {
            return id;
        }
        if (id.equals("octagon")) {
            return id;
        }
        if (id.length() >= 20 && id.length() <= 30) {
            String key = id.substring(4, 6) + id.substring(10, 16);
            return key;
        }
        if (id.length() == 15) {
            return SymbolUtilities.getBasicSymbolID2525C(id);
        }
        return id;
    }

    public static String getBasicSymbolID2525C(String strSymbolID) {
        if (strSymbolID != null && strSymbolID.length() == 15) {
            StringBuilder sb = new StringBuilder();
            char scheme = strSymbolID.charAt(0);
            if (scheme == 'G') {
                sb.append(strSymbolID.charAt(0));
                sb.append("*");
                sb.append(strSymbolID.charAt(2));
                sb.append("*");
                sb.append(strSymbolID.substring(4, 10));
                sb.append("****X");
            } else if (scheme != 'W' && scheme != 'B' && scheme != 'P') {
                sb.append(strSymbolID.charAt(0));
                sb.append("*");
                sb.append(strSymbolID.charAt(2));
                sb.append("*");
                sb.append(strSymbolID.substring(4, 10));
                sb.append("*****");
            } else {
                return strSymbolID;
            }
            return sb.toString();
        }
        return strSymbolID;
    }

    public static String reconcileSymbolID(String symbolID) {
        String newID = "";
        try {
            int v = SymbolID.getVersion(symbolID);
            newID = v < 13 ? String.valueOf(11) : String.valueOf(13);
            int c = SymbolID.getContext(symbolID);
            newID = c > 2 ? newID + String.valueOf(0) : newID + String.valueOf(c);
            int a = SymbolID.getAffiliation(symbolID);
            newID = a > 6 ? newID + String.valueOf(1) : newID + String.valueOf(a);
            int ss = SymbolID.getSymbolSet(symbolID);
            switch (ss) {
                case 0: 
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 10: 
                case 11: 
                case 15: 
                case 20: 
                case 25: 
                case 27: 
                case 30: 
                case 35: 
                case 36: 
                case 40: 
                case 45: 
                case 46: 
                case 47: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 60: {
                    newID = newID + String.format("%02d", ss);
                    break;
                }
                default: {
                    newID = newID + String.format("%02d", 0);
                }
            }
            int s = SymbolID.getStatus(symbolID);
            newID = s > 5 ? newID + String.valueOf(0) : newID + String.valueOf(s);
            newID = newID + String.valueOf(SymbolID.getHQTFD(symbolID));
            newID = newID + String.format("%02d", SymbolID.getAmplifierDescriptor(symbolID));
            int ec = SymbolID.getEntityCode(symbolID);
            if (ec == 0) {
                newID = newID + "000000";
            } else if (SVGLookup.getInstance().getSVGLInfo(SVGLookup.getMainIconID(newID + ec + "0000"), v) == null) {
                newID = SymbolID.setSymbolSet(newID, 98);
                newID = newID + 100000;
            } else {
                newID = newID + String.format("%06d", ec);
            }
            newID = newID + symbolID.substring(16);
        }
        catch (Exception exc) {
            newID = "110098000010000000000000000000";
        }
        return newID;
    }

    public static Color getLineColorOfAffiliation(String symbolID) {
        Color retColor = null;
        int symbolSet = SymbolID.getSymbolSet(symbolID);
        int set = SymbolID.getSymbolSet(symbolID);
        int affiliation = SymbolID.getAffiliation(symbolID);
        int symStd = SymbolID.getVersion(symbolID);
        int entityCode = SymbolID.getEntityCode(symbolID);
        try {
            if (symbolID == null || symbolID.equals("")) {
                return retColor;
            }
            if (symbolSet == 25) {
                int entitySubtype;
                int entityType;
                int entity = SymbolID.getEntity(symbolID);
                if (SymbolUtilities.isGreenProtectionGraphic(entity, entityType = SymbolID.getEntityType(symbolID), entitySubtype = SymbolID.getEntitySubtype(symbolID))) {
                    retColor = AffiliationColors.ObstacleGreen;
                }
                if (retColor == null) {
                    switch (affiliation) {
                        case 2: 
                        case 3: {
                            retColor = AffiliationColors.FriendlyGraphicLineColor;
                            break;
                        }
                        case 6: {
                            retColor = AffiliationColors.HostileGraphicLineColor;
                            break;
                        }
                        case 5: {
                            if (symStd >= 13) {
                                retColor = AffiliationColors.SuspectGraphicLineColor;
                                break;
                            }
                            retColor = AffiliationColors.HostileGraphicLineColor;
                            break;
                        }
                        case 4: {
                            retColor = AffiliationColors.NeutralGraphicLineColor;
                            break;
                        }
                        default: {
                            retColor = AffiliationColors.UnknownGraphicLineColor;
                        }
                    }
                }
            } else if (set >= 45 && set <= 47) {
                retColor = Color.BLACK;
            } else if (set == 36 && RendererSettings.getInstance().getSeaMineRenderMethod() == 1) {
                if (entityCode != 110600 && entityCode != 110700) {
                    switch (affiliation) {
                        case 2: 
                        case 3: {
                            retColor = AffiliationColors.FriendlyUnitFillColor;
                            break;
                        }
                        case 6: {
                            retColor = AffiliationColors.HostileGraphicLineColor;
                            break;
                        }
                        case 5: {
                            if (symStd >= 13) {
                                retColor = AffiliationColors.SuspectGraphicLineColor;
                                break;
                            }
                            retColor = AffiliationColors.HostileGraphicLineColor;
                            break;
                        }
                        case 4: {
                            retColor = AffiliationColors.NeutralUnitFillColor;
                            break;
                        }
                        default: {
                            retColor = AffiliationColors.UnknownUnitFillColor;
                            break;
                        }
                    }
                } else {
                    retColor = Color.BLACK;
                }
            } else {
                retColor = Color.BLACK;
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("SymbolUtilities", "getLineColorOfAffiliation", e);
        }
        return retColor;
    }

    public static Color getDefaultLineColor(String symbolID) {
        try {
            if (symbolID == null || symbolID.equals("")) {
                return null;
            }
            int symbolSet = SymbolID.getSymbolSet(symbolID);
            int entityCode = SymbolID.getEntityCode(symbolID);
            int version = SymbolID.getVersion(symbolID);
            if (symbolSet == 25) {
                if (entityCode == 200600) {
                    return Color.WHITE;
                }
                if (entityCode == 200700) {
                    return new Color(51, 136, 136);
                }
                if (entityCode == 200101) {
                    return new Color(255, 155, 0);
                }
                if (entityCode == 200201 || entityCode == 200202) {
                    return new Color(85, 119, 136);
                }
                if (version >= 13 && (entityCode == 132100 || entityCode == 282001 || entityCode == 282002 || entityCode == 282003)) {
                    return new Color(128, 0, 128);
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("SymbolUtilities", "getDefaultLineColor", e);
        }
        return SymbolUtilities.getLineColorOfAffiliation(symbolID);
    }

    public static boolean hasDefaultFill(String strSymbolID) {
        int ec = SymbolID.getEntityCode(strSymbolID);
        switch (ec) {
            case 200101: 
            case 200201: 
            case 200202: 
            case 200600: 
            case 200700: {
                return true;
            }
        }
        return !SymbolUtilities.isTacticalGraphic(strSymbolID);
    }

    public static boolean isTacticalGraphic(String strSymbolID) {
        try {
            int ss = SymbolID.getSymbolSet(strSymbolID);
            if (ss == 25 || SymbolUtilities.isWeather(strSymbolID)) {
                return true;
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("SymbolUtilities", "getFillColorOfAffiliation", e);
        }
        return false;
    }

    public static boolean isMultiPoint(String symbolID) {
        MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
        if (msi == null) {
            return false;
        }
        int drawRule = msi.getDrawRule();
        int ss = msi.getSymbolSet();
        if (ss != 25 && ss != 46 && ss != 45 && ss != 47) {
            return false;
        }
        if (ss == 25) {
            if (msi.getMaxPointCount() > 1) {
                return true;
            }
            return (drawRule < 201 || drawRule > 216 || drawRule == 212) && drawRule != 0 && drawRule != 122;
        }
        if (ss == 46 || ss == 45 || ss == 47) {
            return msi.getMaxPointCount() > 1;
        }
        return false;
    }

    public static boolean isActionPoint(String symbolID) {
        int ec;
        MSInfo msi = MSLookup.getInstance().getMSLInfo(symbolID);
        return msi.getDrawRule() == 201 && (ec = SymbolID.getEntityCode(symbolID)) != 131300 && ec != 131301 && ec != 182600 && ec != 212800;
    }

    public static boolean isTGSPWithSpecialModifierLayout(String strSymbolID) {
        try {
            int ss = SymbolID.getSymbolSet(strSymbolID);
            int entityCode = SymbolID.getEntityCode(strSymbolID);
            if (ss == 25) {
                if (SymbolUtilities.isCBRNEvent(strSymbolID)) {
                    return true;
                }
                if (SymbolUtilities.isSonobuoy(strSymbolID)) {
                    return true;
                }
                switch (entityCode) {
                    case 130500: 
                    case 130700: 
                    case 131300: 
                    case 131800: 
                    case 160300: 
                    case 180100: 
                    case 180200: 
                    case 212800: 
                    case 240601: 
                    case 240602: 
                    case 240900: 
                    case 270701: 
                    case 282001: 
                    case 282002: {
                        return true;
                    }
                }
                return false;
            }
            if (ss == 45) {
                switch (entityCode) {
                    case 110102: 
                    case 110202: 
                    case 162200: 
                    case 162300: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("SymbolUtilities", "isTGSPWithSpecialModifierLayout", e);
        }
        return false;
    }

    public static Color getFillColorOfAffiliation(String symbolID) {
        Color retColor = null;
        int entityCode = SymbolID.getEntityCode(symbolID);
        int entity = SymbolID.getEntity(symbolID);
        int entityType = SymbolID.getEntityType(symbolID);
        int entitySubtype = SymbolID.getEntitySubtype(symbolID);
        int affiliation = SymbolID.getAffiliation(symbolID);
        try {
            if (symbolID == null || symbolID.equals("")) {
                return retColor;
            }
            if (SymbolID.getSymbolSet(symbolID) == 25) {
                switch (entityCode) {
                    case 200101: {
                        retColor = new Color(255, 155, 0, 63);
                        break;
                    }
                    case 200201: 
                    case 200202: 
                    case 200600: {
                        retColor = new Color(85, 119, 136, 63);
                        break;
                    }
                    case 200700: {
                        retColor = new Color(51, 136, 136, 63);
                    }
                }
            } else if (SymbolID.getSymbolSet(symbolID) == 36 && RendererSettings.getInstance().getSeaMineRenderMethod() == 1 && entityCode != 110600 && entityCode != 110700) {
                retColor = new Color(0, 0, 0, 0);
            }
            if (retColor == null) {
                switch (affiliation) {
                    case 2: 
                    case 3: {
                        retColor = AffiliationColors.FriendlyUnitFillColor;
                        break;
                    }
                    case 6: {
                        retColor = AffiliationColors.HostileUnitFillColor;
                        break;
                    }
                    case 5: {
                        if (SymbolID.getVersion(symbolID) >= 13) {
                            retColor = AffiliationColors.SuspectGraphicFillColor;
                            break;
                        }
                        retColor = AffiliationColors.HostileGraphicFillColor;
                        break;
                    }
                    case 4: {
                        retColor = AffiliationColors.NeutralUnitFillColor;
                        break;
                    }
                    default: {
                        retColor = AffiliationColors.UnknownUnitFillColor;
                    }
                }
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("SymbolUtilities", "getFillColorOfAffiliation", e);
        }
        return retColor;
    }

    public static Boolean canSymbolHaveModifier(String symbolID, String modifier) {
        return SymbolUtilities.hasModifier(symbolID, modifier);
    }

    public static Boolean hasFDI(String symbolID) {
        int hqtfd = SymbolID.getHQTFD(symbolID);
        if (hqtfd == 1 || hqtfd == 5 || hqtfd == 3 || hqtfd == 7) {
            return true;
        }
        return false;
    }

    public static boolean isGreenProtectionGraphic(int entity, int entityType, int entitySubtype) {
        if (entity >= 27 && entity <= 29) {
            if (entity == 27) {
                if (entityType > 0 && entityType <= 5) {
                    return true;
                }
                return entityType == 7 || entityType == 8 || entityType == 10 || entityType == 12;
            }
            if (entity == 28) {
                if (entityType > 0 && entityType <= 7) {
                    return true;
                }
                return entityType == 19;
            }
            if (entity == 29) {
                return entityType >= 1 && entityType <= 5;
            }
        } else {
            return false;
        }
        return false;
    }

    public static boolean isGreenProtectionGraphic(String symbolID) {
        if (SymbolID.getSymbolSet(symbolID) == 25) {
            return SymbolUtilities.isGreenProtectionGraphic(SymbolID.getEntity(symbolID), SymbolID.getEntityType(symbolID), SymbolID.getEntitySubtype(symbolID));
        }
        return false;
    }

    public static boolean isCBRNEvent(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int ec = SymbolID.getEntityCode(symbolID);
        if (ss == 25) {
            switch (ec) {
                case 281300: 
                case 281400: 
                case 281500: 
                case 281600: 
                case 281700: {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isSonobuoy(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int e = SymbolID.getEntity(symbolID);
        int et = SymbolID.getEntityType(symbolID);
        return ss == 25 && e == 21 && et == 35;
    }

    public static boolean isObstacle(String symbolID) {
        return SymbolID.getSymbolSet(symbolID) == 25 && SymbolID.getEntity(symbolID) == 27;
    }

    public static boolean isWeather(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        return ss >= 45 && ss <= 47;
    }

    public static boolean isHQ(String symbolID) {
        int hq = SymbolID.getHQTFD(symbolID);
        return SymbolUtilities.hasModifier(symbolID, "S_HQ_STAFF_INDICATOR") != false && (hq == 3 || hq == 2 || hq == 7 || hq == 6);
    }

    public static boolean isSPWithSpecialModifierLayout(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int ec = SymbolID.getEntityCode(symbolID);
        if (ss == 25) {
            switch (ec) {
                case 130500: 
                case 130700: 
                case 131300: 
                case 131800: 
                case 131900: 
                case 132000: 
                case 132100: 
                case 160300: 
                case 180100: 
                case 180200: 
                case 180600: 
                case 210300: 
                case 210600: 
                case 210800: 
                case 211000: 
                case 212800: 
                case 213500: 
                case 213501: 
                case 213502: 
                case 213503: 
                case 213504: 
                case 213505: 
                case 213506: 
                case 213507: 
                case 213508: 
                case 213509: 
                case 213510: 
                case 213511: 
                case 213512: 
                case 213513: 
                case 213514: 
                case 213515: 
                case 214900: 
                case 215600: 
                case 217000: 
                case 240601: 
                case 240602: 
                case 240900: 
                case 250600: 
                case 270701: 
                case 281300: 
                case 281400: 
                case 281500: 
                case 281600: 
                case 281700: 
                case 282001: 
                case 282002: {
                    return true;
                }
            }
            return false;
        }
        if (ss == 45) {
            switch (ec) {
                case 110102: 
                case 110202: 
                case 162200: 
                case 162300: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static Point getCMSymbolAnchorPoint(String symbolID, Rectangle2D bounds) {
        double centerX = bounds.getWidth() / 2.0;
        double centerY = bounds.getHeight() / 2.0;
        int ss = SymbolID.getSymbolSet(symbolID);
        int ec = SymbolID.getEntityCode(symbolID);
        Object msi = null;
        int drawRule = 0;
        if (ss == 25) {
            drawRule = MSLookup.getInstance().getMSLInfo(symbolID).getDrawRule();
            switch (drawRule) {
                case 201: 
                case 205: 
                case 206: 
                case 207: {
                    centerY = bounds.getHeight();
                    break;
                }
                case 204: {
                    centerY = bounds.getHeight() * 0.8;
                    break;
                }
                case 210: {
                    centerY = bounds.getHeight() * 0.75;
                    break;
                }
                case 213: {
                    centerY = bounds.getHeight() * 0.74;
                    break;
                }
                case 215: {
                    centerX = 0.0;
                    break;
                }
                case 216: {
                    centerY = bounds.getHeight() * 0.87;
                    break;
                }
                case 202: {
                    if (ec == 280500) {
                        centerY = bounds.getHeight() * 0.35;
                        break;
                    }
                    if (ec == 280400) {
                        centerY = bounds.getHeight() * 0.33;
                        break;
                    }
                    if (ec == 280200) {
                        centerY = bounds.getHeight() * 0.7;
                        break;
                    }
                    if (ec == 280201) {
                        centerY = bounds.getHeight() * 0.65;
                        break;
                    }
                    if (ec == 219000) {
                        centerY = bounds.getHeight() * 0.7;
                        break;
                    }
                    if (ec != 212500) break;
                    centerY = bounds.getHeight() * 0.4;
                    break;
                }
            }
            switch (ec) {
                case 180400: {
                    centerX = bounds.getWidth() * 0.3341;
                    break;
                }
                case 240900: {
                    centerX = bounds.getWidth() * 0.38;
                    break;
                }
                case 280201: {
                    centerX = bounds.getWidth() * 0.43;
                }
            }
        }
        return new Point(Math.round((float)centerX), Math.round((float)centerY));
    }

    public static Boolean isInstallation(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int entity = SymbolID.getEntity(symbolID);
        if (ss == 20 && entity == 11) {
            return true;
        }
        return false;
    }

    public static Boolean isAir(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int entity = SymbolID.getEntity(symbolID);
        if (ss == 1 || ss == 2 || ss == 51) {
            return true;
        }
        return false;
    }

    public static Boolean isSpace(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int entity = SymbolID.getEntity(symbolID);
        if (ss == 5 || ss == 6 || ss == 50) {
            return true;
        }
        return false;
    }

    public static Boolean isLand(String symbolID) {
        int ss = SymbolID.getSymbolSet(symbolID);
        int entity = SymbolID.getEntity(symbolID);
        if (ss == 10 || ss == 11 || ss == 15 || ss == 20 || ss == 52) {
            return true;
        }
        return false;
    }

    public static Boolean isTaskForce(String symbolID) {
        int hqtfd = SymbolID.getHQTFD(symbolID);
        if ((hqtfd == 4 || hqtfd == 6 || hqtfd == 5 || hqtfd == 7) && SymbolUtilities.canSymbolHaveModifier(symbolID, "B_ECHELON").booleanValue()) {
            return true;
        }
        return false;
    }

    public static Boolean isReality(String symbolID) {
        int c = SymbolID.getContext(symbolID);
        if (c == 0 || c == 3 || c == 4) {
            return true;
        }
        return false;
    }

    public static Boolean isExercise(String symbolID) {
        int c = SymbolID.getContext(symbolID);
        if (c == 1 || c == 5 || c == 6) {
            return true;
        }
        return false;
    }

    public static Boolean isSimulation(String symbolID) {
        int c = SymbolID.getContext(symbolID);
        if (c == 2 || c == 7 || c == 8) {
            return true;
        }
        return false;
    }

    public static String getEchelonText(int echelon) {
        char[] dots = new char[]{'\u2022', '\u2022', '\u2022'};
        String dot = new String(dots);
        String text = null;
        if (echelon == 11) {
            text = "\u00d8";
        } else if (echelon == 12) {
            text = dot.substring(0, 1);
        } else if (echelon == 13) {
            text = dot.substring(0, 2);
        } else if (echelon == 14) {
            text = dot;
        } else if (echelon == 15) {
            text = "I";
        } else if (echelon == 16) {
            text = "II";
        } else if (echelon == 17) {
            text = "III";
        } else if (echelon == 18) {
            text = "X";
        } else if (echelon == 21) {
            text = "XX";
        } else if (echelon == 22) {
            text = "XXX";
        } else if (echelon == 23) {
            text = "XXXX";
        } else if (echelon == 24) {
            text = "XXXXX";
        } else if (echelon == 25) {
            text = "XXXXXX";
        } else if (echelon == 26) {
            text = "++";
        }
        return text;
    }

    public static String getStandardIdentityModifier(String symbolID) {
        String textChar = null;
        int si = SymbolID.getStandardIdentity(symbolID);
        int context = SymbolID.getContext(symbolID);
        int affiliation = SymbolID.getAffiliation(symbolID);
        if (context == 2) {
            textChar = "S";
        } else if (context == 1) {
            if (affiliation == 5) {
                textChar = "J";
            } else if (affiliation == 6) {
                textChar = "K";
            } else if (context == 1) {
                textChar = "X";
            }
        }
        return textChar;
    }

    public static boolean hasRectangleFrame(String symbolID) {
        int affiliation = SymbolID.getAffiliation(symbolID);
        int ss = SymbolID.getSymbolSet(symbolID);
        if (ss != 25) {
            return affiliation == 3 || affiliation == 2 || SymbolID.getContext(symbolID) == 1 && (affiliation == 6 || affiliation == 5);
        }
        return false;
    }

    public static float getUnitRatioHeight(String symbolID) {
        int ver = SymbolID.getVersion(symbolID);
        int aff = SymbolID.getAffiliation(symbolID);
        float rh = 0.0f;
        if (ver < 13) {
            int ss = SymbolID.getSymbolSet(symbolID);
            if (aff == 6 || aff == 5) {
                switch (ss) {
                    case 10: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 40: 
                    case 52: 
                    case 60: {
                        rh = 1.44f;
                        break;
                    }
                    default: {
                        rh = 1.3f;
                        break;
                    }
                }
            } else if (aff == 3 || aff == 2) {
                switch (ss) {
                    case 10: 
                    case 11: 
                    case 20: 
                    case 40: 
                    case 60: {
                        rh = 1.0f;
                        break;
                    }
                    default: {
                        rh = 1.2f;
                        break;
                    }
                }
            } else if (aff == 4) {
                switch (ss) {
                    case 10: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 40: 
                    case 52: 
                    case 60: {
                        rh = 1.1f;
                        break;
                    }
                    default: {
                        rh = 1.2f;
                        break;
                    }
                }
            } else {
                switch (ss) {
                    case 10: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 40: 
                    case 52: 
                    case 60: {
                        rh = 1.44f;
                        break;
                    }
                    default: {
                        rh = 1.3f;
                    }
                }
            }
        } else {
            String frameID = SVGLookup.getFrameID(symbolID);
            if (frameID.length() != 6) {
                return 1.0f;
            }
            aff = Integer.parseInt(frameID.substring(2, 3));
            char fs = frameID.charAt(3);
            if (aff == 6 || aff == 5) {
                switch (fs) {
                    case '3': 
                    case '4': 
                    case '5': 
                    case '8': 
                    case '9': {
                        rh = 1.44f;
                        break;
                    }
                    default: {
                        rh = 1.3f;
                        break;
                    }
                }
            } else if (aff == 3 || aff == 2) {
                switch (fs) {
                    case '3': 
                    case '5': 
                    case '8': 
                    case '9': {
                        rh = 1.0f;
                        break;
                    }
                    default: {
                        rh = 1.2f;
                        break;
                    }
                }
            } else if (aff == 4) {
                switch (fs) {
                    case '3': 
                    case '4': 
                    case '5': 
                    case '8': 
                    case '9': {
                        rh = 1.1f;
                        break;
                    }
                    default: {
                        rh = 1.2f;
                        break;
                    }
                }
            } else {
                switch (fs) {
                    case '3': 
                    case '4': 
                    case '5': 
                    case '8': 
                    case '9': {
                        rh = 1.44f;
                        break;
                    }
                    default: {
                        rh = 1.3f;
                    }
                }
            }
        }
        return rh;
    }

    public static float getUnitRatioWidth(String symbolID) {
        int ver = SymbolID.getVersion(symbolID);
        int aff = SymbolID.getAffiliation(symbolID);
        float rw = 0.0f;
        if (ver < 13) {
            int ss = SymbolID.getSymbolSet(symbolID);
            if (aff == 6 || aff == 5) {
                switch (ss) {
                    case 10: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 40: 
                    case 52: 
                    case 60: {
                        rw = 1.44f;
                        break;
                    }
                    default: {
                        rw = 1.1f;
                        break;
                    }
                }
            } else if (aff == 3 || aff == 2) {
                switch (ss) {
                    case 10: 
                    case 11: 
                    case 20: 
                    case 40: 
                    case 60: {
                        rw = 1.5f;
                        break;
                    }
                    case 15: 
                    case 52: {
                        rw = 1.2f;
                        break;
                    }
                    default: {
                        rw = 1.1f;
                        break;
                    }
                }
            } else if (aff == 4) {
                rw = 1.1f;
            } else {
                switch (ss) {
                    case 10: 
                    case 11: 
                    case 15: 
                    case 20: 
                    case 40: 
                    case 52: 
                    case 60: {
                        rw = 1.44f;
                        break;
                    }
                    default: {
                        rw = 1.5f;
                    }
                }
            }
        } else {
            String frameID = SVGLookup.getFrameID(symbolID);
            if (frameID.length() != 6) {
                return 1.0f;
            }
            aff = Integer.parseInt(frameID.substring(2, 3));
            char fs = frameID.charAt(3);
            if (aff == 6 || aff == 5) {
                switch (fs) {
                    case '3': 
                    case '4': 
                    case '5': 
                    case '8': 
                    case '9': {
                        rw = 1.44f;
                        break;
                    }
                    default: {
                        rw = 1.1f;
                        break;
                    }
                }
            } else if (aff == 3 || aff == 2) {
                switch (fs) {
                    case '3': 
                    case '5': 
                    case '8': 
                    case '9': {
                        rw = 1.5f;
                        break;
                    }
                    case '4': {
                        rw = 1.2f;
                        break;
                    }
                    default: {
                        rw = 1.1f;
                        break;
                    }
                }
            } else if (aff == 4) {
                rw = 1.1f;
            } else {
                switch (fs) {
                    case '3': 
                    case '4': 
                    case '5': 
                    case '8': 
                    case '9': {
                        rw = 1.44f;
                        break;
                    }
                    default: {
                        rw = 1.5f;
                    }
                }
            }
        }
        return rw;
    }

    public static boolean isBasicShape(int linetype) {
        switch (linetype) {
            case 10000000: 
            case 11000000: 
            case 12000000: 
            case 13000000: 
            case 13000001: 
            case 13000002: 
            case 14000000: 
            case 14000001: 
            case 14000002: 
            case 15000000: 
            case 15000001: 
            case 15000002: 
            case 15000003: 
            case 15000004: {
                return true;
            }
        }
        return false;
    }
}

