/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.ImageInfo;
import armyc2.c5isr.renderer.utilities.LRUEntry;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LRUCache {
    private LRUEntry lruElement;
    private LRUEntry mruElement;
    private Map<String, LRUEntry> container;
    private int capacity;
    private int currentSize;
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public LRUCache(int capacity) {
        this.capacity = capacity;
        this.currentSize = 0;
        this.mruElement = this.lruElement = new LRUEntry(null, null, null, null);
        this.container = new ConcurrentHashMap<String, LRUEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageInfo get(String key) {
        this.lock.readLock().lock();
        try {
            LRUEntry tempLRUEntry = this.container.get(key);
            if (tempLRUEntry == null) {
                ImageInfo imageInfo = null;
                return imageInfo;
            }
            if (tempLRUEntry.key == this.mruElement.key) {
                ImageInfo imageInfo = this.mruElement.value;
                return imageInfo;
            }
            LRUEntry nextLRUEntry = tempLRUEntry.next;
            LRUEntry prevLRUEntry = tempLRUEntry.prev;
            if (tempLRUEntry.key == this.lruElement.key) {
                nextLRUEntry.prev = null;
                this.lruElement = nextLRUEntry;
            } else if (tempLRUEntry.key != this.mruElement.key) {
                prevLRUEntry.next = nextLRUEntry;
                nextLRUEntry.prev = prevLRUEntry;
            }
            tempLRUEntry.prev = this.mruElement;
            this.mruElement.next = tempLRUEntry;
            this.mruElement = tempLRUEntry;
            this.mruElement.next = null;
            ImageInfo imageInfo = tempLRUEntry.value;
            return imageInfo;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(String key, ImageInfo value) {
        this.lock.writeLock().lock();
        try {
            LRUEntry myLRUEntry;
            if (this.container.containsKey(key)) {
                return;
            }
            this.mruElement.next = myLRUEntry = new LRUEntry(this.mruElement, null, key, value);
            this.container.put(key, myLRUEntry);
            this.mruElement = myLRUEntry;
            if (this.currentSize == this.capacity) {
                this.container.remove(this.lruElement.key);
                this.lruElement = this.lruElement.next;
                this.lruElement.prev = null;
            } else if (this.currentSize < this.capacity) {
                if (this.currentSize == 0) {
                    this.lruElement = myLRUEntry;
                }
                ++this.currentSize;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

