/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.renderer.utilities;

import armyc2.c5isr.renderer.utilities.AffiliationColors;
import armyc2.c5isr.renderer.utilities.DistanceUnit;
import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.RendererUtilities;
import armyc2.c5isr.renderer.utilities.ShapeInfo;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import java.awt.Color;
import java.awt.TexturePaint;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MilStdSymbol {
    private Map<String, String> _Properties = null;
    private ArrayList<Double> _X_Altitude = null;
    private ArrayList<Double> _AM_Distance = null;
    private ArrayList<Double> _AN_Azimuth = null;
    private String _symbolID = "";
    private String _UUID = null;
    private ArrayList<ShapeInfo> _SymbolShapes;
    private ArrayList<ShapeInfo> _ModifierShapes;
    private ArrayList<Point2D> _Coordinates;
    private int _UnitSize = 50;
    private double _scale = 0.0;
    private Boolean _KeepUnitRatio = true;
    Integer _LineWidth = 3;
    Color _LineColor = null;
    Color _FillColor = null;
    Color _TextColor = null;
    Color _TextBackgroundColor = null;
    double _Rotation = 0.0;
    boolean _Outline = false;
    Color _OutLineColor = null;
    int _OutLineWidth = 0;
    TexturePaint _tp = null;
    boolean _fs = true;
    int _patternFillType = 0;
    private double patternScale = 1.0;
    private static String _AltitudeMode = "";
    private static DistanceUnit _AltitudeUnit = null;
    private static DistanceUnit _DistanceUnit = null;
    private static boolean _useDashArray = true;
    private static boolean _hideOptionalLabels = false;
    private static boolean _DrawAffiliationModifierAsLabel = true;
    private static boolean _UseLineInterpolation = false;
    Object _Tag = null;
    private boolean _wasClipped = false;

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D> Coordinates, Map<String, String> modifiers) {
        this(symbolID, uniqueID, Coordinates, modifiers, true);
    }

    public MilStdSymbol(String symbolID, String uniqueID, ArrayList<Point2D> Coordinates, Map<String, String> modifiers, Boolean keepUnitRatio) {
        this._Properties = modifiers == null ? new HashMap<String, String>() : modifiers;
        this._UUID = uniqueID;
        this.setCoordinates(Coordinates);
        this.setSymbolID(symbolID);
        this.setLineColor(SymbolUtilities.getDefaultLineColor(this._symbolID));
        this.setTextColor(SymbolUtilities.getLineColorOfAffiliation(symbolID));
        if (SymbolUtilities.hasDefaultFill(this._symbolID)) {
            this.setFillColor(SymbolUtilities.getFillColorOfAffiliation(this._symbolID));
        }
        _DrawAffiliationModifierAsLabel = RendererSettings.getInstance().getDrawAffiliationModifierAsLabel();
        _UseLineInterpolation = RendererSettings.getInstance().getUseLineInterpolation();
        this._KeepUnitRatio = keepUnitRatio;
    }

    public TexturePaint getFillStyle() {
        return this._tp;
    }

    public void setFillStyle(TexturePaint value) {
        this._tp = value;
    }

    public boolean getUseFillPattern() {
        return this._fs;
    }

    public void setUseFillPattern(boolean value) {
        this._fs = value;
    }

    public int getPatternFillType() {
        return this._patternFillType;
    }

    public void setPatternFillType(int value) {
        this._patternFillType = value;
    }

    public String getAltitudeMode() {
        return _AltitudeMode;
    }

    public void setAltitudeMode(String value) {
        _AltitudeMode = value;
    }

    public DistanceUnit getAltitudeUnit() {
        return _AltitudeUnit;
    }

    public void setAltitudeUnit(DistanceUnit unit) {
        _AltitudeUnit = unit;
    }

    public DistanceUnit getDistanceUnit() {
        return _DistanceUnit;
    }

    public void setDistanceUnit(DistanceUnit unit) {
        _DistanceUnit = unit;
    }

    public boolean getUseDashArray() {
        return _useDashArray;
    }

    public void setUseDashArray(boolean value) {
        _useDashArray = value;
    }

    public boolean getHideOptionalLabels() {
        return _hideOptionalLabels;
    }

    public void setHideOptionalLabels(boolean value) {
        _hideOptionalLabels = value;
    }

    public void setUseLineInterpolation(boolean value) {
        _UseLineInterpolation = value;
    }

    public boolean getUseLineInterpolation() {
        return _UseLineInterpolation;
    }

    public void setUnitSize(int pixelSize) {
        this._UnitSize = pixelSize;
    }

    public int getUnitSize() {
        return this._UnitSize;
    }

    public void setKeepUnitRatio(boolean value) {
        this._KeepUnitRatio = value;
    }

    public boolean getKeepUnitRatio() {
        return this._KeepUnitRatio;
    }

    public void setDrawAffiliationModifierAsLabel(boolean value) {
        _DrawAffiliationModifierAsLabel = value;
    }

    public boolean getDrawAffiliationModifierAsLabel() {
        return _DrawAffiliationModifierAsLabel;
    }

    public Map<String, String> getModifierMap() {
        return this._Properties;
    }

    public void setModifierMap(Map<String, String> modifiers) {
        this._Properties = modifiers;
    }

    public String getModifier(String modifier) {
        if (this._Properties.containsKey(modifier)) {
            return this._Properties.get(modifier);
        }
        return this.getModifier(modifier, 0);
    }

    public void setModifier(String modifier, String value) {
        if (!value.equals("")) {
            if (modifier != "AM_DISTANCE" || modifier == "AN_AZIMUTH" || modifier == "X_ALTITUDE_DEPTH") {
                this._Properties.put(modifier, value);
            } else {
                this.setModifier(modifier, value, 0);
            }
        }
    }

    public String getModifier(String modifier, int index) {
        if (this._Properties.containsKey(modifier)) {
            return this._Properties.get(modifier);
        }
        if (modifier == "AM_DISTANCE" || modifier == "AN_AZIMUTH" || modifier == "X_ALTITUDE_DEPTH") {
            String value = String.valueOf(this.getModifier_AM_AN_X(modifier, index));
            if (value != null && !value.equalsIgnoreCase("null") && !value.equalsIgnoreCase("")) {
                return value;
            }
            return null;
        }
        return null;
    }

    public Double getModifier_AM_AN_X(String modifier, int index) {
        ArrayList<Double> modifiers = null;
        if (modifier == "AM_DISTANCE") {
            modifiers = this._AM_Distance;
        } else if (modifier == "AN_AZIMUTH") {
            modifiers = this._AN_Azimuth;
        } else if (modifier == "X_ALTITUDE_DEPTH") {
            modifiers = this._X_Altitude;
        } else {
            return null;
        }
        if (modifiers != null && modifiers.size() > index) {
            Double value = null;
            value = modifiers.get(index);
            if (value != null) {
                return value;
            }
            return null;
        }
        return null;
    }

    public void setModifier(String modifier, String value, int index) {
        if (!value.equals("")) {
            if (modifier != "AM_DISTANCE" && modifier != "AN_AZIMUTH" && modifier != "X_ALTITUDE_DEPTH") {
                this._Properties.put(modifier, value);
            } else {
                Double dblValue = Double.valueOf(value);
                if (dblValue != null) {
                    this.setModifier_AM_AN_X(modifier, dblValue, index);
                }
            }
        }
    }

    public void setModifier_AM_AN_X(String modifier, Double value, int index) {
        if (modifier == "AM_DISTANCE" || modifier == "AN_AZIMUTH" || modifier == "X_ALTITUDE_DEPTH") {
            ArrayList<Double> modifiers = null;
            if (modifier == "AM_DISTANCE") {
                if (this._AM_Distance == null) {
                    this._AM_Distance = new ArrayList();
                }
                modifiers = this._AM_Distance;
            } else if (modifier == "AN_AZIMUTH") {
                if (this._AN_Azimuth == null) {
                    this._AN_Azimuth = new ArrayList();
                }
                modifiers = this._AN_Azimuth;
            } else if (modifier == "X_ALTITUDE_DEPTH") {
                if (this._X_Altitude == null) {
                    this._X_Altitude = new ArrayList();
                }
                modifiers = this._X_Altitude;
            }
            if (index + 1 > modifiers.size()) {
                modifiers.add(value);
            } else {
                modifiers.set(index, value);
            }
        }
    }

    public ArrayList<Double> getModifiers_AM_AN_X(String modifier) {
        if (modifier == "AM_DISTANCE") {
            return this._AM_Distance;
        }
        if (modifier == "AN_AZIMUTH") {
            return this._AN_Azimuth;
        }
        if (modifier == "X_ALTITUDE_DEPTH") {
            return this._X_Altitude;
        }
        return null;
    }

    public void setModifiers_AM_AN_X(String modifier, ArrayList<Double> modifiers) {
        if (modifier == "AM_DISTANCE") {
            this._AM_Distance = modifiers;
        } else if (modifier == "AN_AZIMUTH") {
            this._AN_Azimuth = modifiers;
        } else if (modifier == "X_ALTITUDE_DEPTH") {
            this._X_Altitude = modifiers;
        }
    }

    public void setFillColor(Color value) {
        this._FillColor = value;
    }

    public Color getFillColor() {
        return this._FillColor;
    }

    public void setTextColor(Color value) {
        this._TextColor = value;
        if (RendererSettings.getInstance().getTextBackgroundMethod() != 0 && this._TextBackgroundColor == null) {
            this._TextBackgroundColor = RendererUtilities.getIdealOutlineColor(this._TextColor);
        }
    }

    public Color getTextColor() {
        return this._TextColor;
    }

    public void setTextBackgroundColor(Color value) {
        this._TextBackgroundColor = value;
    }

    public Color getTextBackgroundColor() {
        return this._TextBackgroundColor;
    }

    public void setLineWidth(int value) {
        this._LineWidth = value;
    }

    public int getLineWidth() {
        return this._LineWidth;
    }

    public void setLineColor(Color value) {
        if (SymbolUtilities.isGreenProtectionGraphic(this.getSymbolID())) {
            this._LineColor = AffiliationColors.ObstacleGreen;
        } else if (value != null) {
            this._LineColor = value;
        }
    }

    public Color getLineColor() {
        return this._LineColor;
    }

    public void setOutlineColor(Color value) {
        this._OutLineColor = value;
    }

    public Color getOutlineColor() {
        return this._OutLineColor;
    }

    public void setTag(Object value) {
        this._Tag = value;
    }

    public Object getTag() {
        return this._Tag;
    }

    public void setCoordinates(ArrayList<Point2D> value) {
        this._Coordinates = value;
    }

    public ArrayList<Point2D> getCoordinates() {
        return this._Coordinates;
    }

    public void setModifierShapes(ArrayList<ShapeInfo> value) {
        this._ModifierShapes = value;
    }

    public ArrayList<ShapeInfo> getModifierShapes() {
        return this._ModifierShapes;
    }

    public void setSymbolShapes(ArrayList<ShapeInfo> value) {
        this._SymbolShapes = value;
    }

    public ArrayList<ShapeInfo> getSymbolShapes() {
        return this._SymbolShapes;
    }

    public String getSymbolID() {
        return this._symbolID;
    }

    public String getUUID() {
        return this._UUID;
    }

    public void setUUID(String ID) {
        this._UUID = ID;
    }

    public void setSymbolID(String value) {
        String current = this._symbolID;
        try {
            if (value != null && !value.equals("") && !current.equals(value)) {
                this._symbolID = value;
            }
        }
        catch (Exception e) {
            ErrorLogger.LogException("MilStdSymbol", "setSymbolID - Did not fall under TG or FE", e);
        }
    }

    public void set_WasClipped(boolean value) {
        this._wasClipped = value;
    }

    public boolean get_WasClipped() {
        return this._wasClipped;
    }

    public void setPatternScale(double scale) {
        this.patternScale = scale;
    }

    public double getPatternScale() {
        return this.patternScale;
    }
}

