/*
 * Decompiled with CFR 0.152.
 */
package armyc2.c5isr.web.render;

import armyc2.c5isr.renderer.utilities.ErrorLogger;
import armyc2.c5isr.renderer.utilities.MilStdSymbol;
import armyc2.c5isr.renderer.utilities.RendererSettings;
import armyc2.c5isr.renderer.utilities.SymbolUtilities;
import armyc2.c5isr.web.render.MultiPointHandler;
import armyc2.c5isr.web.render.utilities.JavaRendererUtilities;
import java.util.Map;
import java.util.logging.Level;

public final class WebRenderer {
    public static final int OUTPUT_FORMAT_KML = 0;
    @Deprecated
    public static final int OUTPUT_FORMAT_JSON = 1;
    public static final int OUTPUT_FORMAT_GEOJSON = 2;
    public static final int OUTPUT_FORMAT_GEOSVG = 3;
    private static boolean _initSuccess = false;

    private static synchronized void init() {
        try {
            if (!_initSuccess) {
                RendererSettings.getInstance().setTextBackgroundMethod(3);
                RendererSettings.getInstance().setLabelFont("arial", 0, 12);
                ErrorLogger.setLevel(Level.FINE);
                _initSuccess = true;
            }
        }
        catch (Exception exc) {
            ErrorLogger.LogException("WebRenderer", "init", exc, Level.WARNING);
        }
    }

    public static String RenderSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, Map<String, String> modifiers, Map<String, String> attributes, int format) {
        String output = "";
        try {
            JavaRendererUtilities.addAltModeToModifiersString(attributes, altitudeMode);
            output = MultiPointHandler.RenderSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, attributes, format);
            if (ErrorLogger.getLevel().intValue() <= Level.FINER.intValue()) {
                System.out.println("");
                StringBuilder sb = new StringBuilder();
                sb.append("\nID: " + id + "\n");
                sb.append("Name: " + name + "\n");
                sb.append("Description: " + description + "\n");
                sb.append("SymbolID: " + symbolCode + "\n");
                sb.append("Scale: " + String.valueOf(scale) + "\n");
                sb.append("BBox: " + bbox + "\n");
                sb.append("Coords: " + controlPoints + "\n");
                sb.append("Modifiers: " + modifiers + "\n");
                ErrorLogger.LogMessage("WebRenderer", "RenderSymbol", sb.toString(), Level.FINER);
            }
            if (ErrorLogger.getLevel().intValue() <= Level.FINEST.intValue()) {
                String briefOutput = output.replaceAll("</Placemark>", "</Placemark>\n");
                briefOutput = output.replaceAll("(?s)<description[^>]*>.*?</description>", "<description></description>");
                ErrorLogger.LogMessage("WebRenderer", "RenderSymbol", "Output:\n" + briefOutput, Level.FINEST);
            }
        }
        catch (Exception ea) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol - " + ea.toString() + "'}";
            ErrorLogger.LogException("WebRenderer", "RenderSymbol", ea, Level.WARNING);
        }
        return output;
    }

    public static String RenderSymbol2D(String id, String name, String description, String symbolCode, String controlPoints, int pixelWidth, int pixelHeight, String bbox, Map<String, String> modifiers, Map<String, String> attributes, int format) {
        String output = "";
        try {
            output = MultiPointHandler.RenderSymbol2D(id, name, description, symbolCode, controlPoints, pixelWidth, pixelHeight, bbox, modifiers, attributes, format);
        }
        catch (Exception exc) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol: " + symbolCode + " - " + exc.toString() + "'}";
        }
        return output;
    }

    public static MilStdSymbol RenderMultiPointAsMilStdSymbol(String id, String name, String description, String symbolCode, String controlPoints, String altitudeMode, double scale, String bbox, Map<String, String> modifiers, Map<String, String> attributes) {
        MilStdSymbol mSymbol = null;
        try {
            mSymbol = MultiPointHandler.RenderSymbolAsMilStdSymbol(id, name, description, symbolCode, controlPoints, scale, bbox, modifiers, attributes);
        }
        catch (Exception ea) {
            mSymbol = null;
            ErrorLogger.LogException("WebRenderer", "RenderMultiPointAsMilStdSymbol - " + symbolCode, ea, Level.WARNING);
        }
        return mSymbol;
    }

    public static MilStdSymbol RenderBasicShapeAsMilStdSymbol(String id, String name, String description, int basicShapeType, String controlPoints, String altitudeMode, double scale, String bbox, Map<String, String> modifiers, Map<String, String> attributes) {
        MilStdSymbol mSymbol = null;
        try {
            if (SymbolUtilities.isBasicShape(basicShapeType)) {
                mSymbol = MultiPointHandler.RenderBasicShapeAsMilStdSymbol(id, name, description, basicShapeType, controlPoints, scale, bbox, modifiers, attributes);
            }
        }
        catch (Exception ea) {
            mSymbol = null;
            ErrorLogger.LogException("WebRenderer", "RenderBasicShapeAsMilStdSymbol - " + basicShapeType, ea, Level.WARNING);
        }
        return mSymbol;
    }

    public static String RenderBasicShape(String id, String name, String description, int basicShapeType, String controlPoints, String altitudeMode, double scale, String bbox, Map<String, String> modifiers, Map<String, String> attributes, int format) {
        String output = "";
        try {
            JavaRendererUtilities.addAltModeToModifiersString(attributes, altitudeMode);
            if (SymbolUtilities.isBasicShape(basicShapeType)) {
                output = MultiPointHandler.RenderBasicShape(id, name, description, basicShapeType, controlPoints, scale, bbox, modifiers, attributes, format);
            }
        }
        catch (Exception ea) {
            output = "{\"type\":'error',error:'There was an error creating the MilStdSymbol - " + ea.toString() + "'}";
            ErrorLogger.LogException("WebRenderer", "RenderBasicShape", ea, Level.WARNING);
        }
        return output;
    }
}

