/*
 * Decompiled with CFR 0.152.
 */
package com.monmonkeygroup.openapi.quote;

import com.monmonkeygroup.openapi.Config;
import com.monmonkeygroup.openapi.OpenApiException;
import com.monmonkeygroup.openapi.client.Client;
import com.monmonkeygroup.openapi.client.Profile;
import com.monmonkeygroup.openapi.quote.BrokerQueue;
import com.monmonkeygroup.openapi.quote.BrokerQueueHandler;
import com.monmonkeygroup.openapi.quote.BrokerQueueReply;
import com.monmonkeygroup.openapi.quote.BrokerQueueRequest;
import com.monmonkeygroup.openapi.quote.DepthHandler;
import com.monmonkeygroup.openapi.quote.DepthReply;
import com.monmonkeygroup.openapi.quote.DepthRequest;
import com.monmonkeygroup.openapi.quote.HistoryKbarReply;
import com.monmonkeygroup.openapi.quote.HistoryKbarRequest;
import com.monmonkeygroup.openapi.quote.Kbar;
import com.monmonkeygroup.openapi.quote.KbarReply;
import com.monmonkeygroup.openapi.quote.KbarRequest;
import com.monmonkeygroup.openapi.quote.MarketDepth;
import com.monmonkeygroup.openapi.quote.MarketInfo;
import com.monmonkeygroup.openapi.quote.MarketInfoReply;
import com.monmonkeygroup.openapi.quote.MarketInfoRequest;
import com.monmonkeygroup.openapi.quote.ParticipantInfo;
import com.monmonkeygroup.openapi.quote.ParticipantInfoReply;
import com.monmonkeygroup.openapi.quote.ParticipantInfoRequest;
import com.monmonkeygroup.openapi.quote.PushBrokerQueue;
import com.monmonkeygroup.openapi.quote.PushDepth;
import com.monmonkeygroup.openapi.quote.PushQuote;
import com.monmonkeygroup.openapi.quote.PushTrade;
import com.monmonkeygroup.openapi.quote.QuoteHandler;
import com.monmonkeygroup.openapi.quote.RealTimeFullPriceReply;
import com.monmonkeygroup.openapi.quote.RealTimeFullPriceRequest;
import com.monmonkeygroup.openapi.quote.RealTimePrice;
import com.monmonkeygroup.openapi.quote.SecurityCalcIndex;
import com.monmonkeygroup.openapi.quote.SecurityCalcIndexReply;
import com.monmonkeygroup.openapi.quote.SecurityCalcIndexRequest;
import com.monmonkeygroup.openapi.quote.SecurityListReply;
import com.monmonkeygroup.openapi.quote.SecurityListRequest;
import com.monmonkeygroup.openapi.quote.SecurityName;
import com.monmonkeygroup.openapi.quote.SecurityQuote;
import com.monmonkeygroup.openapi.quote.SecurityQuoteReply;
import com.monmonkeygroup.openapi.quote.SecurityQuoteRequest;
import com.monmonkeygroup.openapi.quote.SecurityStaticInfo;
import com.monmonkeygroup.openapi.quote.SecurityStaticInfoReply;
import com.monmonkeygroup.openapi.quote.SecurityStaticInfoRequest;
import com.monmonkeygroup.openapi.quote.SubscriptionInfoReply;
import com.monmonkeygroup.openapi.quote.SubscriptionInfoRequest;
import com.monmonkeygroup.openapi.quote.SubscriptionReply;
import com.monmonkeygroup.openapi.quote.SubscriptionRequest;
import com.monmonkeygroup.openapi.quote.TimeShare;
import com.monmonkeygroup.openapi.quote.TimeShareReply;
import com.monmonkeygroup.openapi.quote.TimeShareRequest;
import com.monmonkeygroup.openapi.quote.Trade;
import com.monmonkeygroup.openapi.quote.TradeHandler;
import com.monmonkeygroup.openapi.quote.TradeReply;
import com.monmonkeygroup.openapi.quote.TradeRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuoteContext
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(QuoteContext.class);
    private final Config config;
    private final Client client;
    private final Map<String, Set<String>> subscriptions = new ConcurrentHashMap<String, Set<String>>();

    public QuoteContext(Config config) {
        if (null == config.getQuoteAccessToken() || config.getQuoteAccessToken().isEmpty()) {
            throw new RuntimeException("don't has quoteAccessToken. please set quote access token");
        }
        Profile profile = new Profile(config.getQuoteUrl(), config.getUser(), config.getQuoteAccessToken());
        this.config = config;
        this.client = new Client(profile);
        this.client.setAfterConnected(this::afterReconnect);
        try {
            this.client.init();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void afterReconnect(Client client) {
        try {
            this.resubscribe();
        }
        catch (Exception e) {
            log.error("quote resubscribe error: {}", (Object)e.toString());
        }
    }

    private void resubscribe() throws OpenApiException {
        for (Map.Entry<String, Set<String>> entry : this.subscriptions.entrySet()) {
            this.doSubscribe(Collections.singletonList(entry.getKey()), new ArrayList<String>((Collection)entry.getValue()), true);
        }
    }

    private void doSubscribe(List<String> symbolList, List<String> actionNameList, boolean isFirstPush) throws OpenApiException {
        SubscriptionRequest request = new SubscriptionRequest(symbolList, actionNameList, true, false, isFirstPush);
        this.client.doRequest("subscribeRequest", request, SubscriptionReply.class);
    }

    public void subscribe(List<String> symbolList, List<String> actionNameList, boolean isFirstPush) throws OpenApiException {
        this.doSubscribe(symbolList, actionNameList, isFirstPush);
        symbolList.forEach(symbol -> this.subscriptions.computeIfAbsent((String)symbol, k -> ConcurrentHashMap.newKeySet()).addAll(actionNameList));
    }

    public void unsubscribe(boolean unsubAll, List<String> symbolList, List<String> actionNameList) throws OpenApiException {
        SubscriptionRequest request = new SubscriptionRequest(symbolList, actionNameList, false, unsubAll, false);
        this.client.doRequest("subscribeRequest", request, SubscriptionReply.class);
        if (unsubAll) {
            this.subscriptions.clear();
        } else {
            symbolList.forEach(symbol -> {
                Set<String> set = this.subscriptions.get(symbol);
                if (null == set) {
                    return;
                }
                actionNameList.forEach(set::remove);
            });
        }
    }

    public SubscriptionInfoReply getSubscriptionInfo(boolean reqAllConn) throws OpenApiException {
        SubscriptionInfoRequest request = new SubscriptionInfoRequest(reqAllConn);
        SubscriptionInfoReply reply = this.client.doRequest("subscriptionInfoRequest", request, SubscriptionInfoReply.class);
        return reply;
    }

    public void setOnQuote(QuoteHandler handler) {
        if (null == handler) {
            return;
        }
        this.client.addPushHandler("quote", packet -> {
            try {
                PushQuote update = packet.deserialize(PushQuote.class);
                handler.onQuote(update);
            }
            catch (Exception e) {
                log.error("quote update,unmarshal error: {}", (Object)e.toString());
            }
        });
    }

    public void setOnDepth(DepthHandler handler) {
        if (null == handler) {
            return;
        }
        this.client.addPushHandler("depth", packet -> {
            try {
                PushDepth update = packet.deserialize(PushDepth.class);
                handler.onDepth(update);
            }
            catch (Exception e) {
                log.error("depth update,unmarshal error: {}", (Object)e.toString());
            }
        });
    }

    public void setOnBrokerQueue(BrokerQueueHandler handler) {
        if (null == handler) {
            return;
        }
        this.client.addPushHandler("broker", packet -> {
            try {
                PushBrokerQueue update = packet.deserialize(PushBrokerQueue.class);
                handler.onBrokerQueue(update);
            }
            catch (Exception e) {
                log.error("broker queue update,unmarshal error: {}", (Object)e.toString());
            }
        });
    }

    public void setOnTrade(TradeHandler handler) {
        if (null == handler) {
            return;
        }
        this.client.addPushHandler("trade", packet -> {
            try {
                PushTrade update = packet.deserialize(PushTrade.class);
                handler.onTrade(update);
            }
            catch (Exception e) {
                log.error("trade update,unmarshal error: {}", (Object)e.toString());
            }
        });
    }

    public List<SecurityStaticInfo> getStaticInfo(List<String> symbolList) throws OpenApiException {
        SecurityStaticInfoRequest request = new SecurityStaticInfoRequest(symbolList);
        SecurityStaticInfoReply reply = this.client.doRequest("securityStaticInfoRequest", request, SecurityStaticInfoReply.class);
        return reply.getStaticInfoList();
    }

    public List<SecurityQuote> getQuote(List<String> symbolList) throws OpenApiException {
        SecurityQuoteRequest request = new SecurityQuoteRequest(symbolList);
        SecurityQuoteReply reply = this.client.doRequest("quoteRequest", request, SecurityQuoteReply.class);
        return reply.getSecurityQuoteList();
    }

    public List<Trade> getTrade(String symbol) throws OpenApiException {
        TradeRequest request = new TradeRequest(symbol);
        TradeReply reply = this.client.doRequest("tradeRequest", request, TradeReply.class);
        return reply.getTradeList();
    }

    public MarketDepth getDepth(String symbol) throws OpenApiException {
        DepthRequest request = new DepthRequest(symbol);
        return this.client.doRequest("depthRequest", request, DepthReply.class);
    }

    public BrokerQueue getBroker(String symbol) throws OpenApiException {
        BrokerQueueRequest request = new BrokerQueueRequest(symbol);
        return this.client.doRequest("brokerQueueRequest", request, BrokerQueueReply.class);
    }

    public List<ParticipantInfo> getParticipants() throws OpenApiException {
        ParticipantInfoRequest request = new ParticipantInfoRequest();
        ParticipantInfoReply reply = this.client.doRequest("participantInfoRequest", request, ParticipantInfoReply.class);
        return reply.getList();
    }

    public List<TimeShare> getTimeShare(String symbol, int section) throws OpenApiException {
        TimeShareRequest request = new TimeShareRequest(symbol, section);
        TimeShareReply reply = this.client.doRequest("timeShareRequest", request, TimeShareReply.class);
        return reply.getTimeShareList();
    }

    public List<Kbar> getKbar(String symbol, int period, int rehabType, int maxNum) throws OpenApiException {
        KbarRequest request = new KbarRequest(symbol, period, rehabType, maxNum);
        KbarReply reply = this.client.doRequest("kbarRequest", request, KbarReply.class);
        return reply.getKbarList();
    }

    public List<Kbar> getHistoryKbar(String symbol, int period, int rehabType, String beginTime, String endTime) throws OpenApiException {
        HistoryKbarRequest request = new HistoryKbarRequest(symbol, period, rehabType, beginTime, endTime);
        HistoryKbarReply reply = this.client.doRequest("historyKbar", request, HistoryKbarReply.class);
        return reply.getKbarList();
    }

    public List<MarketInfo> getMarketInfo() throws OpenApiException {
        MarketInfoRequest request = new MarketInfoRequest();
        MarketInfoReply reply = this.client.doRequest("marketInfoRequest", request, MarketInfoReply.class);
        return reply.getMarketInfoList();
    }

    public List<SecurityCalcIndex> getSecurityCalcIndex(List<String> symbolList) throws OpenApiException {
        SecurityCalcIndexRequest request = new SecurityCalcIndexRequest(symbolList);
        SecurityCalcIndexReply reply = this.client.doRequest("securityCalcIndexRequest", request, SecurityCalcIndexReply.class);
        return reply.getCalcIndexList();
    }

    public List<RealTimePrice> getRealTimePrice(List<String> symbolList) throws OpenApiException {
        RealTimeFullPriceRequest request = new RealTimeFullPriceRequest(symbolList);
        RealTimeFullPriceReply reply = this.client.doRequest("realTimeFullPriceRequest", request, RealTimeFullPriceReply.class);
        return reply.getList();
    }

    public List<SecurityName> getSecurityList(String market, boolean availableTrading) throws OpenApiException {
        SecurityListRequest request = new SecurityListRequest(market, availableTrading);
        SecurityListReply reply = this.client.doRequest("securityListRequest", request, SecurityListReply.class);
        return reply.getSecurityList();
    }

    public Config getConfig() {
        return this.config;
    }

    @Override
    public void close() {
        this.client.close();
    }
}

