/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AlwaysEncodeBodyContract;
import feign.Body;
import feign.DeclarativeContract;
import feign.Feign;
import feign.HeaderMap;
import feign.Headers;
import feign.MethodMetadata;
import feign.Param;
import feign.QueryMap;
import feign.Request;
import feign.RequestLine;
import feign.Types;
import feign.Util;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public interface Contract {
    public List<MethodMetadata> parseAndValidateMetadata(Class<?> var1);

    public static class Default
    extends DeclarativeContract {
        static final Pattern REQUEST_LINE_PATTERN = Pattern.compile("^([A-Z]+)[ ]*(.*)$");

        public Default() {
            super.registerClassAnnotation(Headers.class, (E header, MethodMetadata data2) -> {
                String[] headersOnType = header.value();
                Util.checkState(headersOnType.length > 0, "Headers annotation was empty on type %s.", data2.configKey());
                Map<String, Collection<String>> headers = Default.toMap(headersOnType);
                headers.putAll(data2.template().headers());
                data2.template().headers(null);
                data2.template().headers(headers);
            });
            super.registerMethodAnnotation(RequestLine.class, (E ann, MethodMetadata data2) -> {
                String requestLine = ann.value();
                Util.checkState(Util.emptyToNull(requestLine) != null, "RequestLine annotation was empty on method %s.", data2.configKey());
                Matcher requestLineMatcher = REQUEST_LINE_PATTERN.matcher(requestLine);
                if (!requestLineMatcher.find()) {
                    throw new IllegalStateException(String.format("RequestLine annotation didn't start with an HTTP verb on method %s", data2.configKey()));
                }
                data2.template().method(Request.HttpMethod.valueOf(requestLineMatcher.group(1)));
                data2.template().uri(requestLineMatcher.group(2));
                data2.template().decodeSlash(ann.decodeSlash());
                data2.template().collectionFormat(ann.collectionFormat());
            });
            super.registerMethodAnnotation(Body.class, (E ann, MethodMetadata data2) -> {
                String body = ann.value();
                Util.checkState(Util.emptyToNull(body) != null, "Body annotation was empty on method %s.", data2.configKey());
                if (body.indexOf(123) == -1) {
                    data2.template().body(body);
                } else {
                    data2.template().bodyTemplate(body);
                }
            });
            super.registerMethodAnnotation(Headers.class, (E header, MethodMetadata data2) -> {
                String[] headersOnMethod = header.value();
                Util.checkState(headersOnMethod.length > 0, "Headers annotation was empty on method %s.", data2.configKey());
                data2.template().headers(Default.toMap(headersOnMethod));
            });
            super.registerParameterAnnotation(Param.class, (paramAnnotation, data2, paramIndex) -> {
                String annotationName = paramAnnotation.value();
                Parameter parameter = data2.method().getParameters()[paramIndex];
                String name = Util.emptyToNull(annotationName) == null && parameter.isNamePresent() ? parameter.getName() : annotationName;
                Util.checkState(Util.emptyToNull(name) != null, "Param annotation was empty on param %s.", paramIndex);
                this.nameParam(data2, name, paramIndex);
                Class<? extends Param.Expander> expander = paramAnnotation.expander();
                if (expander != Param.ToStringExpander.class) {
                    data2.indexToExpanderClass().put(paramIndex, expander);
                }
                if (!data2.template().hasRequestVariable(name)) {
                    data2.formParams().add(name);
                }
            });
            super.registerParameterAnnotation(QueryMap.class, (queryMap, data2, paramIndex) -> {
                Util.checkState(data2.queryMapIndex() == null, "QueryMap annotation was present on multiple parameters.", new Object[0]);
                data2.queryMapIndex(paramIndex);
            });
            super.registerParameterAnnotation(HeaderMap.class, (queryMap, data2, paramIndex) -> {
                Util.checkState(data2.headerMapIndex() == null, "HeaderMap annotation was present on multiple parameters.", new Object[0]);
                data2.headerMapIndex(paramIndex);
            });
        }

        private static Map<String, Collection<String>> toMap(String[] input) {
            LinkedHashMap<String, Collection<String>> result2 = new LinkedHashMap<String, Collection<String>>(input.length);
            for (String header : input) {
                int colon = header.indexOf(58);
                String name = header.substring(0, colon);
                if (!result2.containsKey(name)) {
                    result2.put(name, new ArrayList(1));
                }
                ((Collection)result2.get(name)).add(header.substring(colon + 1).trim());
            }
            return result2;
        }
    }

    public static abstract class BaseContract
    implements Contract {
        @Override
        public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
            Util.checkState(targetType.getTypeParameters().length == 0, "Parameterized types unsupported: %s", targetType.getSimpleName());
            Util.checkState(targetType.getInterfaces().length <= 1, "Only single inheritance supported: %s", targetType.getSimpleName());
            LinkedHashMap<String, MethodMetadata> result2 = new LinkedHashMap<String, MethodMetadata>();
            for (Method method : targetType.getMethods()) {
                if (method.getDeclaringClass() == Object.class || (method.getModifiers() & 8) != 0 || Util.isDefault(method)) continue;
                MethodMetadata metadata2 = this.parseAndValidateMetadata(targetType, method);
                if (result2.containsKey(metadata2.configKey())) {
                    Type overridingReturnType;
                    MethodMetadata existingMetadata = (MethodMetadata)result2.get(metadata2.configKey());
                    Type existingReturnType = existingMetadata.returnType();
                    Type resolvedType = Types.resolveReturnType(existingReturnType, overridingReturnType = metadata2.returnType());
                    if (!resolvedType.equals(overridingReturnType)) continue;
                    result2.put(metadata2.configKey(), metadata2);
                    continue;
                }
                result2.put(metadata2.configKey(), metadata2);
            }
            return new ArrayList<MethodMetadata>(result2.values());
        }

        @Deprecated
        public MethodMetadata parseAndValidateMetadata(Method method) {
            return this.parseAndValidateMetadata(method.getDeclaringClass(), method);
        }

        protected MethodMetadata parseAndValidateMetadata(Class<?> targetType, Method method) {
            MethodMetadata data2 = new MethodMetadata();
            data2.targetType(targetType);
            data2.method(method);
            data2.returnType(Types.resolve(targetType, targetType, method.getGenericReturnType()));
            data2.configKey(Feign.configKey(targetType, method));
            if (AlwaysEncodeBodyContract.class.isAssignableFrom(this.getClass())) {
                data2.alwaysEncodeBody(true);
            }
            if (targetType.getInterfaces().length == 1) {
                this.processAnnotationOnClass(data2, targetType.getInterfaces()[0]);
            }
            this.processAnnotationOnClass(data2, targetType);
            for (Annotation methodAnnotation : method.getAnnotations()) {
                this.processAnnotationOnMethod(data2, methodAnnotation, method);
            }
            if (data2.isIgnored()) {
                return data2;
            }
            Util.checkState(data2.template().method() != null, "Method %s not annotated with HTTP method type (ex. GET, POST)%s", data2.configKey(), data2.warnings());
            Class<?>[] parameterTypes = method.getParameterTypes();
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            Annotation[][] parameterAnnotations = method.getParameterAnnotations();
            int count2 = parameterAnnotations.length;
            for (int i = 0; i < count2; ++i) {
                boolean isHttpAnnotation = false;
                if (parameterAnnotations[i] != null) {
                    isHttpAnnotation = this.processAnnotationsOnParameter(data2, parameterAnnotations[i], i);
                }
                if (isHttpAnnotation) {
                    data2.ignoreParamater(i);
                }
                if ("kotlin.coroutines.Continuation".equals(parameterTypes[i].getName())) {
                    data2.ignoreParamater(i);
                }
                if (parameterTypes[i] == URI.class) {
                    data2.urlIndex(i);
                    continue;
                }
                if (isHttpAnnotation || Request.Options.class.isAssignableFrom(parameterTypes[i])) continue;
                if (data2.isAlreadyProcessed(i)) {
                    Util.checkState(data2.formParams().isEmpty() || data2.bodyIndex() == null, "Body parameters cannot be used with form parameters.%s", data2.warnings());
                    continue;
                }
                if (data2.alwaysEncodeBody()) continue;
                Util.checkState(data2.formParams().isEmpty(), "Body parameters cannot be used with form parameters.%s", data2.warnings());
                Util.checkState(data2.bodyIndex() == null, "Method has too many Body parameters: %s%s", method, data2.warnings());
                data2.bodyIndex(i);
                data2.bodyType(Types.resolve(targetType, targetType, genericParameterTypes[i]));
            }
            if (data2.headerMapIndex() != null && Map.class.isAssignableFrom(parameterTypes[data2.headerMapIndex()])) {
                BaseContract.checkMapKeys("HeaderMap", genericParameterTypes[data2.headerMapIndex()]);
            }
            if (data2.queryMapIndex() != null && Map.class.isAssignableFrom(parameterTypes[data2.queryMapIndex()])) {
                BaseContract.checkMapKeys("QueryMap", genericParameterTypes[data2.queryMapIndex()]);
            }
            return data2;
        }

        private static void checkMapString(String name, Class<?> type2, Type genericType) {
            Util.checkState(Map.class.isAssignableFrom(type2), "%s parameter must be a Map: %s", name, type2);
            BaseContract.checkMapKeys(name, genericType);
        }

        private static void checkMapKeys(String name, Type genericType) {
            Class keyClass = null;
            if (ParameterizedType.class.isAssignableFrom(genericType.getClass())) {
                Type[] parameterTypes = ((ParameterizedType)genericType).getActualTypeArguments();
                keyClass = (Class)parameterTypes[0];
            } else if (genericType instanceof Class) {
                Type[] interfaces;
                for (Type extended : interfaces = ((Class)genericType).getGenericInterfaces()) {
                    if (!ParameterizedType.class.isAssignableFrom(extended.getClass())) continue;
                    Type[] parameterTypes = ((ParameterizedType)extended).getActualTypeArguments();
                    keyClass = (Class)parameterTypes[0];
                    break;
                }
            }
            if (keyClass != null) {
                Util.checkState(String.class.equals(keyClass), "%s key must be a String: %s", name, keyClass.getSimpleName());
            }
        }

        protected abstract void processAnnotationOnClass(MethodMetadata var1, Class<?> var2);

        protected abstract void processAnnotationOnMethod(MethodMetadata var1, Annotation var2, Method var3);

        protected abstract boolean processAnnotationsOnParameter(MethodMetadata var1, Annotation[] var2, int var3);

        protected void nameParam(MethodMetadata data2, String name, int i) {
            ArrayList<String> names = data2.indexToName().containsKey(i) ? data2.indexToName().get(i) : new ArrayList<String>();
            names.add(name);
            data2.indexToName().put(i, names);
        }
    }
}

