/*
 * Decompiled with CFR 0.152.
 */
package feign;

import feign.AsyncContextSupplier;
import feign.Contract;
import feign.DefaultMethodHandler;
import feign.Feign;
import feign.InvocationHandlerFactory;
import feign.MethodMetadata;
import feign.Param;
import feign.QueryMapEncoder;
import feign.Request;
import feign.RequestTemplate;
import feign.Target;
import feign.Util;
import feign.codec.Decoder;
import feign.codec.EncodeException;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.template.UriUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class ReflectiveFeign<C>
extends Feign {
    private final ParseHandlersByName<C> targetToHandlersByName;
    private final InvocationHandlerFactory factory;
    private final AsyncContextSupplier<C> defaultContextSupplier;

    ReflectiveFeign(ParseHandlersByName<C> targetToHandlersByName, InvocationHandlerFactory factory, AsyncContextSupplier<C> defaultContextSupplier) {
        this.targetToHandlersByName = targetToHandlersByName;
        this.factory = factory;
        this.defaultContextSupplier = defaultContextSupplier;
    }

    @Override
    public <T> T newInstance(Target<T> target) {
        return this.newInstance(target, this.defaultContextSupplier.newContext());
    }

    public <T> T newInstance(Target<T> target, C requestContext) {
        TargetSpecificationVerifier.verify(target);
        Map<String, InvocationHandlerFactory.MethodHandler> nameToHandler = this.targetToHandlersByName.apply(target, requestContext);
        LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler> methodToHandler = new LinkedHashMap<Method, InvocationHandlerFactory.MethodHandler>();
        LinkedList<DefaultMethodHandler> defaultMethodHandlers = new LinkedList<DefaultMethodHandler>();
        for (Method method : target.type().getMethods()) {
            if (method.getDeclaringClass() == Object.class) continue;
            if (Util.isDefault(method)) {
                DefaultMethodHandler handler = new DefaultMethodHandler(method);
                defaultMethodHandlers.add(handler);
                methodToHandler.put(method, handler);
                continue;
            }
            methodToHandler.put(method, nameToHandler.get(Feign.configKey(target.type(), method)));
        }
        InvocationHandler handler = this.factory.create(target, methodToHandler);
        Object proxy = Proxy.newProxyInstance(target.type().getClassLoader(), new Class[]{target.type()}, handler);
        for (DefaultMethodHandler defaultMethodHandler : defaultMethodHandlers) {
            defaultMethodHandler.bindTo(proxy);
        }
        return (T)proxy;
    }

    private static class TargetSpecificationVerifier {
        private TargetSpecificationVerifier() {
        }

        public static <T> void verify(Target<T> target) {
            Class<T> type2 = target.type();
            if (!type2.isInterface()) {
                throw new IllegalArgumentException("Type must be an interface: " + type2);
            }
            for (Method m : type2.getMethods()) {
                Class<?> retType = m.getReturnType();
                if (!CompletableFuture.class.isAssignableFrom(retType)) continue;
                if (retType != CompletableFuture.class) {
                    throw new IllegalArgumentException("Method return type is not CompleteableFuture: " + TargetSpecificationVerifier.getFullMethodName(type2, retType, m));
                }
                Type genRetType = m.getGenericReturnType();
                if (!(genRetType instanceof ParameterizedType)) {
                    throw new IllegalArgumentException("Method return type is not parameterized: " + TargetSpecificationVerifier.getFullMethodName(type2, genRetType, m));
                }
                if (!(((ParameterizedType)genRetType).getActualTypeArguments()[0] instanceof WildcardType)) continue;
                throw new IllegalArgumentException("Wildcards are not supported for return-type parameters: " + TargetSpecificationVerifier.getFullMethodName(type2, genRetType, m));
            }
        }

        private static String getFullMethodName(Class<?> type2, Type retType, Method m) {
            return retType.getTypeName() + " " + type2.toGenericString() + "." + m.getName();
        }
    }

    private static class BuildEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        private BuildEncodedTemplateFromArgs(MethodMetadata metadata2, Encoder encoder, QueryMapEncoder queryMapEncoder, Target target) {
            super(metadata2, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            boolean alwaysEncodeBody = mutable.methodMetadata().alwaysEncodeBody();
            Object[] body = null;
            if (!alwaysEncodeBody) {
                body = argv[this.metadata.bodyIndex()];
                Util.checkArgument(body != null, "Body parameter %s was null", this.metadata.bodyIndex());
            }
            try {
                if (alwaysEncodeBody) {
                    body = argv == null ? new Object[]{} : argv;
                    this.encoder.encode(body, (Type)((Object)Object[].class), mutable);
                } else {
                    this.encoder.encode(body, this.metadata.bodyType(), mutable);
                }
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    private static class BuildFormEncodedTemplateFromArgs
    extends BuildTemplateByResolvingArgs {
        private final Encoder encoder;

        private BuildFormEncodedTemplateFromArgs(MethodMetadata metadata2, Encoder encoder, QueryMapEncoder queryMapEncoder, Target target) {
            super(metadata2, queryMapEncoder, target);
            this.encoder = encoder;
        }

        @Override
        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            LinkedHashMap<String, Object> formVariables = new LinkedHashMap<String, Object>();
            for (Map.Entry<String, Object> entry : variables.entrySet()) {
                if (!this.metadata.formParams().contains(entry.getKey())) continue;
                formVariables.put(entry.getKey(), entry.getValue());
            }
            try {
                this.encoder.encode(formVariables, Encoder.MAP_STRING_WILDCARD, mutable);
            }
            catch (EncodeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new EncodeException(e.getMessage(), e);
            }
            return super.resolve(argv, mutable, variables);
        }
    }

    private static class BuildTemplateByResolvingArgs
    implements RequestTemplate.Factory {
        private final QueryMapEncoder queryMapEncoder;
        protected final MethodMetadata metadata;
        protected final Target<?> target;
        private final Map<Integer, Param.Expander> indexToExpander = new LinkedHashMap<Integer, Param.Expander>();

        private BuildTemplateByResolvingArgs(MethodMetadata metadata2, QueryMapEncoder queryMapEncoder, Target target) {
            this.metadata = metadata2;
            this.target = target;
            this.queryMapEncoder = queryMapEncoder;
            if (metadata2.indexToExpander() != null) {
                this.indexToExpander.putAll(metadata2.indexToExpander());
                return;
            }
            if (metadata2.indexToExpanderClass().isEmpty()) {
                return;
            }
            for (Map.Entry<Integer, Class<? extends Param.Expander>> indexToExpanderClass : metadata2.indexToExpanderClass().entrySet()) {
                try {
                    this.indexToExpander.put(indexToExpanderClass.getKey(), indexToExpanderClass.getValue().newInstance());
                }
                catch (InstantiationException e) {
                    throw new IllegalStateException(e);
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
        }

        @Override
        public RequestTemplate create(Object[] argv) {
            Object value;
            RequestTemplate mutable = RequestTemplate.from(this.metadata.template());
            mutable.feignTarget(this.target);
            if (this.metadata.urlIndex() != null) {
                int urlIndex = this.metadata.urlIndex();
                Util.checkArgument(argv[urlIndex] != null, "URI parameter %s was null", urlIndex);
                mutable.target(String.valueOf(argv[urlIndex]));
            }
            LinkedHashMap<String, Object> varBuilder = new LinkedHashMap<String, Object>();
            for (Map.Entry<Integer, Collection<String>> entry : this.metadata.indexToName().entrySet()) {
                int i = entry.getKey();
                Object value2 = argv[entry.getKey()];
                if (value2 == null) continue;
                if (this.indexToExpander.containsKey(i)) {
                    value2 = this.expandElements(this.indexToExpander.get(i), value2);
                }
                for (String name : entry.getValue()) {
                    varBuilder.put(name, value2);
                }
            }
            RequestTemplate template = this.resolve(argv, mutable, varBuilder);
            if (this.metadata.queryMapIndex() != null) {
                value = argv[this.metadata.queryMapIndex()];
                Map<String, Object> queryMap = this.toQueryMap(value);
                template = this.addQueryMapQueryParameters(queryMap, template);
            }
            if (this.metadata.headerMapIndex() != null) {
                value = argv[this.metadata.headerMapIndex()];
                Map<String, Object> headerMap = this.toQueryMap(value);
                template = this.addHeaderMapHeaders(headerMap, template);
            }
            return template;
        }

        private Map<String, Object> toQueryMap(Object value) {
            if (value instanceof Map) {
                return (Map)value;
            }
            try {
                return this.queryMapEncoder.encode(value);
            }
            catch (EncodeException e) {
                throw new IllegalStateException(e);
            }
        }

        private Object expandElements(Param.Expander expander, Object value) {
            if (value instanceof Iterable) {
                return this.expandIterable(expander, (Iterable)value);
            }
            return expander.expand(value);
        }

        private List<String> expandIterable(Param.Expander expander, Iterable value) {
            ArrayList<String> values2 = new ArrayList<String>();
            for (Object element : value) {
                if (element == null) continue;
                values2.add(expander.expand(element));
            }
            return values2;
        }

        private RequestTemplate addHeaderMapHeaders(Map<String, Object> headerMap, RequestTemplate mutable) {
            for (Map.Entry<String, Object> currEntry : headerMap.entrySet()) {
                ArrayList<String> values2 = new ArrayList<String>();
                Object currValue = currEntry.getValue();
                if (currValue instanceof Iterable) {
                    for (Object nextObject : (Iterable)currValue) {
                        values2.add(nextObject == null ? null : nextObject.toString());
                    }
                } else {
                    values2.add(currValue == null ? null : currValue.toString());
                }
                mutable.header(currEntry.getKey(), values2);
            }
            return mutable;
        }

        private RequestTemplate addQueryMapQueryParameters(Map<String, Object> queryMap, RequestTemplate mutable) {
            for (Map.Entry<String, Object> currEntry : queryMap.entrySet()) {
                ArrayList<String> values2 = new ArrayList<String>();
                Object currValue = currEntry.getValue();
                if (currValue instanceof Iterable) {
                    for (Object nextObject : (Iterable)currValue) {
                        values2.add(nextObject == null ? null : UriUtils.encode(nextObject.toString()));
                    }
                } else if (currValue instanceof Object[]) {
                    for (Object value : (Object[])currValue) {
                        values2.add(value == null ? null : UriUtils.encode(value.toString()));
                    }
                } else if (currValue != null) {
                    values2.add(UriUtils.encode(currValue.toString()));
                }
                if (values2.size() <= 0) continue;
                mutable.query(UriUtils.encode(currEntry.getKey()), values2);
            }
            return mutable;
        }

        protected RequestTemplate resolve(Object[] argv, RequestTemplate mutable, Map<String, Object> variables) {
            return mutable.resolve(variables);
        }
    }

    static final class ParseHandlersByName<C> {
        private final Contract contract;
        private final Request.Options options;
        private final Encoder encoder;
        private final Decoder decoder;
        private final ErrorDecoder errorDecoder;
        private final QueryMapEncoder queryMapEncoder;
        private final InvocationHandlerFactory.MethodHandler.Factory<C> factory;

        ParseHandlersByName(Contract contract, Request.Options options, Encoder encoder, Decoder decoder, QueryMapEncoder queryMapEncoder, ErrorDecoder errorDecoder, InvocationHandlerFactory.MethodHandler.Factory<C> factory) {
            this.contract = contract;
            this.options = options;
            this.factory = factory;
            this.errorDecoder = errorDecoder;
            this.queryMapEncoder = queryMapEncoder;
            this.encoder = Util.checkNotNull(encoder, "encoder", new Object[0]);
            this.decoder = Util.checkNotNull(decoder, "decoder", new Object[0]);
        }

        public Map<String, InvocationHandlerFactory.MethodHandler> apply(Target target, C requestContext) {
            List<MethodMetadata> metadata2 = this.contract.parseAndValidateMetadata(target.type());
            LinkedHashMap<String, InvocationHandlerFactory.MethodHandler> result2 = new LinkedHashMap<String, InvocationHandlerFactory.MethodHandler>();
            for (MethodMetadata md : metadata2) {
                BuildTemplateByResolvingArgs buildTemplate = !md.formParams().isEmpty() && md.template().bodyTemplate() == null ? new BuildFormEncodedTemplateFromArgs(md, this.encoder, this.queryMapEncoder, target) : (md.bodyIndex() != null || md.alwaysEncodeBody() ? new BuildEncodedTemplateFromArgs(md, this.encoder, this.queryMapEncoder, target) : new BuildTemplateByResolvingArgs(md, this.queryMapEncoder, target));
                if (md.isIgnored()) {
                    result2.put(md.configKey(), args2 -> {
                        throw new IllegalStateException(md.configKey() + " is not a method handled by feign");
                    });
                    continue;
                }
                result2.put(md.configKey(), this.factory.create(target, md, buildTemplate, this.options, this.decoder, this.errorDecoder, requestContext));
            }
            return result2;
        }
    }

    static class FeignInvocationHandler
    implements InvocationHandler {
        private final Target target;
        private final Map<Method, InvocationHandlerFactory.MethodHandler> dispatch;

        FeignInvocationHandler(Target target, Map<Method, InvocationHandlerFactory.MethodHandler> dispatch) {
            this.target = Util.checkNotNull(target, "target", new Object[0]);
            this.dispatch = Util.checkNotNull(dispatch, "dispatch for %s", target);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
            if ("equals".equals(method.getName())) {
                try {
                    InvocationHandler otherHandler = args2.length > 0 && args2[0] != null ? Proxy.getInvocationHandler(args2[0]) : null;
                    return this.equals(otherHandler);
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if ("hashCode".equals(method.getName())) {
                return this.hashCode();
            }
            if ("toString".equals(method.getName())) {
                return this.toString();
            }
            return this.dispatch.get(method).invoke(args2);
        }

        public boolean equals(Object obj) {
            if (obj instanceof FeignInvocationHandler) {
                FeignInvocationHandler other = (FeignInvocationHandler)obj;
                return this.target.equals(other.target);
            }
            return false;
        }

        public int hashCode() {
            return this.target.hashCode();
        }

        public String toString() {
            return this.target.toString();
        }
    }
}

